/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.BitVectorBase;
import com.ibm.wala.util.intset.Bits;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitVector
extends BitVectorBase<BitVector> {
    private static final long serialVersionUID = 9087259335807761617L;
    private static final int MAX_BITS = 0x1FFFFFFF;

    public BitVector() {
        this(1);
    }

    public BitVector(int n) {
        if (n > 0x1FFFFFFF || n < 0) {
            throw new IllegalArgumentException("invalid nbits: " + n);
        }
        this.bits = new int[BitVector.subscript(n) + 1];
    }

    void expand(int n) {
        int[] nArray = this.bits;
        this.bits = new int[BitVector.subscript(n) + 1];
        int n2 = 0;
        while (n2 < nArray.length) {
            this.bits[n2] = nArray[n2];
            ++n2;
        }
    }

    public BitVector(BitVector bitVector) {
        if (bitVector == null) {
            throw new IllegalArgumentException("s is null");
        }
        this.bits = new int[bitVector.bits.length];
        this.copyBits(bitVector);
    }

    @Override
    public final void set(int n) {
        int n2 = n & 0x1F;
        int n3 = BitVector.subscript(n);
        if (n3 >= this.bits.length) {
            this.expand(n);
        }
        try {
            int n4 = n3;
            this.bits[n4] = this.bits[n4] | 1 << n2;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    @Override
    public final void clear(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid bit: " + n);
        }
        int n2 = BitVector.subscript(n);
        if (n2 >= this.bits.length) {
            return;
        }
        int n3 = n & 0x1F;
        int n4 = n2;
        this.bits[n4] = this.bits[n4] & ~(1 << n3);
    }

    @Override
    public final boolean get(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("illegal bit: " + n);
        }
        int n2 = BitVector.subscript(n);
        if (n2 >= this.bits.length) {
            return false;
        }
        int n3 = n & 0x1F;
        return (this.bits[n2] & 1 << n3) != 0;
    }

    public static BitVector not(BitVector bitVector) {
        BitVector bitVector2 = new BitVector(bitVector);
        bitVector2.not();
        return bitVector2;
    }

    @Override
    public final void and(BitVector bitVector) {
        if (bitVector == null) {
            throw new IllegalArgumentException("null set");
        }
        if (this == bitVector) {
            return;
        }
        int n = Math.min(this.bits.length, bitVector.bits.length);
        int n2 = n - 1;
        while (n2 >= 0) {
            int n3 = n2;
            this.bits[n3] = this.bits[n3] & bitVector.bits[n2];
            --n2;
        }
        n2 = n;
        while (n2 < this.bits.length) {
            this.bits[n2] = 0;
            ++n2;
        }
    }

    public static BitVector and(BitVector bitVector, BitVector bitVector2) {
        if (bitVector == null) {
            throw new IllegalArgumentException("null b1");
        }
        if (bitVector2 == null) {
            throw new IllegalArgumentException("null b2");
        }
        BitVector bitVector3 = new BitVector(bitVector);
        bitVector3.and(bitVector2);
        return bitVector3;
    }

    @Override
    public final void or(BitVector bitVector) {
        if (bitVector == null) {
            throw new IllegalArgumentException("null set");
        }
        if (this == bitVector) {
            return;
        }
        this.ensureCapacity(bitVector);
        int n = Math.min(this.bits.length, bitVector.bits.length);
        int n2 = n - 1;
        while (n2 >= 0) {
            int n3 = n2;
            this.bits[n3] = this.bits[n3] | bitVector.bits[n2];
            --n2;
        }
    }

    private void ensureCapacity(BitVector bitVector) {
        if (bitVector.bits.length > this.bits.length) {
            this.expand(32 * bitVector.bits.length - 1);
        }
    }

    public final int orWithDelta(BitVector bitVector) {
        if (bitVector == null) {
            throw new IllegalArgumentException("set is null");
        }
        int n = 0;
        this.ensureCapacity(bitVector);
        int[] nArray = bitVector.bits;
        int n2 = Math.min(this.bits.length, nArray.length);
        int n3 = n2 - 1;
        while (n3 >= 0) {
            int n4 = this.bits[n3];
            int n5 = nArray[n3];
            if (n4 != n5) {
                n -= Bits.populationCount(n4);
                int n6 = n4 | n5;
                n += Bits.populationCount(n6);
                this.bits[n3] = n6;
            }
            --n3;
        }
        return n;
    }

    public static BitVector or(BitVector bitVector, BitVector bitVector2) {
        if (bitVector == null) {
            throw new IllegalArgumentException("null b1");
        }
        if (bitVector2 == null) {
            throw new IllegalArgumentException("null b2");
        }
        BitVector bitVector3 = new BitVector(bitVector);
        bitVector3.or(bitVector2);
        return bitVector3;
    }

    public static BitVector xor(BitVector bitVector, BitVector bitVector2) {
        if (bitVector == null) {
            throw new IllegalArgumentException("null b1");
        }
        if (bitVector2 == null) {
            throw new IllegalArgumentException("null b2");
        }
        BitVector bitVector3 = new BitVector(bitVector);
        bitVector3.xor(bitVector2);
        return bitVector3;
    }

    @Override
    public final void xor(BitVector bitVector) {
        if (bitVector == null) {
            throw new IllegalArgumentException("set is null");
        }
        this.ensureCapacity(bitVector);
        int n = Math.min(this.bits.length, bitVector.bits.length);
        int n2 = n - 1;
        while (n2 >= 0) {
            int n3 = n2;
            this.bits[n3] = this.bits[n3] ^ bitVector.bits[n2];
            --n2;
        }
    }

    @Override
    public final boolean intersectionEmpty(BitVector bitVector) {
        if (bitVector == null) {
            throw new IllegalArgumentException("other is null");
        }
        int n = Math.min(this.bits.length, bitVector.bits.length);
        int n2 = n - 1;
        while (n2 >= 0) {
            if ((this.bits[n2] & bitVector.bits[n2]) != 0) {
                return false;
            }
            --n2;
        }
        return true;
    }

    @Override
    public final int length() {
        return this.bits.length << 5;
    }

    @Override
    public final boolean sameBits(BitVector bitVector) {
        int n;
        if (bitVector == null) {
            throw new IllegalArgumentException("null B");
        }
        if (this == bitVector) {
            return true;
        }
        int n2 = Math.min(this.bits.length, bitVector.bits.length);
        if (this.bits.length > bitVector.bits.length) {
            n = n2;
            while (n < this.bits.length) {
                if (this.bits[n] != 0) {
                    return false;
                }
                ++n;
            }
        } else if (bitVector.bits.length > this.bits.length) {
            n = n2;
            while (n < bitVector.bits.length) {
                if (bitVector.bits[n] != 0) {
                    return false;
                }
                ++n;
            }
        }
        n = n2 - 1;
        while (n >= 0) {
            if (this.bits[n] != bitVector.bits[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    @Override
    public boolean isSubset(BitVector bitVector) {
        if (bitVector == null) {
            throw new IllegalArgumentException("null other");
        }
        if (this == bitVector) {
            return true;
        }
        int n = 0;
        while (n < this.bits.length) {
            if (n >= bitVector.bits.length ? this.bits[n] != 0 : (this.bits[n] & ~bitVector.bits[n]) != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public void andNot(BitVector bitVector) {
        if (bitVector == null) {
            throw new IllegalArgumentException("null vector");
        }
        int n = 0;
        int n2 = 0;
        n = 0;
        n2 = 0;
        while (n < this.bits.length && n2 < bitVector.bits.length) {
            this.bits[n] = this.bits[n] & ~bitVector.bits[n2];
            ++n;
            ++n2;
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof BitVector) {
            if (this == object) {
                return true;
            }
            BitVector bitVector = (BitVector)object;
            return this.sameBits(bitVector);
        }
        return false;
    }

    public final void setAll() {
        int n = 0;
        while (n < this.bits.length) {
            this.bits[n] = -1;
            ++n;
        }
    }

    public final void not() {
        int n = 0;
        while (n < this.bits.length) {
            int n2 = n++;
            this.bits[n2] = ~this.bits[n2];
        }
    }

    public static BitVector andNot(BitVector bitVector, BitVector bitVector2) {
        BitVector bitVector3 = new BitVector(bitVector);
        bitVector3.andNot(bitVector2);
        return bitVector3;
    }
}

