/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BitSet<T> {
    private final BitVector vector;
    private OrdinalSetMapping<T> map;

    public BitSet(OrdinalSetMapping<T> ordinalSetMapping) {
        if (ordinalSetMapping == null) {
            throw new IllegalArgumentException("map is null");
        }
        int n = ordinalSetMapping.getMaximumIndex();
        this.vector = new BitVector(n);
        this.map = ordinalSetMapping;
    }

    public static <T> BitSet<T> createBitSet(BitSet<T> bitSet) {
        if (bitSet == null) {
            throw new IllegalArgumentException("null B");
        }
        return new BitSet<T>(bitSet);
    }

    private BitSet(BitSet<T> bitSet) {
        this(bitSet.map);
        this.addAll(bitSet);
    }

    public void addAll(BitSet<?> bitSet) {
        if (bitSet == null) {
            throw new IllegalArgumentException("B is null");
        }
        this.vector.or(bitSet.vector);
    }

    public void addAll(BitVector bitVector) {
        this.vector.or(bitVector);
    }

    public void add(T t) {
        int n = this.map.getMappedIndex(t);
        this.vector.set(n);
    }

    public void clear(T t) {
        int n = this.map.getMappedIndex(t);
        if (n == -1) {
            return;
        }
        this.vector.clear(n);
    }

    public boolean contains(T t) {
        int n = this.map.getMappedIndex(t);
        if (n == -1) {
            return false;
        }
        return this.vector.get(n);
    }

    public String toString() {
        return this.vector.toString();
    }

    public void copyBits(BitSet<T> bitSet) {
        if (bitSet == null) {
            throw new IllegalArgumentException("other is null");
        }
        this.vector.copyBits(bitSet.vector);
        this.map = bitSet.map;
    }

    public boolean sameBits(BitSet<?> bitSet) {
        if (bitSet == null) {
            throw new IllegalArgumentException("other is null");
        }
        return this.vector.equals(bitSet.vector);
    }

    public Iterator iterator() {
        return new Iterator(){
            private int next = -1;
            {
                int n = 0;
                while (n < BitSet.this.vector.length()) {
                    if (BitSet.this.vector.get(n)) {
                        this.next = n;
                        break;
                    }
                    ++n;
                }
            }

            public boolean hasNext() {
                return this.next != -1;
            }

            public Object next() {
                Object t = BitSet.this.map.getMappedObject(this.next);
                int n = this.next + 1;
                this.next = -1;
                int n2 = n;
                while (n2 < BitSet.this.vector.length()) {
                    if (BitSet.this.vector.get(n2)) {
                        this.next = n2;
                        break;
                    }
                    ++n2;
                }
                return t;
            }

            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    public int size() {
        return this.vector.populationCount();
    }

    public int length() {
        return this.vector.length();
    }

    public void clearAll() {
        this.vector.clearAll();
    }

    public void setAll() {
        this.vector.setAll();
    }

    public void intersect(BitSet<?> bitSet) {
        if (bitSet == null) {
            throw new IllegalArgumentException("other is null");
        }
        this.vector.and(bitSet.vector);
    }

    public void difference(BitSet<T> bitSet) {
        if (bitSet == null) {
            throw new IllegalArgumentException("other is null");
        }
        this.vector.and(BitVector.not(bitSet.vector));
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

