/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloydWarshall<T> {
    protected final NumberedGraph<T> G;

    public FloydWarshall(NumberedGraph<T> numberedGraph) {
        this.G = numberedGraph;
    }

    protected int edgeCost(int n, int n2) {
        return 1;
    }

    protected void pathCallback(int n, int n2, int n3) {
    }

    int[][] allPairsShortestPaths() {
        int n;
        final int[][] nArray = new int[this.G.getNumberOfNodes()][this.G.getNumberOfNodes()];
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = 0;
            while (n3 < nArray[n2].length) {
                nArray[n2][n3] = Integer.MAX_VALUE;
                ++n3;
            }
            ++n2;
        }
        for (Object t : this.G) {
            n = this.G.getNumber(t);
            IntSet intSet = this.G.getSuccNodeNumbers(t);
            intSet.foreach(new IntSetAction(){

                public void act(int n2) {
                    nArray[n][n2] = FloydWarshall.this.edgeCost(n, n2);
                }
            });
        }
        for (Object t : this.G) {
            n = this.G.getNumber(t);
            for (IntSet intSet : this.G) {
                int n4 = this.G.getNumber(intSet);
                for (Object t2 : this.G) {
                    int n5 = this.G.getNumber(t2);
                    long l = (long)nArray[n4][n] + (long)nArray[n][n5];
                    if (l <= (long)nArray[n4][n5]) {
                        this.pathCallback(n4, n5, n);
                    }
                    if (l >= (long)nArray[n4][n5]) continue;
                    nArray[n4][n5] = (int)l;
                }
            }
        }
        return nArray;
    }

    public static <T> int[][] shortestPathLengths(NumberedGraph<T> numberedGraph) {
        return new FloydWarshall<T>(numberedGraph).allPairsShortestPaths();
    }

    public static <T> GetPath<T> allPairsShortestPath(NumberedGraph<T> numberedGraph) {
        return (new FloydWarshall<T>((NumberedGraph)numberedGraph){
            int[][] next;
            {
                this.next = new int[this.G.getNumberOfNodes()][this.G.getNumberOfNodes()];
            }

            @Override
            protected void pathCallback(int n, int n2, int n3) {
                this.next[n][n2] = n3;
            }

            private GetPath<T> doit() {
                int n = 0;
                while (n < this.next.length) {
                    int n2 = 0;
                    while (n2 < this.next[n].length) {
                        this.next[n][n2] = -1;
                        ++n2;
                    }
                    ++n;
                }
                final int[][] nArray = this.allPairsShortestPaths();
                return new GetPath<T>(){

                    @Override
                    public List<T> getPath(T t, T t2) {
                        int n;
                        int n2 = G.getNumber(t);
                        if (nArray[n2][n = G.getNumber(t2)] == Integer.MAX_VALUE) {
                            throw new UnsupportedOperationException("no path from " + t + " to " + t2);
                        }
                        int n3 = next[n2][n];
                        if (n3 == -1) {
                            return Collections.emptyList();
                        }
                        Object t3 = G.getNode(n3);
                        LinkedList linkedList = new LinkedList(this.getPath(t, t3));
                        linkedList.add(t3);
                        linkedList.addAll(this.getPath(t3, t2));
                        return linkedList;
                    }
                };
            }
        }).doit();
    }

    public static <T> GetPaths<T> allPairsShortestPaths(NumberedGraph<T> numberedGraph) {
        return (new FloydWarshall<T>((NumberedGraph)numberedGraph){
            MutableIntSet[][] next;
            {
                this.next = new MutableIntSet[this.G.getNumberOfNodes()][this.G.getNumberOfNodes()];
            }

            @Override
            protected void pathCallback(int n, int n2, int n3) {
                if (this.next[n][n2] == null) {
                    this.next[n][n2] = IntSetUtil.make();
                }
                this.next[n][n2].add(n3);
            }

            private GetPaths<T> doit() {
                final int[][] nArray = this.allPairsShortestPaths();
                return new GetPaths<T>(){

                    @Override
                    public Set<List<T>> getPaths(final T t, final T t2) {
                        int n;
                        int n2 = G.getNumber(t);
                        if (nArray[n2][n = G.getNumber(t2)] == Integer.MAX_VALUE) {
                            throw new UnsupportedOperationException("no path from " + t + " to " + t2);
                        }
                        MutableIntSet mutableIntSet = next[n2][n];
                        if (mutableIntSet == null) {
                            List list = Collections.emptyList();
                            return Collections.singleton(list);
                        }
                        final HashSet hashSet = new HashSet();
                        mutableIntSet.foreach(new IntSetAction(){

                            public void act(int n) {
                                Object t3 = G.getNode(n);
                                for (List list : this.getPaths(t, t3)) {
                                    for (List list2 : this.getPaths(t3, t2)) {
                                        LinkedList linkedList = new LinkedList(list);
                                        linkedList.add(t3);
                                        linkedList.addAll(list2);
                                        hashSet.add(linkedList);
                                    }
                                }
                            }
                        });
                        return hashSet;
                    }
                };
            }
        }).doit();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface GetPath<T> {
        public List<T> getPath(T var1, T var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface GetPaths<T> {
        public Set<List<T>> getPaths(T var1, T var2);
    }
}

