/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.graph.Graph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFSPathFinder<T>
extends Stack<T> {
    public static final long serialVersionUID = 9939900773328288L;
    private final Graph<T> G;
    private final Filter<T> filter;
    private final Iterator<T> roots;
    private final Map<T, Iterator<? extends T>> pendingChildren = HashMapFactory.make(25);
    private boolean initialized = false;

    public DFSPathFinder(Graph<T> graph, T t, Filter<T> filter) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (!graph.containsNode(t)) {
            throw new IllegalArgumentException("source node not in graph: " + t);
        }
        this.G = graph;
        this.roots = new NonNullSingletonIterator<T>(t);
        this.filter = filter;
    }

    public DFSPathFinder(Graph<T> graph, Iterator<T> iterator, Filter<T> filter) {
        this.G = graph;
        this.roots = iterator;
        this.filter = filter;
        if (graph == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (this.roots == null) {
            throw new IllegalArgumentException("roots is null");
        }
        if (this.filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
    }

    private void init() {
        this.initialized = true;
        if (this.roots.hasNext()) {
            T t = this.roots.next();
            this.push(t);
            this.setPendingChildren(t, this.getConnected(t));
        }
    }

    public List<T> find() {
        if (!this.initialized) {
            this.init();
        }
        while (this.hasNext()) {
            Object e = this.peek();
            if (this.filter.accepts(e)) {
                List<T> list = this.currentPath();
                this.advance();
                return list;
            }
            this.advance();
        }
        return null;
    }

    private List<T> currentPath() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.add(0, iterator.next());
        }
        return arrayList;
    }

    public boolean hasNext() {
        return !this.empty();
    }

    private Iterator<? extends T> getPendingChildren(T t) {
        return this.pendingChildren.get(t);
    }

    private void setPendingChildren(T t, Iterator<? extends T> iterator) {
        this.pendingChildren.put(t, iterator);
    }

    private void advance() {
        Object object;
        Object e = this.peek();
        assert (this.getPendingChildren(e) != null);
        do {
            object = this.peek();
            Iterator iterator = this.getPendingChildren(object);
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (this.getPendingChildren(e2) != null) continue;
                this.setPendingChildren(e2, this.getConnected(e2));
                this.push(e2);
                return;
            }
            this.pop();
        } while (!this.empty());
        while (this.roots.hasNext()) {
            object = this.roots.next();
            if (this.getPendingChildren(object) != null) continue;
            this.push(object);
            this.setPendingChildren(object, this.getConnected(object));
        }
    }

    protected Iterator<? extends T> getConnected(T t) {
        return this.G.getSuccNodes(t);
    }
}

