/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.UnimplementedError;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DFSDiscoverTimeIterator<T>
extends Stack<T>
implements Iterator<T> {
    private Iterator<? extends T> roots;

    protected void init(Iterator<? extends T> iterator) {
        this.roots = iterator;
        assert (iterator != null);
        if (this.roots.hasNext()) {
            T t = this.roots.next();
            this.push(t);
            this.setPendingChildren(t, this.getConnected(t));
        }
    }

    protected void init(T t) {
        this.init((T)new NonNullSingletonIterator<T>(t));
    }

    @Override
    public boolean hasNext() {
        return !this.empty();
    }

    protected abstract Iterator<? extends T> getPendingChildren(T var1);

    protected abstract void setPendingChildren(T var1, Iterator<? extends T> var2);

    @Override
    public T next() throws NoSuchElementException {
        Object object;
        if (this.empty()) {
            throw new NoSuchElementException();
        }
        Object e = this.peek();
        assert (this.getPendingChildren(e) != null);
        do {
            object = this.peek();
            Iterator iterator = this.getPendingChildren(object);
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (this.getPendingChildren(e2) != null) continue;
                this.visitEdge(object, e2);
                this.setPendingChildren(e2, this.getConnected(e2));
                this.push(e2);
                return (T)e;
            }
            iterator = EmptyIterator.instance();
            this.setPendingChildren(object, iterator);
            this.pop();
        } while (!this.empty());
        while (this.roots.hasNext()) {
            object = this.roots.next();
            if (this.getPendingChildren(object) != null) continue;
            this.push(object);
            this.setPendingChildren(object, this.getConnected(object));
            return (T)e;
        }
        return (T)e;
    }

    protected abstract Iterator<? extends T> getConnected(T var1);

    @Override
    public void remove() throws UnimplementedError {
        throw new UnimplementedError();
    }

    protected void visitEdge(T t, T t2) {
    }
}

