/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.traverse.DFSDiscoverTimeIterator;
import com.ibm.wala.util.graph.traverse.DFSFinishTimeIterator;
import com.ibm.wala.util.graph.traverse.NumberedDFSDiscoverTimeIterator;
import com.ibm.wala.util.graph.traverse.NumberedDFSFinishTimeIterator;
import com.ibm.wala.util.graph.traverse.SlowDFSDiscoverTimeIterator;
import com.ibm.wala.util.graph.traverse.SlowDFSFinishTimeIterator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFS {
    public static <T> Collection<T> getReachableNodes(final Graph<T> graph, Collection<? extends T> collection, final Filter filter) {
        if (collection == null) {
            throw new IllegalArgumentException("C is null");
        }
        SlowDFSFinishTimeIterator slowDFSFinishTimeIterator = new SlowDFSFinishTimeIterator<T>(graph, collection.iterator()){

            @Override
            protected Iterator<T> getConnected(T t) {
                return new FilterIterator(graph.getSuccNodes(t), filter);
            }
        };
        return Iterator2Collection.toSet(slowDFSFinishTimeIterator);
    }

    public static <T> Set<T> getReachableNodes(Graph<T> graph, Collection<? extends T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("C is null");
        }
        HashSet hashSet = HashSetFactory.make();
        DFSFinishTimeIterator<T> dFSFinishTimeIterator = DFS.iterateFinishTime(graph, collection.iterator());
        while (dFSFinishTimeIterator.hasNext()) {
            hashSet.add(dFSFinishTimeIterator.next());
        }
        return hashSet;
    }

    public static <T> Set<T> getReachableNodes(Graph<T> graph) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("G == null");
        }
        HashSet hashSet = HashSetFactory.make();
        DFSFinishTimeIterator<T> dFSFinishTimeIterator = DFS.iterateFinishTime(graph);
        while (dFSFinishTimeIterator.hasNext()) {
            hashSet.add(dFSFinishTimeIterator.next());
        }
        return hashSet;
    }

    public static <T> SortedSet<T> sortByDepthFirstOrder(Graph<T> graph, T t) {
        HashMap hashMap = HashMapFactory.make();
        TreeSet treeSet = new TreeSet(new DFSComparator(hashMap));
        DFSFinishTimeIterator<T> dFSFinishTimeIterator = DFS.iterateFinishTime(graph, new NonNullSingletonIterator<T>(t));
        int n = 0;
        while (dFSFinishTimeIterator.hasNext()) {
            Object e = dFSFinishTimeIterator.next();
            hashMap.put(e, new Integer(n++));
            treeSet.add(e);
        }
        return treeSet;
    }

    public static <T> DFSDiscoverTimeIterator iterateDiscoverTime(Graph<T> graph) {
        if (graph instanceof NumberedGraph) {
            return new NumberedDFSDiscoverTimeIterator((NumberedGraph)graph);
        }
        return new SlowDFSDiscoverTimeIterator<T>(graph);
    }

    public static <T> Iterator<T> iterateDiscoverTime(Graph<T> graph, Iterator<T> iterator) throws IllegalArgumentException {
        if (iterator == null) {
            throw new IllegalArgumentException("roots == null");
        }
        if (graph instanceof NumberedGraph) {
            return new NumberedDFSDiscoverTimeIterator<T>((NumberedGraph)graph, iterator);
        }
        return new SlowDFSDiscoverTimeIterator<T>(graph, iterator);
    }

    public static <T> DFSDiscoverTimeIterator<T> iterateDiscoverTime(Graph<T> graph, T t) {
        if (graph == null) {
            throw new IllegalArgumentException("G == null");
        }
        if (graph instanceof NumberedGraph) {
            return new NumberedDFSDiscoverTimeIterator<T>((NumberedGraph)graph, t);
        }
        return new SlowDFSDiscoverTimeIterator<T>(graph, t);
    }

    public static <T> DFSFinishTimeIterator<T> iterateFinishTime(Graph<T> graph) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("G == null");
        }
        if (graph instanceof NumberedGraph) {
            return new NumberedDFSFinishTimeIterator((NumberedGraph)graph);
        }
        return new SlowDFSFinishTimeIterator<T>(graph);
    }

    public static <T> DFSFinishTimeIterator<T> iterateFinishTime(Graph<T> graph, Iterator<? extends T> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("null ie");
        }
        if (graph instanceof NumberedGraph) {
            return new NumberedDFSFinishTimeIterator<T>((NumberedGraph)graph, iterator);
        }
        return new SlowDFSFinishTimeIterator<T>(graph, iterator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DFSComparator<T>
    implements Comparator<T> {
        private final Map<T, Integer> order;

        DFSComparator(Map<T, Integer> map) {
            this.order = map;
        }

        @Override
        public int compare(T t, T t2) {
            if (t == t2) {
                return 0;
            }
            Integer n = this.order.get(t);
            Integer n2 = this.order.get(t2);
            return n - n2;
        }
    }
}

