/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.graph.Graph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundedBFSIterator<T>
implements Iterator<T> {
    final ArrayList<T> Q = new ArrayList();
    final HashSet<T> visited = HashSetFactory.make();
    private int index = 0;
    protected Graph<T> G;
    private final int k;
    private final int[] boundary;
    private int currentHops = 0;

    public BoundedBFSIterator(Graph<T> graph, T t, int n) {
        if (graph == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("invalid k : " + n);
        }
        this.k = n;
        this.boundary = new int[n];
        this.init(graph, new NonNullSingletonIterator<T>(t));
    }

    public BoundedBFSIterator(Graph<T> graph, Iterator<? extends T> iterator, int n) {
        if (graph == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("invalid k: " + n);
        }
        this.k = n;
        this.boundary = new int[n];
        this.init(graph, iterator);
    }

    /*
     * Unable to fully structure code
     */
    private void init(Graph<T> var1_1, Iterator<? extends T> var2_2) {
        this.G = var1_1;
        if (var1_1.getNumberOfNodes() != 0) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            var3_3 = var2_2.next();
            if (this.visited.contains(var3_3)) continue;
            this.Q.add(var3_3);
            this.visited.add(var3_3);
lbl10:
            // 3 sources

            ** while (var2_2.hasNext())
        }
lbl11:
        // 1 sources

        this.index = 0;
        if (this.Q.size() > 0) {
            var3_3 = this.Q.get(0);
            this.visitChildren(var3_3);
        }
    }

    private void visitChildren(T t) {
        if (this.currentHops == this.k) {
            return;
        }
        if (this.boundary[this.currentHops] == 0) {
            this.boundary[this.currentHops] = this.Q.size();
        }
        Iterator<T> iterator = this.getConnected(t);
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (this.visited.contains(t2)) continue;
            this.Q.add(t2);
            this.visited.add(t2);
        }
    }

    @Override
    public boolean hasNext() {
        return this.Q.size() > this.index;
    }

    @Override
    public T next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T t = this.Q.get(this.index);
        ++this.index;
        if (this.currentHops < this.k && this.index == this.boundary[this.currentHops]) {
            ++this.currentHops;
        }
        if (this.hasNext()) {
            T t2 = this.Q.get(this.index);
            this.visitChildren(t2);
        }
        return t;
    }

    protected Iterator<? extends T> getConnected(T t) {
        return this.G.getSuccNodes(t);
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int getCurrentHops() {
        return this.currentHops;
    }
}

