/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.graph.Graph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BFSPathFinder<T> {
    private final boolean DEBUG = false;
    private final Graph<T> G;
    private final Filter<T> filter;
    private final Iterator<T> roots;

    public BFSPathFinder(Graph<T> graph, T t, Filter<T> filter) {
        if (graph == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("null f");
        }
        this.G = graph;
        this.roots = new NonNullSingletonIterator<T>(t);
        this.filter = filter;
    }

    public BFSPathFinder(Graph<T> graph, T t, final T t2) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("G is null");
        }
        this.G = graph;
        this.roots = new NonNullSingletonIterator<T>(t);
        if (!graph.containsNode(t)) {
            throw new IllegalArgumentException("src is not in graph " + t);
        }
        this.filter = new Filter<T>(){

            @Override
            public boolean accepts(T t) {
                return t2.equals(t);
            }
        };
    }

    public BFSPathFinder(Graph<T> graph, T t, Iterator<T> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("targets is null");
        }
        final HashSet hashSet = HashSetFactory.make();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        this.G = graph;
        this.roots = new NonNullSingletonIterator<T>(t);
        this.filter = new Filter<T>(){

            @Override
            public boolean accepts(T t) {
                return hashSet.contains(t);
            }
        };
    }

    public BFSPathFinder(Graph<T> graph, Iterator<T> iterator, final T t) {
        if (graph == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (iterator == null) {
            throw new IllegalArgumentException("sources is null");
        }
        this.G = graph;
        this.roots = iterator;
        this.filter = new Filter<T>(){

            @Override
            public boolean accepts(T t2) {
                return t.equals(t2);
            }
        };
    }

    public BFSPathFinder(Graph<T> graph, Iterator<T> iterator, Filter<T> filter) {
        this.G = graph;
        this.roots = iterator;
        this.filter = filter;
        if (graph == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (this.roots == null) {
            throw new IllegalArgumentException("roots is null");
        }
    }

    public List<T> find() {
        Object object;
        LinkedList<T> linkedList = new LinkedList<T>();
        HashMap<T, T> hashMap = HashMapFactory.make();
        while (this.roots.hasNext()) {
            object = this.roots.next();
            linkedList.addLast(object);
            hashMap.put(object, null);
        }
        while (!linkedList.isEmpty()) {
            object = linkedList.removeFirst();
            if (this.filter.accepts(object)) {
                return this.makePath(object, hashMap);
            }
            Iterator<T> iterator = this.getConnected(object);
            while (iterator.hasNext()) {
                T t = iterator.next();
                if (hashMap.containsKey(t)) continue;
                linkedList.addLast(t);
                hashMap.put(t, object);
            }
        }
        return null;
    }

    private List<T> makePath(T t, Map<Object, T> map) {
        ArrayList<T> arrayList = new ArrayList<T>();
        T t2 = t;
        arrayList.add(t2);
        T t3;
        while ((t3 = map.get(t2)) != null) {
            arrayList.add(t3);
            t2 = t3;
        }
        return arrayList;
    }

    protected Iterator<? extends T> getConnected(T t) {
        return this.G.getSuccNodes(t);
    }
}

