/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.impl;

import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.NumberedNodeIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableMapping;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlowNumberedNodeManager<T>
implements NumberedNodeManager<T> {
    private final MutableMapping<T> map = MutableMapping.make();

    @Override
    public int getNumber(T t) {
        return this.map.getMappedIndex(t);
    }

    @Override
    public T getNode(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("number must be >= 0");
        }
        T t = this.map.getMappedObject(n);
        return t;
    }

    @Override
    public int getMaxNumber() {
        return this.map.getMaximumIndex();
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.iterator();
    }

    @Override
    public int getNumberOfNodes() {
        return this.map.getSize();
    }

    @Override
    public void addNode(T t) {
        if (t == null) {
            throw new IllegalArgumentException("n is null");
        }
        this.map.add(t);
    }

    @Override
    public void removeNode(T t) {
        this.map.deleteMappedObject(t);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Nodes:\n");
        int n = 0;
        while (n <= this.getMaxNumber()) {
            stringBuffer.append(n).append("  ");
            stringBuffer.append(this.map.getMappedObject(n));
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean containsNode(T t) {
        return this.getNumber(t) != -1;
    }

    @Override
    public Iterator<T> iterateNodes(IntSet intSet) {
        return new NumberedNodeIterator(intSet, this);
    }
}

