/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.impl;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.INodeWithNumber;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.NumberedNodeIterator;
import com.ibm.wala.util.intset.IntSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingNumberedNodeManager<T extends INodeWithNumber>
implements NumberedNodeManager<T> {
    private final double BUFFER_FACTOR = 1.5;
    private INodeWithNumber[] nodes = new INodeWithNumber[20];
    private int maxNumber = -1;
    private int numberOfNodes = 0;

    @Override
    public int getNumber(T t) {
        if (t == null) {
            throw new IllegalArgumentException("N is null");
        }
        T t2 = t;
        return t2.getGraphNodeId();
    }

    @Override
    public T getNode(int n) {
        try {
            return (T)this.nodes[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid number " + n);
        }
    }

    @Override
    public int getMaxNumber() {
        return this.maxNumber;
    }

    @Override
    public Iterator<T> iterator() {
        final INodeWithNumber[] iNodeWithNumberArray = this.nodes;
        return new Iterator<T>(){
            int next = -1;
            {
                this.advance();
            }

            void advance() {
                int n = this.next + 1;
                while (n < iNodeWithNumberArray.length) {
                    if (iNodeWithNumberArray[n] != null) {
                        this.next = n;
                        return;
                    }
                    ++n;
                }
                this.next = -1;
            }

            @Override
            public boolean hasNext() {
                return this.next != -1;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    int n = this.next;
                    this.advance();
                    return iNodeWithNumberArray[n];
                }
                return null;
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    @Override
    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    @Override
    public void addNode(T t) {
        if (t == null) {
            throw new IllegalArgumentException("n is null");
        }
        T t2 = t;
        int n = t2.getGraphNodeId();
        if (n == -1) {
            ++this.maxNumber;
            t2.setGraphNodeId(this.maxNumber);
            n = this.maxNumber;
        } else if (n > this.maxNumber) {
            this.maxNumber = n;
        }
        this.ensureCapacity(n);
        if (this.nodes[n] != null && this.nodes[n] != t2) {
            Assertions.UNREACHABLE("number: " + n + " N: " + t2 + " nodes[number]: " + this.nodes[n]);
        }
        this.nodes[n] = t2;
        ++this.numberOfNodes;
    }

    private void ensureCapacity(int n) {
        if (this.nodes.length < n + 1) {
            int n2 = (int)((double)(n + 1) * 1.5);
            INodeWithNumber[] iNodeWithNumberArray = this.nodes;
            this.nodes = new INodeWithNumber[n2];
            System.arraycopy(iNodeWithNumberArray, 0, this.nodes, 0, iNodeWithNumberArray.length);
        }
    }

    @Override
    public void removeNode(T t) {
        if (t == null) {
            throw new IllegalArgumentException("n is null");
        }
        T t2 = t;
        int n = t2.getGraphNodeId();
        if (n == -1) {
            throw new IllegalArgumentException("Cannot remove node, not in graph");
        }
        if (this.nodes[n] != null) {
            this.nodes[n] = null;
            --this.numberOfNodes;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Nodes:\n");
        int n = 0;
        while (n < this.maxNumber) {
            stringBuffer.append(n).append(" ");
            if (this.nodes[n] != null) {
                stringBuffer.append(this.nodes[n].toString());
            }
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean containsNode(T t) {
        if (t == null) {
            throw new IllegalArgumentException("n is null");
        }
        T t2 = t;
        int n = t2.getGraphNodeId();
        if (n == -1) {
            return false;
        }
        if (n >= this.nodes.length) {
            throw new IllegalArgumentException("node already has a graph node id, but is not registered there in this graph (number too big)\nthis graph implementation is fragile and won't support this kind of test\n" + t.getClass() + " : " + t);
        }
        if (this.nodes[n] != t2) {
            throw new IllegalArgumentException("node already has a graph node id, but is not registered there in this graph\nthis graph implementation is fragile and won't support this kind of test\n" + t.getClass() + " : " + t);
        }
        return true;
    }

    @Override
    public Iterator<T> iterateNodes(IntSet intSet) {
        return new NumberedNodeIterator(intSet, this);
    }
}

