/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.impl;

import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.INodeWithNumberedEdges;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.impl.DelegatingNumberedNodeManager;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingNumberedEdgeManager<T extends INodeWithNumberedEdges>
implements NumberedEdgeManager<T> {
    private final DelegatingNumberedNodeManager<T> nodeManager;

    public DelegatingNumberedEdgeManager(DelegatingNumberedNodeManager<T> delegatingNumberedNodeManager) {
        if (delegatingNumberedNodeManager == null) {
            throw new IllegalArgumentException("nodeManager is null");
        }
        this.nodeManager = delegatingNumberedNodeManager;
    }

    @Override
    public Iterator<T> getPredNodes(T t) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("N cannot be null");
        }
        T t2 = t;
        IntSet intSet = t2.getPredNumbers();
        EmptyIterator emptyIterator = EmptyIterator.instance();
        return intSet == null ? emptyIterator : new IntSetNodeIterator(intSet.intIterator());
    }

    @Override
    public IntSet getPredNodeNumbers(T t) {
        if (t == null) {
            throw new IllegalArgumentException("N cannot be null");
        }
        T t2 = t;
        IntSet intSet = t2.getPredNumbers();
        return intSet == null ? new SparseIntSet() : intSet;
    }

    @Override
    public int getPredNodeCount(T t) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("N cannot be null");
        }
        T t2 = t;
        IntSet intSet = t2.getPredNumbers();
        if (intSet == null) {
            return 0;
        }
        return intSet.size();
    }

    @Override
    public Iterator<T> getSuccNodes(T t) {
        if (t == null) {
            throw new IllegalArgumentException("N cannot be null");
        }
        T t2 = t;
        IntSet intSet = t2.getSuccNumbers();
        EmptyIterator emptyIterator = EmptyIterator.instance();
        return intSet == null ? emptyIterator : new IntSetNodeIterator(intSet.intIterator());
    }

    @Override
    public int getSuccNodeCount(T t) {
        if (t == null) {
            throw new IllegalArgumentException("N is null");
        }
        T t2 = t;
        IntSet intSet = t2.getSuccNumbers();
        return intSet == null ? 0 : intSet.size();
    }

    @Override
    public void addEdge(T t, T t2) {
        if (t2 == null || t == null) {
            throw new IllegalArgumentException("parameter is null");
        }
        t.addSucc(t2.getGraphNodeId());
        t2.addPred(t.getGraphNodeId());
    }

    @Override
    public void removeEdge(T t, T t2) throws UnimplementedError {
        Assertions.UNREACHABLE("Implement me");
    }

    @Override
    public void removeAllIncidentEdges(T t) throws UnimplementedError {
        if (t == null) {
            throw new IllegalArgumentException("node is null");
        }
        T t2 = t;
        t2.removeAllIncidentEdges();
    }

    @Override
    public void removeIncomingEdges(T t) throws UnimplementedError {
        if (t == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        T t2 = t;
        t2.removeIncomingEdges();
    }

    @Override
    public void removeOutgoingEdges(T t) throws UnimplementedError {
        if (t == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        T t2 = t;
        t2.removeOutgoingEdges();
    }

    @Override
    public boolean hasEdge(T t, T t2) throws IllegalArgumentException {
        if (t2 == null) {
            throw new IllegalArgumentException("dst == null");
        }
        return this.getSuccNodeNumbers(t).contains(t2.getGraphNodeId());
    }

    @Override
    public IntSet getSuccNodeNumbers(T t) {
        if (t == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        T t2 = t;
        IntSet intSet = t2.getSuccNumbers();
        return intSet == null ? new SparseIntSet() : intSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IntSetNodeIterator
    implements Iterator<T> {
        private final IntIterator delegate;

        IntSetNodeIterator(IntIterator intIterator) {
            this.delegate = intIterator;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return (INodeWithNumberedEdges)DelegatingNumberedEdgeManager.this.nodeManager.getNode(this.delegate.next());
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }
    }
}

