/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.dominators;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.dominators.Dominators;
import com.ibm.wala.util.graph.traverse.DFS;
import com.ibm.wala.util.graph.traverse.DFSFinishTimeIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DominanceFrontiers<T> {
    private final Map<T, Set<T>> DF = HashMapFactory.make();
    private final Dominators<T> dom;
    private final Graph<T> G;
    private final T root;

    public DominanceFrontiers(Graph<T> graph, T t) {
        this.root = t;
        this.G = graph;
        this.dom = Dominators.make(graph, t);
        this.analyze();
    }

    public Iterator<T> getDominanceFrontier(T t) {
        return this.DF.get(t).iterator();
    }

    public boolean isDominatedBy(T t, T t2) {
        return this.dom.isDominatedBy(t, t2);
    }

    public Iterator<T> dominators(T t) {
        return this.dom.dominators(t);
    }

    public Graph<T> dominatorTree() {
        return this.dom.dominatorTree();
    }

    private void analyze() {
        Graph graph = this.dom.dominatorTree();
        DFSFinishTimeIterator<T> dFSFinishTimeIterator = DFS.iterateFinishTime(graph, new NonNullSingletonIterator<T>(this.root));
        while (dFSFinishTimeIterator.hasNext()) {
            Object e;
            Object e2 = dFSFinishTimeIterator.next();
            HashSet hashSet = HashSetFactory.make();
            this.DF.put(e2, hashSet);
            Iterator iterator = this.G.getSuccNodes(e2);
            while (iterator.hasNext()) {
                e = iterator.next();
                if (this.dom.getIdom(e) == e2) continue;
                hashSet.add(e);
            }
            iterator = graph.getSuccNodes(e2);
            while (iterator.hasNext()) {
                e = iterator.next();
                Iterator iterator2 = this.getDominanceFrontier(e);
                while (iterator2.hasNext()) {
                    Object e3 = iterator2.next();
                    if (this.dom.getIdom(e3) == e2) continue;
                    hashSet.add(e3);
                }
            }
        }
    }
}

