/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.NodeManager;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.Path;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Acyclic {
    private Acyclic() {
    }

    public static <T> boolean isAcyclic(NumberedGraph<T> numberedGraph, T t) {
        IBinaryNaturalRelation iBinaryNaturalRelation = Acyclic.computeBackEdges(numberedGraph, t);
        Iterator iterator = iBinaryNaturalRelation.iterator();
        return !iterator.hasNext();
    }

    public static <T> IBinaryNaturalRelation computeBackEdges(NumberedGraph<T> numberedGraph, T t) {
        if (numberedGraph == null) {
            throw new IllegalArgumentException("G is null");
        }
        BasicNaturalRelation basicNaturalRelation = new BasicNaturalRelation();
        HashSet hashSet = HashSetFactory.make();
        HashSet hashSet2 = HashSetFactory.make();
        Acyclic.dfs(basicNaturalRelation, t, numberedGraph, hashSet, hashSet2);
        return basicNaturalRelation;
    }

    private static <T> void dfs(BasicNaturalRelation basicNaturalRelation, T t, NumberedGraph<T> numberedGraph, Set<T> set, Set<T> set2) {
        set.add(t);
        set2.add(t);
        Iterator<T> iterator = numberedGraph.getSuccNodes(t);
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (set2.contains(t2)) {
                int n = numberedGraph.getNumber(t);
                int n2 = numberedGraph.getNumber(t2);
                basicNaturalRelation.add(n, n2);
            }
            if (set.contains(t2)) continue;
            Acyclic.dfs(basicNaturalRelation, t2, numberedGraph, set, set2);
        }
        set2.remove(t);
    }

    public static <T> boolean hasIncomingBackEdges(Path path, NumberedGraph<T> numberedGraph, T t) {
        IBinaryNaturalRelation iBinaryNaturalRelation = Acyclic.computeBackEdges(numberedGraph, t);
        int n = 0;
        while (n < path.size()) {
            int n2 = path.get(n);
            Iterator iterator = numberedGraph.getPredNodes(numberedGraph.getNode(n2));
            while (iterator.hasNext()) {
                if (!iBinaryNaturalRelation.contains(numberedGraph.getNumber(iterator.next()), n2)) continue;
                return true;
            }
            ++n;
        }
        return false;
    }

    public static <T> Collection<Path> computeAcyclicPaths(NumberedGraph<T> numberedGraph, T t, T t2, T t3, int n) {
        HashSet<Path> hashSet = HashSetFactory.make();
        SubGraph subGraph = new SubGraph(numberedGraph, Acyclic.computeBackEdges(numberedGraph, t));
        HashSet hashSet2 = HashSetFactory.make();
        Path path = Path.make(numberedGraph.getNumber(t3));
        hashSet2.add(path);
        while (!hashSet2.isEmpty() && hashSet.size() <= n) {
            Path path2 = (Path)hashSet2.iterator().next();
            hashSet2.remove(path2);
            int n2 = path2.get(0);
            if (n2 == numberedGraph.getNumber(t2)) {
                hashSet.add(path2);
                continue;
            }
            IntIterator intIterator = subGraph.getPredNodeNumbers(subGraph.getNode(n2)).intIterator();
            while (intIterator.hasNext()) {
                hashSet2.add(Path.prepend(intIterator.next(), path2));
            }
        }
        return hashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubGraph<T>
    extends AbstractNumberedGraph<T> {
        private final NumberedGraph<T> delegate;
        private final IBinaryNaturalRelation ignoreEdges;
        private final Edges edges;

        SubGraph(NumberedGraph<T> numberedGraph, IBinaryNaturalRelation iBinaryNaturalRelation) {
            this.delegate = numberedGraph;
            this.ignoreEdges = iBinaryNaturalRelation;
            this.edges = new Edges();
        }

        @Override
        protected EdgeManager<T> getEdgeManager() {
            return this.edges;
        }

        @Override
        protected NodeManager<T> getNodeManager() {
            return this.delegate;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class Edges
        implements NumberedEdgeManager<T> {
            private Edges() {
            }

            @Override
            public void addEdge(T t, T t2) {
                Assertions.UNREACHABLE();
            }

            @Override
            public int getPredNodeCount(T t) {
                Assertions.UNREACHABLE();
                return 0;
            }

            @Override
            public Iterator<T> getPredNodes(T t) {
                Assertions.UNREACHABLE();
                return null;
            }

            @Override
            public int getSuccNodeCount(T t) {
                Assertions.UNREACHABLE();
                return 0;
            }

            @Override
            public Iterator<T> getSuccNodes(T t) {
                Assertions.UNREACHABLE();
                return null;
            }

            @Override
            public boolean hasEdge(T t, T t2) {
                Assertions.UNREACHABLE();
                return false;
            }

            @Override
            public void removeAllIncidentEdges(T t) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeEdge(T t, T t2) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeIncomingEdges(T t) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeOutgoingEdges(T t) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }

            @Override
            public IntSet getPredNodeNumbers(T t) {
                IntSet intSet = SubGraph.this.delegate.getPredNodeNumbers(t);
                MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
                IntIterator intIterator = intSet.intIterator();
                while (intIterator.hasNext()) {
                    int n = intIterator.next();
                    if (SubGraph.this.ignoreEdges.contains(n, SubGraph.this.getNumber(t))) continue;
                    mutableSparseIntSet.add(n);
                }
                return mutableSparseIntSet;
            }

            @Override
            public IntSet getSuccNodeNumbers(T t) {
                Assertions.UNREACHABLE();
                return null;
            }
        }
    }
}

