/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.config;

import com.ibm.wala.classLoader.BinaryDirectoryTreeModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.SourceDirectoryTreeModule;
import com.ibm.wala.core.plugin.CorePlugin;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.properties.WalaProperties;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.config.FileOfClasses;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileProvider;
import com.ibm.wala.util.strings.Atom;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.Plugin;

public class AnalysisScopeReader {
    private static final ClassLoader MY_CLASSLOADER = AnalysisScopeReader.class.getClassLoader();
    private static final String BASIC_FILE = "primordial.txt";

    public static AnalysisScope readJavaScope(String string, File file, ClassLoader classLoader) throws IOException {
        AnalysisScope analysisScope = AnalysisScope.createJavaAnalysisScope();
        return AnalysisScopeReader.read(analysisScope, string, file, classLoader, CorePlugin.getDefault());
    }

    private static AnalysisScope readJavaScope(String string, File file, ClassLoader classLoader, Plugin plugin) throws IOException {
        AnalysisScope analysisScope = AnalysisScope.createJavaAnalysisScope();
        return AnalysisScopeReader.read(analysisScope, string, file, classLoader, plugin);
    }

    private static AnalysisScope read(AnalysisScope analysisScope, String string, File file, ClassLoader classLoader, Plugin plugin) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            String string2;
            File file2;
            File file3 = file2 = plugin == null ? FileProvider.getFile(string, classLoader) : FileProvider.getFileFromPlugin(plugin, string);
            assert (file2.exists());
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), "UTF-8"));
            while ((string2 = bufferedReader.readLine()) != null) {
                AnalysisScopeReader.processScopeDefLine(analysisScope, classLoader, string2);
            }
            if (file != null) {
                analysisScope.setExclusions(FileOfClasses.createFileOfClasses(file));
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return analysisScope;
    }

    public static void processScopeDefLine(AnalysisScope analysisScope, ClassLoader classLoader, String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("null line");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n,");
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        Atom atom = Atom.findOrCreateUnicodeAtom(stringTokenizer.nextToken());
        ClassLoaderReference classLoaderReference = analysisScope.getLoader(atom);
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        if ("classFile".equals(string2)) {
            File file = FileProvider.getFile(string3, classLoader);
            analysisScope.addClassFileToScope(classLoaderReference, file);
        } else if ("sourceFile".equals(string2)) {
            File file = FileProvider.getFile(string3, classLoader);
            analysisScope.addSourceFileToScope(classLoaderReference, file, string3);
        } else if ("binaryDir".equals(string2)) {
            File file = FileProvider.getFile(string3, classLoader);
            assert (file.isDirectory());
            analysisScope.addToScope(classLoaderReference, new BinaryDirectoryTreeModule(file));
        } else if ("sourceDir".equals(string2)) {
            File file = FileProvider.getFile(string3, classLoader);
            assert (file.isDirectory());
            analysisScope.addToScope(classLoaderReference, new SourceDirectoryTreeModule(file));
        } else if ("jarFile".equals(string2)) {
            Module module = FileProvider.getJarFileModule(string3, classLoader);
            analysisScope.addToScope(classLoaderReference, module);
        } else if ("loaderImpl".equals(string2)) {
            analysisScope.setLoaderImpl(classLoaderReference, string3);
        } else if ("stdlib".equals(string2)) {
            String[] stringArray = WalaProperties.getJ2SEJarFiles();
            int n = 0;
            while (n < stringArray.length) {
                analysisScope.addToScope(classLoaderReference, new JarFile(stringArray[n]));
                ++n;
            }
        } else {
            Assertions.UNREACHABLE();
        }
    }

    public static AnalysisScope makePrimordialScope(File file) throws IOException {
        return AnalysisScopeReader.readJavaScope(BASIC_FILE, file, MY_CLASSLOADER, CorePlugin.getDefault());
    }

    private static AnalysisScope makePrimordialScope(File file, Plugin plugin) throws IOException {
        return AnalysisScopeReader.readJavaScope(BASIC_FILE, file, MY_CLASSLOADER, plugin);
    }

    public static AnalysisScope makeJavaBinaryAnalysisScope(String string, File file) throws IOException {
        return AnalysisScopeReader.makeJavaBinaryAnalysisScope(string, file, CorePlugin.getDefault());
    }

    public static AnalysisScope makeJavaBinaryAnalysisScope(String string, File file, Plugin plugin) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("classPath null");
        }
        AnalysisScope analysisScope = AnalysisScopeReader.makePrimordialScope(file, plugin);
        ClassLoaderReference classLoaderReference = analysisScope.getLoader(AnalysisScope.APPLICATION);
        AnalysisScopeReader.addClassPathToScope(string, analysisScope, classLoaderReference);
        return analysisScope;
    }

    public static void addClassPathToScope(String string, AnalysisScope analysisScope, ClassLoaderReference classLoaderReference) {
        if (string == null) {
            throw new IllegalArgumentException("null classPath");
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.endsWith(".jar")) {
                    analysisScope.addToScope(classLoaderReference, new JarFile(string2));
                    continue;
                }
                File file = new File(string2);
                if (file.isDirectory()) {
                    analysisScope.addToScope(classLoaderReference, new BinaryDirectoryTreeModule(file));
                    continue;
                }
                analysisScope.addClassFileToScope(classLoaderReference, file);
            }
        }
        catch (IOException iOException) {
            Assertions.UNREACHABLE(iOException.toString());
        }
    }
}

