/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.ParanoidHashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParanoidHashSet<T>
extends LinkedHashSet<T> {
    public static final long serialVersionUID = 30919839181133333L;
    private final Map<Integer, Set<T>> hcFreq;
    private int nAdded = 0;
    private final int BAD_HC = 3;

    public ParanoidHashSet(Collection<T> collection) throws NullPointerException {
        super(collection.size());
        this.hcFreq = HashMapFactory.make(collection.size());
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public ParanoidHashSet() {
        this.hcFreq = HashMapFactory.make();
    }

    public ParanoidHashSet(int n) {
        super(n);
        this.hcFreq = HashMapFactory.make(n);
    }

    @Override
    public boolean add(T t) {
        if (t == null) {
            throw new IllegalArgumentException("arg0 is null");
        }
        ParanoidHashMap.assertOverridesHashCode(t);
        boolean bl = super.add(t);
        if (bl) {
            ++this.nAdded;
            int n = t.hashCode();
            Set<T> set = this.hcFreq.get(new Integer(n));
            if (set == null) {
                LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>(1);
                linkedHashSet.add(t);
                this.hcFreq.put(new Integer(n), linkedHashSet);
            } else if (set.size() == 3) {
                for (T t2 : set) {
                    System.err.println(t2 + " " + t2.hashCode());
                }
                assert (false) : "bad hc " + t.getClass() + " " + t;
            } else {
                set.add(t);
            }
        }
        return bl;
    }
}

