/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Heap<T> {
    private int numberOfElements = 0;
    private T[] backingStore;

    protected abstract boolean compareElements(T var1, T var2);

    public int size() {
        return this.numberOfElements;
    }

    public Heap(int n) {
        this.backingStore = new Object[n];
    }

    public final boolean isEmpty() {
        return this.numberOfElements == 0;
    }

    public void insert(T t) {
        this.ensureCapacity(this.numberOfElements + 1);
        this.bubbleUp(t, this.numberOfElements);
        ++this.numberOfElements;
    }

    public T take() throws NoSuchElementException {
        if (this.numberOfElements == 0) {
            throw new NoSuchElementException();
        }
        T t = this.backingStore[0];
        this.removeElement(0);
        return t;
    }

    private static int heapParent(int n) {
        return (n - 1) / 2;
    }

    private static int heapLeftChild(int n) {
        return n * 2 + 1;
    }

    private static int heapRightChild(int n) {
        return n * 2 + 2;
    }

    private final void ensureCapacity(int n) {
        if (this.backingStore.length < n) {
            Object[] objectArray = new Object[2 * n];
            System.arraycopy(this.backingStore, 0, objectArray, 0, this.backingStore.length);
            this.backingStore = objectArray;
        }
    }

    private final void removeElement(int n) {
        int n2;
        int n3 = this.numberOfElements;
        T[] TArray = this.backingStore;
        while ((n2 = Heap.heapLeftChild(n)) < n3) {
            int n4 = Heap.heapRightChild(n);
            if (n4 < n3) {
                T t = TArray[n2];
                T t2 = TArray[n4];
                if (this.compareElements(t, t2)) {
                    TArray[n] = t;
                    n = n2;
                    continue;
                }
                TArray[n] = t2;
                n = n4;
                continue;
            }
            TArray[n] = TArray[n2];
            n = n2;
        }
        --this.numberOfElements;
        n3 = this.numberOfElements;
        if (n != n3) {
            this.bubbleUp(TArray[n3], n);
        }
    }

    private final void bubbleUp(T t, int n) {
        T[] TArray = this.backingStore;
        while (true) {
            if (n == 0) {
                TArray[n] = t;
                return;
            }
            int n2 = Heap.heapParent(n);
            T t2 = TArray[n2];
            if (this.compareElements(t2, t)) {
                TArray[n] = t;
                return;
            }
            TArray[n] = t2;
            n = n2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        while (n < this.size()) {
            if (this.backingStore[n] != null) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.backingStore[n].toString());
            }
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

