/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.bytecode;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.shrikeBT.BytecodeConstants;

public class BytecodeStream
implements BytecodeConstants {
    private final IMethod method;
    private final IClass declaringClass;
    private final int bcLength;
    private final byte[] bcodes;
    private int bcIndex;
    private int opcode;
    private boolean wide;

    public BytecodeStream(IMethod iMethod, byte[] byArray) {
        if (iMethod == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("bc is null");
        }
        this.method = iMethod;
        this.declaringClass = iMethod.getDeclaringClass();
        this.bcodes = byArray;
        this.bcLength = byArray.length;
        this.bcIndex = 0;
    }

    public final IMethod method() {
        return this.method;
    }

    public final IClass declaringClass() {
        return this.declaringClass;
    }

    public final int length() {
        return this.bcLength;
    }

    public final int index() {
        return this.bcIndex;
    }

    public final void reset() {
        this.reset(0);
    }

    public final void reset(int n) {
        this.bcIndex = n;
    }

    public final boolean hasMoreBytecodes() {
        return this.bcIndex < this.bcLength;
    }

    public final int peekNextOpcode() {
        return this.getUnsignedByte(this.bcIndex);
    }

    public final int nextInstruction() {
        this.opcode = this.readUnsignedByte();
        this.wide = this.opcode == 196;
        return this.opcode;
    }

    public final int getOpcode() {
        return this.opcode;
    }

    public final boolean isWide() {
        return this.wide;
    }

    public final void skipInstruction() {
        int n = JBC_length[this.opcode] - 1;
        if (this.wide) {
            n += n;
        }
        if (n >= 0) {
            this.bcIndex += n;
        } else {
            this.skipSpecialInstruction(this.opcode);
        }
    }

    public final void skipInstruction(int n, boolean bl) {
        int n2 = JBC_length[n] - 1;
        if (bl) {
            n2 += n2;
        }
        if (n2 >= 0) {
            this.bcIndex += n2;
        } else {
            this.skipSpecialInstruction(n);
        }
    }

    public final int getByteValue() {
        return this.readSignedByte();
    }

    public final int getShortValue() {
        return this.readSignedShort();
    }

    public final int getLocalNumber() {
        return this.readUnsignedByte();
    }

    public final int getWideLocalNumber() {
        return this.readUnsignedShort();
    }

    public final int getIncrement() {
        return this.readSignedByte();
    }

    public final int getWideIncrement() {
        return this.readSignedShort();
    }

    public final int getBranchOffset() {
        return this.readSignedShort();
    }

    public final int getWideBranchOffset() {
        return this.readSignedInt();
    }

    public final void alignSwitch() {
        int n = this.bcIndex & 3;
        if (n != 0) {
            this.bcIndex += 4 - n;
        }
    }

    public final int getDefaultSwitchOffset() {
        return this.readSignedInt();
    }

    public final int getLowSwitchValue() {
        return this.readSignedInt();
    }

    public final int getHighSwitchValue() {
        return this.readSignedInt();
    }

    public final void skipTableSwitchOffsets(int n) {
        this.bcIndex += n << 2;
    }

    public final int getTableSwitchOffset(int n) {
        return this.getSignedInt(this.bcIndex + (n << 2));
    }

    public final int computeTableSwitchOffset(int n, int n2, int n3) {
        if (n < n2 || n > n3) {
            return 0;
        }
        return this.getSignedInt(this.bcIndex + (n - n2 << 2));
    }

    public final int getSwitchLength() {
        return this.readSignedInt();
    }

    public final void skipLookupSwitchPairs(int n) {
        this.bcIndex += n << 3;
    }

    public final int getLookupSwitchOffset(int n) {
        return this.getSignedInt(this.bcIndex + (n << 3) + 4);
    }

    public final int getLookupSwitchValue(int n) {
        return this.getSignedInt(this.bcIndex + (n << 3));
    }

    public final int computeLookupSwitchOffset(int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            if (this.getSignedInt(this.bcIndex + (n3 << 3)) == n) {
                return this.getSignedInt(this.bcIndex + (n3 << 3) + 4);
            }
            ++n3;
        }
        return 0;
    }

    public final void alignInvokeInterface() {
        this.bcIndex += 2;
    }

    public final int getArrayElementType() {
        return this.readUnsignedByte();
    }

    public final int getArrayDimension() {
        return this.readUnsignedByte();
    }

    public final int getWideOpcode() {
        this.opcode = this.readUnsignedByte();
        return this.opcode;
    }

    public final int getConstantIndex() {
        return this.readUnsignedByte();
    }

    public final int getWideConstantIndex() {
        return this.readUnsignedShort();
    }

    private void skipSpecialInstruction(int n) {
        switch (n) {
            case 170: {
                this.alignSwitch();
                this.getDefaultSwitchOffset();
                int n2 = this.getLowSwitchValue();
                int n3 = this.getHighSwitchValue();
                this.skipTableSwitchOffsets(n3 - n2 + 1);
                break;
            }
            case 171: {
                this.alignSwitch();
                this.getDefaultSwitchOffset();
                int n4 = this.getSwitchLength();
                this.skipLookupSwitchPairs(n4);
                break;
            }
            case 196: {
                int n5 = this.getWideOpcode();
                int n6 = JBC_length[n5] - 1;
                this.bcIndex += n6 + n6;
                break;
            }
            default: {
                throw new NullPointerException();
            }
        }
    }

    private final byte readSignedByte() {
        return this.bcodes[this.bcIndex++];
    }

    private final int readUnsignedByte() {
        return this.bcodes[this.bcIndex++] & 0xFF;
    }

    private final int getUnsignedByte(int n) {
        return this.bcodes[n] & 0xFF;
    }

    private final int readSignedShort() {
        int n = this.bcodes[this.bcIndex++] << 8;
        return n |= this.bcodes[this.bcIndex++] & 0xFF;
    }

    private final int readUnsignedShort() {
        int n = (this.bcodes[this.bcIndex++] & 0xFF) << 8;
        return n |= this.bcodes[this.bcIndex++] & 0xFF;
    }

    private final int readSignedInt() {
        int n = this.bcodes[this.bcIndex++] << 24;
        n |= (this.bcodes[this.bcIndex++] & 0xFF) << 16;
        n |= (this.bcodes[this.bcIndex++] & 0xFF) << 8;
        return n |= this.bcodes[this.bcIndex++] & 0xFF;
    }

    private final int getSignedInt(int n) {
        int n2 = this.bcodes[n++] << 24;
        n2 |= (this.bcodes[n++] & 0xFF) << 16;
        n2 |= (this.bcodes[n++] & 0xFF) << 8;
        return n2 |= this.bcodes[n] & 0xFF;
    }
}

