/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types;

import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MemberReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.shrike.ShrikeUtil;
import com.ibm.wala.util.strings.Atom;
import java.util.HashMap;

public final class FieldReference
extends MemberReference {
    private static final boolean DEBUG = false;
    private static final HashMap<Key, FieldReference> dictionary = HashMapFactory.make();
    private final TypeReference fieldType;

    public String getSignature() {
        return this.getDeclaringClass().getName() + "." + this.getName() + " " + this.getFieldType().getName();
    }

    public static synchronized FieldReference findOrCreate(TypeReference typeReference, Atom atom, TypeReference typeReference2) {
        if (typeReference == null) {
            throw new IllegalArgumentException("null tref");
        }
        Key key = new Key(typeReference, atom, typeReference2);
        FieldReference fieldReference = dictionary.get(key);
        if (fieldReference != null) {
            return fieldReference;
        }
        fieldReference = new FieldReference(key, typeReference2);
        dictionary.put(key, fieldReference);
        return fieldReference;
    }

    public static FieldReference findOrCreate(ClassLoaderReference classLoaderReference, String string, String string2, String string3) throws IllegalArgumentException {
        TypeReference typeReference = ShrikeUtil.makeTypeReference(classLoaderReference, string);
        TypeReference typeReference2 = ShrikeUtil.makeTypeReference(classLoaderReference, string3);
        Atom atom = Atom.findOrCreateUnicodeAtom(string2);
        return FieldReference.findOrCreate(typeReference, atom, typeReference2);
    }

    private FieldReference(Key key, TypeReference typeReference) {
        super(key.type, key.name, key.hashCode());
        this.fieldType = typeReference;
    }

    public final TypeReference getFieldType() {
        return this.fieldType;
    }

    public final String toString() {
        return "< " + this.getDeclaringClass().getClassLoader().getName() + ", " + this.getDeclaringClass().getName() + ", " + this.getName() + ", " + this.fieldType + " >";
    }

    protected static class Key {
        final TypeReference type;
        final Atom name;
        private final TypeReference fieldType;

        Key(TypeReference typeReference, Atom atom, TypeReference typeReference2) {
            this.type = typeReference;
            this.name = atom;
            this.fieldType = typeReference2;
        }

        public final int hashCode() {
            return 7487 * this.type.hashCode() + this.name.hashCode();
        }

        public final boolean equals(Object object) {
            assert (object != null && this.getClass().equals(object.getClass()));
            Key key = (Key)object;
            return this.type.equals(key.type) && this.name.equals(key.name) && this.fieldType.equals(key.fieldType);
        }
    }
}

