/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.util.intset.IntIterator;

public class SSASwitchInstruction
extends SSAInstruction {
    private final int val;
    private final int defaultLabel;
    private final int[] casesAndLabels;

    public SSASwitchInstruction(int n, int n2, int[] nArray) {
        this.val = n;
        this.defaultLabel = n2;
        this.casesAndLabels = nArray;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory sSAInstructionFactory, int[] nArray, int[] nArray2) {
        assert (nArray2 == null || nArray2.length == 1);
        return sSAInstructionFactory.SwitchInstruction(nArray2 == null ? this.val : nArray2[0], this.defaultLabel, this.casesAndLabels);
    }

    public String toString(SymbolTable symbolTable) {
        StringBuffer stringBuffer = new StringBuffer("switch ");
        stringBuffer.append(this.getValueString(symbolTable, this.val));
        stringBuffer.append(" [");
        int n = 0;
        while (n < this.casesAndLabels.length - 1) {
            stringBuffer.append(this.casesAndLabels[n]);
            stringBuffer.append("->");
            stringBuffer.append(this.casesAndLabels[++n]);
            if (n < this.casesAndLabels.length - 2) {
                stringBuffer.append(",");
            }
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void visit(SSAInstruction.IVisitor iVisitor) {
        if (iVisitor == null) {
            throw new IllegalArgumentException("v is null");
        }
        iVisitor.visitSwitch(this);
    }

    public int getNumberOfUses() {
        return 1;
    }

    public int getUse(int n) {
        assert (n <= 1);
        return this.val;
    }

    public int getTarget(int n) {
        int n2 = 0;
        while (n2 < this.casesAndLabels.length) {
            if (n == this.casesAndLabels[n2]) {
                return this.casesAndLabels[n2 + 1];
            }
            n2 += 2;
        }
        return this.defaultLabel;
    }

    public int getDefault() {
        return this.defaultLabel;
    }

    public int[] getCasesAndLabels() {
        return this.casesAndLabels;
    }

    public IntIterator iterateLabels() {
        return new IntIterator(){
            private int i = 0;

            public boolean hasNext() {
                return this.i < SSASwitchInstruction.this.casesAndLabels.length;
            }

            public int next() {
                int n = SSASwitchInstruction.this.casesAndLabels[this.i];
                this.i += 2;
                return n;
            }
        };
    }

    public int hashCode() {
        return this.val * 1663 + 3499;
    }

    public boolean isFallThrough() {
        return false;
    }
}

