/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAFieldAccessInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;

public abstract class SSAPutInstruction
extends SSAFieldAccessInstruction {
    private final int val;

    protected SSAPutInstruction(int n, int n2, FieldReference fieldReference) {
        super(fieldReference, n);
        this.val = n2;
    }

    protected SSAPutInstruction(int n, FieldReference fieldReference) {
        super(fieldReference, -1);
        this.val = n;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory sSAInstructionFactory, int[] nArray, int[] nArray2) {
        if (this.isStatic()) {
            return sSAInstructionFactory.PutInstruction(nArray2 == null ? this.val : nArray2[0], this.getDeclaredField());
        }
        return sSAInstructionFactory.PutInstruction(nArray2 == null ? this.getRef() : nArray2[0], nArray2 == null ? this.val : nArray2[1], this.getDeclaredField());
    }

    public String toString(SymbolTable symbolTable) {
        if (this.isStatic()) {
            return "putstatic " + this.getValueString(symbolTable, this.val) + " " + this.getDeclaredField();
        }
        return "putfield " + this.getValueString(symbolTable, this.getRef()) + " = " + this.getValueString(symbolTable, this.val) + " " + this.getDeclaredField();
    }

    public void visit(SSAInstruction.IVisitor iVisitor) {
        if (iVisitor == null) {
            throw new IllegalArgumentException("v is null");
        }
        iVisitor.visitPut(this);
    }

    public int getNumberOfUses() {
        return this.isStatic() ? 1 : 2;
    }

    public int getUse(int n) {
        assert (n == 0 || !this.isStatic() && n == 1);
        return n == 0 && !this.isStatic() ? this.getRef() : this.val;
    }

    public int getVal() {
        return this.val;
    }

    public int hashCode() {
        return this.val * 9929 ^ 0x80F;
    }

    public boolean isFallThrough() {
        return true;
    }
}

