/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;

public class SSAPhiInstruction
extends SSAInstruction {
    private final int result;
    private int[] params;

    public SSAPhiInstruction(int n, int[] nArray) throws IllegalArgumentException {
        if (nArray == null) {
            throw new IllegalArgumentException("params is null");
        }
        this.result = n;
        this.params = nArray;
        if (nArray.length == 0) {
            throw new IllegalArgumentException("can't have phi with no params");
        }
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            if (n4 == 0) {
                throw new IllegalArgumentException("zero is an invalid value number for a parameter to phi");
            }
            ++n3;
        }
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory sSAInstructionFactory, int[] nArray, int[] nArray2) throws IllegalArgumentException {
        if (nArray != null && nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        return sSAInstructionFactory.PhiInstruction(nArray == null ? this.result : nArray[0], nArray2 == null ? this.params : nArray2);
    }

    public String toString(SymbolTable symbolTable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getValueString(symbolTable, this.result)).append(" = phi ");
        stringBuffer.append(" ").append(this.getValueString(symbolTable, this.params[0]));
        int n = 1;
        while (n < this.params.length) {
            stringBuffer.append(",").append(this.getValueString(symbolTable, this.params[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    public void visit(SSAInstruction.IVisitor iVisitor) {
        if (iVisitor == null) {
            throw new IllegalArgumentException("v is null");
        }
        iVisitor.visitPhi(this);
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef() {
        return this.result;
    }

    public int getDef(int n) {
        if (n != 0) {
            throw new IllegalArgumentException("invalid i: " + n);
        }
        return this.result;
    }

    public int getNumberOfUses() {
        return this.params.length;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public int getUse(int n) throws IllegalArgumentException {
        if (n >= this.params.length || n < 0) {
            throw new IllegalArgumentException("Bad use " + n);
        }
        return this.params[n];
    }

    public void setValues(int[] nArray) {
        if (nArray == null || nArray.length < 1) {
            throw new IllegalArgumentException("illegal i: " + nArray);
        }
        this.params = nArray;
    }

    protected String getValueString(SymbolTable symbolTable, int n) {
        if (n == -1) {
            return "TOP";
        }
        return super.getValueString(symbolTable, n);
    }

    public int hashCode() {
        return 7823 * this.result;
    }

    public boolean isFallThrough() {
        return true;
    }
}

