/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;

public abstract class SSAFieldAccessInstruction
extends SSAInstruction {
    private final FieldReference field;
    private final int ref;

    protected SSAFieldAccessInstruction(FieldReference fieldReference, int n) throws IllegalArgumentException {
        this.field = fieldReference;
        this.ref = n;
        if (fieldReference == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
    }

    public TypeReference getDeclaredFieldType() {
        return this.field.getFieldType();
    }

    public FieldReference getDeclaredField() {
        return this.field;
    }

    public int getRef() {
        return this.ref;
    }

    public boolean isStatic() {
        return this.ref == -1;
    }

    public boolean isPEI() {
        return !this.isStatic();
    }
}

