/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;

public class SSAConditionalBranchInstruction
extends SSAInstruction {
    private final IConditionalBranchInstruction.IOperator operator;
    private final int val1;
    private final int val2;
    private final TypeReference type;

    public SSAConditionalBranchInstruction(IConditionalBranchInstruction.IOperator iOperator, TypeReference typeReference, int n, int n2) throws IllegalArgumentException {
        this.operator = iOperator;
        this.val1 = n;
        this.val2 = n2;
        this.type = typeReference;
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid val1: " + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Invalid val2: " + n2);
        }
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory sSAInstructionFactory, int[] nArray, int[] nArray2) throws IllegalArgumentException {
        if (nArray2 != null && nArray2.length < 2) {
            throw new IllegalArgumentException("(uses != null) and (uses.length < 2)");
        }
        return sSAInstructionFactory.ConditionalBranchInstruction(this.operator, this.type, nArray2 == null ? this.val1 : nArray2[0], nArray2 == null ? this.val2 : nArray2[1]);
    }

    public IConditionalBranchInstruction.IOperator getOperator() {
        return this.operator;
    }

    public String toString(SymbolTable symbolTable) {
        return "conditional branch(" + this.operator + ") " + this.getValueString(symbolTable, this.val1) + "," + this.getValueString(symbolTable, this.val2);
    }

    public void visit(SSAInstruction.IVisitor iVisitor) {
        if (iVisitor == null) {
            throw new IllegalArgumentException("v is null");
        }
        iVisitor.visitConditionalBranch(this);
    }

    public int getNumberOfUses() {
        return 2;
    }

    public int getUse(int n) {
        assert (n <= 1);
        return n == 0 ? this.val1 : this.val2;
    }

    public TypeReference getType() {
        return this.type;
    }

    public boolean isObjectComparison() {
        return this.type == TypeReference.JavaLangObject;
    }

    public boolean isIntegerComparison() {
        return this.type == TypeReference.Int;
    }

    public int hashCode() {
        return 7151 * this.val1 + this.val2;
    }

    public boolean isFallThrough() {
        return true;
    }
}

