/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;

public class SSAComparisonInstruction
extends SSAInstruction {
    private final int result;
    private final int val1;
    private final int val2;
    private final IComparisonInstruction.Operator operator;

    public SSAComparisonInstruction(IComparisonInstruction.Operator operator, int n, int n2, int n3) {
        this.operator = operator;
        this.result = n;
        this.val1 = n2;
        this.val2 = n3;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory sSAInstructionFactory, int[] nArray, int[] nArray2) throws IllegalArgumentException {
        if (nArray2 != null && nArray2.length != 2) {
            throw new IllegalArgumentException("expected 2 uses or null, but got " + nArray2.length);
        }
        return sSAInstructionFactory.ComparisonInstruction(this.operator, nArray == null || nArray.length == 0 ? this.result : nArray[0], nArray2 == null ? this.val1 : nArray2[0], nArray2 == null ? this.val2 : nArray2[1]);
    }

    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.result)) + " = compare " + this.getValueString(symbolTable, this.val1) + "," + this.getValueString(symbolTable, this.val2) + " opcode=" + this.operator;
    }

    public void visit(SSAInstruction.IVisitor iVisitor) throws NullPointerException {
        iVisitor.visitComparison(this);
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef() {
        return this.result;
    }

    public int getDef(int n) {
        assert (n == 0);
        return this.result;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public int getNumberOfUses() {
        return 2;
    }

    public int getUse(int n) {
        assert (n <= 1);
        return n == 0 ? this.val1 : this.val2;
    }

    public int hashCode() {
        return 6311 * this.result ^ 2371 * this.val1 + this.val2;
    }

    public boolean isFallThrough() {
        return true;
    }

    public IComparisonInstruction.Operator getOperator() {
        return this.operator;
    }
}

