/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.cfg.ShrikeCFG;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.functions.Function;
import com.ibm.wala.util.graph.impl.NumberedNodeIterator;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.shrike.ShrikeUtil;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSACFG
implements ControlFlowGraph<SSAInstruction, ISSABasicBlock> {
    private static final boolean DEBUG = false;
    private BasicBlock[] basicBlocks;
    protected final SSAInstruction[] instructions;
    protected final IMethod method;
    protected final AbstractCFG<IInstruction, IBasicBlock<IInstruction>> delegate;
    private BasicBlock exit;
    private final Map<RefPathKey, SSAPiInstruction> piInstructions = HashMapFactory.make(2);

    public SSACFG(IMethod iMethod, AbstractCFG abstractCFG, SSAInstruction[] sSAInstructionArray) {
        if (iMethod == null) {
            throw new IllegalArgumentException("method is null");
        }
        this.delegate = abstractCFG;
        this.method = iMethod;
        assert (iMethod.getDeclaringClass() != null) : "null declaring class for " + iMethod;
        this.createBasicBlocks(abstractCFG);
        if (abstractCFG instanceof InducedCFG) {
            this.addPhisFromInducedCFG((InducedCFG)abstractCFG);
            this.addPisFromInducedCFG((InducedCFG)abstractCFG);
        }
        if (abstractCFG instanceof ShrikeCFG) {
            this.recordExceptionTypes(((ShrikeCFG)abstractCFG).getExceptionHandlers(), iMethod.getDeclaringClass().getClassLoader());
        }
        this.instructions = sSAInstructionArray;
    }

    private void addPisFromInducedCFG(InducedCFG inducedCFG) {
        for (InducedCFG.BasicBlock basicBlock : inducedCFG) {
            BasicBlock basicBlock2 = this.getBasicBlock(basicBlock.getNumber());
            for (SSAPiInstruction sSAPiInstruction : basicBlock.getPis()) {
                BasicBlock basicBlock3 = this.getBasicBlock(sSAPiInstruction.getSuccessor());
                basicBlock2.addPiForRefAndPath(sSAPiInstruction.getVal(), basicBlock3, sSAPiInstruction);
            }
        }
    }

    private void addPhisFromInducedCFG(InducedCFG inducedCFG) {
        for (InducedCFG.BasicBlock basicBlock : inducedCFG) {
            BasicBlock basicBlock2 = this.getBasicBlock(basicBlock.getNumber());
            int n = 0;
            for (SSAPhiInstruction sSAPhiInstruction : basicBlock.getPhis()) {
                basicBlock2.addPhiForLocal(n++, sSAPhiInstruction);
            }
        }
    }

    public int hashCode() {
        return -3 * this.delegate.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof SSACFG && this.delegate.equals(((SSACFG)object).delegate);
    }

    private void recordExceptionTypes(Set<ExceptionHandler> set, IClassLoader iClassLoader) {
        for (ExceptionHandler exceptionHandler : set) {
            Object object;
            TypeReference typeReference = null;
            if (exceptionHandler.getCatchClass() == null) {
                typeReference = TypeReference.JavaLangThrowable;
            } else {
                TypeReference typeReference2 = ShrikeUtil.makeTypeReference(iClassLoader.getReference(), exceptionHandler.getCatchClass());
                object = null;
                object = iClassLoader.lookupClass(typeReference2.getName());
                if (object == null) {
                    Warnings.add(ExceptionLoadFailure.create(typeReference2, this.method));
                    typeReference = typeReference2;
                } else {
                    typeReference = object.getReference();
                }
            }
            int n = exceptionHandler.getHandler();
            object = this.getBlockForInstruction(n);
            if (!(object instanceof ExceptionHandlerBasicBlock)) assert (object instanceof ExceptionHandlerBasicBlock) : "not exception handler " + object + " index " + n;
            ExceptionHandlerBasicBlock exceptionHandlerBasicBlock = (ExceptionHandlerBasicBlock)this.getBlockForInstruction(n);
            exceptionHandlerBasicBlock.addCaughtExceptionType(typeReference);
        }
    }

    private void createBasicBlocks(AbstractCFG abstractCFG) {
        this.basicBlocks = new BasicBlock[abstractCFG.getNumberOfNodes()];
        int n = 0;
        while (n <= abstractCFG.getMaxNumber()) {
            this.basicBlocks[n] = abstractCFG.getCatchBlocks().get(n) ? new ExceptionHandlerBasicBlock(n) : new BasicBlock(n);
            ++n;
        }
        this.exit = this.basicBlocks[this.delegate.getNumber(this.delegate.exit())];
    }

    @Override
    public BasicBlock getBlockForInstruction(int n) {
        Object t = this.delegate.getBlockForInstruction(n);
        int n2 = this.delegate.getNumber((IBasicBlock<IInstruction>)t);
        return this.basicBlocks[n2];
    }

    public SSAInstruction[] getInstructions() {
        return this.instructions;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n <= this.getNumber(this.exit())) {
            BasicBlock basicBlock = this.getNode(n);
            stringBuffer.append("BB").append(n).append("[").append(basicBlock.getFirstInstructionIndex()).append("..").append(basicBlock.getLastInstructionIndex()).append("]\n");
            Iterator<ISSABasicBlock> iterator = this.getSuccNodes(basicBlock);
            while (iterator.hasNext()) {
                stringBuffer.append("    -> BB").append(((BasicBlock)iterator.next()).getNumber()).append("\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    public BitVector getCatchBlocks() {
        return this.delegate.getCatchBlocks();
    }

    public boolean isCatchBlock(int n) {
        return this.delegate.isCatchBlock(n);
    }

    @Override
    public BasicBlock entry() {
        return this.basicBlocks[0];
    }

    @Override
    public BasicBlock exit() {
        return this.exit;
    }

    @Override
    public int getNumber(ISSABasicBlock iSSABasicBlock) throws IllegalArgumentException {
        if (iSSABasicBlock == null) {
            throw new IllegalArgumentException("N == null");
        }
        return iSSABasicBlock.getNumber();
    }

    @Override
    public BasicBlock getNode(int n) {
        return this.basicBlocks[n];
    }

    @Override
    public int getMaxNumber() {
        return this.basicBlocks.length - 1;
    }

    @Override
    public Iterator<ISSABasicBlock> iterator() {
        ArrayList<BasicBlock> arrayList = new ArrayList<BasicBlock>();
        BasicBlock[] basicBlockArray = this.basicBlocks;
        int n = this.basicBlocks.length;
        int n2 = 0;
        while (n2 < n) {
            BasicBlock basicBlock = basicBlockArray[n2];
            arrayList.add(basicBlock);
            ++n2;
        }
        return arrayList.iterator();
    }

    @Override
    public int getNumberOfNodes() {
        return this.delegate.getNumberOfNodes();
    }

    @Override
    public Iterator<ISSABasicBlock> getPredNodes(ISSABasicBlock iSSABasicBlock) throws IllegalArgumentException {
        if (iSSABasicBlock == null) {
            throw new IllegalArgumentException("b == null");
        }
        Object object = this.delegate.getNode(iSSABasicBlock.getNumber());
        final Iterator<IBasicBlock<IInstruction>> iterator = this.delegate.getPredNodes((IBasicBlock<IInstruction>)object);
        return new Iterator<ISSABasicBlock>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public BasicBlock next() {
                IBasicBlock iBasicBlock = (IBasicBlock)iterator.next();
                int n = iBasicBlock.getNumber();
                return SSACFG.this.basicBlocks[n];
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    @Override
    public int getPredNodeCount(ISSABasicBlock iSSABasicBlock) throws IllegalArgumentException {
        if (iSSABasicBlock == null) {
            throw new IllegalArgumentException("b == null");
        }
        Object object = this.delegate.getNode(iSSABasicBlock.getNumber());
        return this.delegate.getPredNodeCount((IBasicBlock<IInstruction>)object);
    }

    @Override
    public Iterator<ISSABasicBlock> getSuccNodes(ISSABasicBlock iSSABasicBlock) throws IllegalArgumentException {
        if (iSSABasicBlock == null) {
            throw new IllegalArgumentException("b == null");
        }
        Object object = this.delegate.getNode(iSSABasicBlock.getNumber());
        final Iterator<IBasicBlock<IInstruction>> iterator = this.delegate.getSuccNodes((IBasicBlock<IInstruction>)object);
        return new Iterator<ISSABasicBlock>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public ISSABasicBlock next() {
                IBasicBlock iBasicBlock = (IBasicBlock)iterator.next();
                int n = iBasicBlock.getNumber();
                return SSACFG.this.basicBlocks[n];
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    @Override
    public int getSuccNodeCount(ISSABasicBlock iSSABasicBlock) throws IllegalArgumentException {
        if (iSSABasicBlock == null) {
            throw new IllegalArgumentException("b == null");
        }
        Object object = this.delegate.getNode(iSSABasicBlock.getNumber());
        return this.delegate.getSuccNodeCount((IBasicBlock<IInstruction>)object);
    }

    @Override
    public void addNode(ISSABasicBlock iSSABasicBlock) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addEdge(ISSABasicBlock iSSABasicBlock, ISSABasicBlock iSSABasicBlock2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEdge(ISSABasicBlock iSSABasicBlock, ISSABasicBlock iSSABasicBlock2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAllIncidentEdges(ISSABasicBlock iSSABasicBlock) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeNodeAndEdges(ISSABasicBlock iSSABasicBlock) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeNode(ISSABasicBlock iSSABasicBlock) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getProgramCounter(int n) {
        return this.delegate.getProgramCounter(n);
    }

    @Override
    public boolean containsNode(ISSABasicBlock iSSABasicBlock) {
        if (iSSABasicBlock instanceof BasicBlock) {
            return this.basicBlocks[this.getNumber(iSSABasicBlock)] == iSSABasicBlock;
        }
        return false;
    }

    @Override
    public IMethod getMethod() {
        return this.method;
    }

    @Override
    public List<ISSABasicBlock> getExceptionalSuccessors(ISSABasicBlock iSSABasicBlock) {
        if (iSSABasicBlock == null) {
            throw new IllegalArgumentException("b is null");
        }
        Object object = this.delegate.getNode(iSSABasicBlock.getNumber());
        Iterator<IBasicBlock<IInstruction>> iterator = this.delegate.getExceptionalSuccessors((IBasicBlock<IInstruction>)object).iterator();
        ArrayList<ISSABasicBlock> arrayList = new ArrayList<ISSABasicBlock>(this.getSuccNodeCount(iSSABasicBlock));
        while (iterator.hasNext()) {
            IBasicBlock<IInstruction> iBasicBlock = iterator.next();
            arrayList.add(this.basicBlocks[this.delegate.getNumber(iBasicBlock)]);
        }
        return arrayList;
    }

    @Override
    public Collection<ISSABasicBlock> getExceptionalPredecessors(ISSABasicBlock iSSABasicBlock) {
        if (iSSABasicBlock == null) {
            throw new IllegalArgumentException("b is null");
        }
        Object object = this.delegate.getNode(iSSABasicBlock.getNumber());
        Function<IBasicBlock<IInstruction>, ISSABasicBlock> function = new Function<IBasicBlock<IInstruction>, ISSABasicBlock>(){

            @Override
            public ISSABasicBlock apply(IBasicBlock<IInstruction> iBasicBlock) {
                return SSACFG.this.basicBlocks[SSACFG.this.delegate.getNumber(iBasicBlock)];
            }
        };
        return Iterator2Collection.toSet(new MapIterator<IBasicBlock<IInstruction>, ISSABasicBlock>(this.delegate.getExceptionalPredecessors((IBasicBlock<IInstruction>)object).iterator(), function));
    }

    private IBasicBlock<IInstruction> getUnderlyingBlock(BasicBlock basicBlock) {
        return this.delegate.getNode(this.getNumber(basicBlock));
    }

    public boolean hasExceptionalEdge(BasicBlock basicBlock, BasicBlock basicBlock2) {
        if (basicBlock2 == null) {
            throw new IllegalArgumentException("dest is null");
        }
        if (basicBlock2.isExitBlock()) {
            int n = this.getNumber(basicBlock);
            return this.delegate.getExceptionalToExit().get(n);
        }
        return this.delegate.hasExceptionalEdge(this.getUnderlyingBlock(basicBlock), this.getUnderlyingBlock(basicBlock2));
    }

    public boolean hasNormalEdge(BasicBlock basicBlock, BasicBlock basicBlock2) {
        if (basicBlock2 == null) {
            throw new IllegalArgumentException("dest is null");
        }
        if (basicBlock2.isExitBlock()) {
            int n = this.getNumber(basicBlock);
            return this.delegate.getNormalToExit().get(n);
        }
        return this.delegate.hasNormalEdge(this.getUnderlyingBlock(basicBlock), this.getUnderlyingBlock(basicBlock2));
    }

    @Override
    public Collection<ISSABasicBlock> getNormalSuccessors(ISSABasicBlock iSSABasicBlock) {
        if (iSSABasicBlock == null) {
            throw new IllegalArgumentException("b is null");
        }
        Object object = this.delegate.getNode(iSSABasicBlock.getNumber());
        Iterator<IBasicBlock<IInstruction>> iterator = this.delegate.getNormalSuccessors((IBasicBlock<IInstruction>)object).iterator();
        ArrayList<ISSABasicBlock> arrayList = new ArrayList<ISSABasicBlock>(this.getSuccNodeCount(iSSABasicBlock));
        while (iterator.hasNext()) {
            IBasicBlock<IInstruction> iBasicBlock = iterator.next();
            arrayList.add(this.basicBlocks[this.delegate.getNumber(iBasicBlock)]);
        }
        return arrayList;
    }

    @Override
    public Collection<ISSABasicBlock> getNormalPredecessors(ISSABasicBlock iSSABasicBlock) {
        if (iSSABasicBlock == null) {
            throw new IllegalArgumentException("b is null");
        }
        Object object = this.delegate.getNode(iSSABasicBlock.getNumber());
        Iterator<IBasicBlock<IInstruction>> iterator = this.delegate.getNormalPredecessors((IBasicBlock<IInstruction>)object).iterator();
        ArrayList<ISSABasicBlock> arrayList = new ArrayList<ISSABasicBlock>(this.getPredNodeCount(iSSABasicBlock));
        while (iterator.hasNext()) {
            IBasicBlock<IInstruction> iBasicBlock = iterator.next();
            arrayList.add(this.basicBlocks[this.delegate.getNumber(iBasicBlock)]);
        }
        return arrayList;
    }

    @Override
    public Iterator<ISSABasicBlock> iterateNodes(IntSet intSet) {
        return new NumberedNodeIterator<ISSABasicBlock>(intSet, this);
    }

    @Override
    public void removeIncomingEdges(ISSABasicBlock iSSABasicBlock) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeOutgoingEdges(ISSABasicBlock iSSABasicBlock) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasEdge(ISSABasicBlock iSSABasicBlock, ISSABasicBlock iSSABasicBlock2) throws UnimplementedError {
        return this.getSuccNodeNumbers(iSSABasicBlock).contains(this.getNumber(iSSABasicBlock2));
    }

    @Override
    public IntSet getSuccNodeNumbers(ISSABasicBlock iSSABasicBlock) throws IllegalArgumentException {
        if (iSSABasicBlock == null) {
            throw new IllegalArgumentException("b == null");
        }
        Object object = this.delegate.getNode(iSSABasicBlock.getNumber());
        return this.delegate.getSuccNodeNumbers((IBasicBlock<IInstruction>)object);
    }

    @Override
    public IntSet getPredNodeNumbers(ISSABasicBlock iSSABasicBlock) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    public BasicBlock getBasicBlock(int n) {
        return this.basicBlocks[n];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BasicBlock
    implements ISSABasicBlock {
        private final int number;
        private SSAPhiInstruction[] stackSlotPhis;
        private SSAPhiInstruction[] localPhis;
        private static final int initialCapacity = 10;
        private final LinkedList<SSAPiInstruction> blockPiInstructions = new LinkedList();

        public BasicBlock(int n) {
            this.number = n;
        }

        @Override
        public int getNumber() {
            return this.number;
        }

        @Override
        public int getFirstInstructionIndex() {
            Object object = SSACFG.this.delegate.getNode(this.number);
            return object.getFirstInstructionIndex();
        }

        @Override
        public boolean isCatchBlock() {
            return SSACFG.this.delegate.getCatchBlocks().get(this.getNumber());
        }

        @Override
        public int getLastInstructionIndex() {
            Object object = SSACFG.this.delegate.getNode(this.number);
            return object.getLastInstructionIndex();
        }

        @Override
        public Iterator<SSAPhiInstruction> iteratePhis() {
            SSAPhiInstruction sSAPhiInstruction;
            this.compressPhis();
            if (this.stackSlotPhis == null) {
                if (this.localPhis == null) {
                    return EmptyIterator.instance();
                }
                LinkedList<SSAPhiInstruction> linkedList = new LinkedList<SSAPhiInstruction>();
                SSAPhiInstruction[] sSAPhiInstructionArray = this.localPhis;
                int n = this.localPhis.length;
                int n2 = 0;
                while (n2 < n) {
                    SSAPhiInstruction sSAPhiInstruction2 = sSAPhiInstructionArray[n2];
                    if (sSAPhiInstruction2 != null) {
                        linkedList.add(sSAPhiInstruction2);
                    }
                    ++n2;
                }
                return linkedList.iterator();
            }
            LinkedList<SSAPhiInstruction> linkedList = new LinkedList<SSAPhiInstruction>();
            SSAPhiInstruction[] sSAPhiInstructionArray = this.stackSlotPhis;
            int n = this.stackSlotPhis.length;
            int n3 = 0;
            while (n3 < n) {
                sSAPhiInstruction = sSAPhiInstructionArray[n3];
                if (sSAPhiInstruction != null) {
                    linkedList.add(sSAPhiInstruction);
                }
                ++n3;
            }
            if (this.localPhis == null) {
                return linkedList.iterator();
            }
            sSAPhiInstructionArray = this.localPhis;
            n = this.localPhis.length;
            n3 = 0;
            while (n3 < n) {
                sSAPhiInstruction = sSAPhiInstructionArray[n3];
                if (sSAPhiInstruction != null) {
                    linkedList.add(sSAPhiInstruction);
                }
                ++n3;
            }
            return linkedList.iterator();
        }

        public SSAPhiInstruction getPhiForStackSlot(int n) {
            if (this.stackSlotPhis == null) {
                return null;
            }
            if (n >= this.stackSlotPhis.length) {
                return null;
            }
            return this.stackSlotPhis[n];
        }

        public SSAPhiInstruction getPhiForLocal(int n) {
            if (this.localPhis == null) {
                return null;
            }
            if (n >= this.localPhis.length) {
                return null;
            }
            return this.localPhis[n];
        }

        public void addPhiForStackSlot(int n, SSAPhiInstruction sSAPhiInstruction) {
            if (this.stackSlotPhis == null) {
                this.stackSlotPhis = new SSAPhiInstruction[10];
            }
            if (n >= this.stackSlotPhis.length) {
                SSAPhiInstruction[] sSAPhiInstructionArray = this.stackSlotPhis;
                this.stackSlotPhis = new SSAPhiInstruction[n * 2];
                System.arraycopy(sSAPhiInstructionArray, 0, this.stackSlotPhis, 0, sSAPhiInstructionArray.length);
            }
            this.stackSlotPhis[n] = sSAPhiInstruction;
        }

        public void addPhiForLocal(int n, SSAPhiInstruction sSAPhiInstruction) {
            if (this.localPhis == null) {
                this.localPhis = new SSAPhiInstruction[10];
            }
            if (n >= this.localPhis.length) {
                SSAPhiInstruction[] sSAPhiInstructionArray = this.localPhis;
                this.localPhis = new SSAPhiInstruction[n * 2];
                System.arraycopy(sSAPhiInstructionArray, 0, this.localPhis, 0, sSAPhiInstructionArray.length);
            }
            this.localPhis[n] = sSAPhiInstruction;
        }

        public void removePhis(Set<SSAPhiInstruction> set) {
            int n;
            int n2;
            SSAPhiInstruction[] sSAPhiInstructionArray;
            int n3;
            int n4 = 0;
            if (this.stackSlotPhis != null) {
                n3 = 0;
                while (n3 < this.stackSlotPhis.length) {
                    if (set.contains(this.stackSlotPhis[n3])) {
                        this.stackSlotPhis[n3] = null;
                        ++n4;
                    }
                    ++n3;
                }
            }
            if (n4 > 0) {
                n3 = this.stackSlotPhis.length - n4;
                if (n3 == 0) {
                    this.stackSlotPhis = null;
                } else {
                    sSAPhiInstructionArray = this.stackSlotPhis;
                    this.stackSlotPhis = new SSAPhiInstruction[n3];
                    n2 = 0;
                    n = 0;
                    while (n < sSAPhiInstructionArray.length) {
                        if (sSAPhiInstructionArray[n] != null) {
                            this.stackSlotPhis[n2++] = sSAPhiInstructionArray[n];
                        }
                        ++n;
                    }
                }
            }
            n4 = 0;
            if (this.localPhis != null) {
                n3 = 0;
                while (n3 < this.localPhis.length) {
                    if (set.contains(this.localPhis[n3])) {
                        this.localPhis[n3] = null;
                        ++n4;
                    }
                    ++n3;
                }
            }
            if (n4 > 0) {
                n3 = this.localPhis.length - n4;
                if (n3 == 0) {
                    this.localPhis = null;
                } else {
                    sSAPhiInstructionArray = this.localPhis;
                    this.localPhis = new SSAPhiInstruction[n3];
                    n2 = 0;
                    n = 0;
                    while (n < sSAPhiInstructionArray.length) {
                        if (sSAPhiInstructionArray[n] != null) {
                            this.localPhis[n2++] = sSAPhiInstructionArray[n];
                        }
                        ++n;
                    }
                }
            }
        }

        SSAPiInstruction getPiForRefAndPath(int n, Object object) {
            return (SSAPiInstruction)SSACFG.this.piInstructions.get(new RefPathKey(n, this, object));
        }

        void addPiForRefAndPath(int n, Object object, SSAPiInstruction sSAPiInstruction) {
            SSACFG.this.piInstructions.put(new RefPathKey(n, this, object), sSAPiInstruction);
            this.blockPiInstructions.add(sSAPiInstruction);
        }

        @Override
        public Iterator<SSAPiInstruction> iteratePis() {
            return this.blockPiInstructions.iterator();
        }

        public Iterator<SSAInstruction> iterateNormalInstructions() {
            int n = this.getFirstInstructionIndex();
            final int n2 = this.getLastInstructionIndex();
            while (n <= n2 && SSACFG.this.instructions[n] == null) {
                ++n;
            }
            int n3 = n;
            return new Iterator<SSAInstruction>(n3){
                private int start;
                {
                    this.start = n;
                }

                @Override
                public boolean hasNext() {
                    return this.start <= n2;
                }

                @Override
                public SSAInstruction next() {
                    SSAInstruction sSAInstruction = ((BasicBlock)BasicBlock.this).SSACFG.this.instructions[this.start];
                    ++this.start;
                    while (this.start <= n2 && ((BasicBlock)BasicBlock.this).SSACFG.this.instructions[this.start] == null) {
                        ++this.start;
                    }
                    return sSAInstruction;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public List<SSAInstruction> getAllInstructions() {
            this.compressPhis();
            ArrayList<SSAInstruction> arrayList = new ArrayList<SSAInstruction>();
            Iterator<SSAPhiInstruction> iterator = this.iteratePhis();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            int n = this.getFirstInstructionIndex();
            while (n <= this.getLastInstructionIndex()) {
                SSAInstruction sSAInstruction = SSACFG.this.instructions[n];
                if (sSAInstruction != null) {
                    arrayList.add(sSAInstruction);
                }
                ++n;
            }
            Iterator<SSAPiInstruction> iterator2 = this.iteratePis();
            while (iterator2.hasNext()) {
                arrayList.add(iterator2.next());
            }
            return arrayList;
        }

        private void compressPhis() {
            int n;
            int n2;
            SSAPhiInstruction[] sSAPhiInstructionArray;
            int n3;
            if (this.stackSlotPhis != null && this.stackSlotPhis[this.stackSlotPhis.length - 1] == null) {
                n3 = this.countNonNull(this.stackSlotPhis);
                if (n3 == 0) {
                    this.stackSlotPhis = null;
                } else {
                    sSAPhiInstructionArray = this.stackSlotPhis;
                    this.stackSlotPhis = new SSAPhiInstruction[n3];
                    n2 = 0;
                    n = 0;
                    while (n < sSAPhiInstructionArray.length) {
                        if (sSAPhiInstructionArray[n] != null) {
                            this.stackSlotPhis[n2++] = sSAPhiInstructionArray[n];
                        }
                        ++n;
                    }
                }
            }
            if (this.localPhis != null && this.localPhis[this.localPhis.length - 1] == null) {
                n3 = this.countNonNull(this.localPhis);
                if (n3 == 0) {
                    this.localPhis = null;
                } else {
                    sSAPhiInstructionArray = this.localPhis;
                    this.localPhis = new SSAPhiInstruction[n3];
                    n2 = 0;
                    n = 0;
                    while (n < sSAPhiInstructionArray.length) {
                        if (sSAPhiInstructionArray[n] != null) {
                            this.localPhis[n2++] = sSAPhiInstructionArray[n];
                        }
                        ++n;
                    }
                }
            }
        }

        private int countNonNull(SSAPhiInstruction[] sSAPhiInstructionArray) {
            int n = 0;
            int n2 = 0;
            while (n2 < sSAPhiInstructionArray.length) {
                if (sSAPhiInstructionArray[n2] != null) {
                    ++n;
                }
                ++n2;
            }
            return n;
        }

        @Override
        public Iterator<SSAInstruction> iterator() {
            return this.getAllInstructions().iterator();
        }

        public boolean hasPhi() {
            return this.stackSlotPhis != null || this.localPhis != null;
        }

        @Override
        public int getGraphNodeId() {
            return this.number;
        }

        @Override
        public void setGraphNodeId(int n) {
        }

        public String toString() {
            return "BB[SSA:" + this.getFirstInstructionIndex() + ".." + this.getLastInstructionIndex() + "]" + this.getNumber() + " - " + SSACFG.this.method.getSignature();
        }

        private SSACFG getGraph() {
            return SSACFG.this;
        }

        public boolean equals(Object object) {
            if (object instanceof BasicBlock) {
                BasicBlock basicBlock = (BasicBlock)object;
                if (this.getNumber() == basicBlock.getNumber()) {
                    if (this.getMethod().equals(basicBlock.getMethod())) {
                        return this.getGraph().equals(basicBlock.getGraph());
                    }
                    return false;
                }
                return false;
            }
            return false;
        }

        @Override
        public IMethod getMethod() {
            return SSACFG.this.method;
        }

        public int hashCode() {
            return SSACFG.this.delegate.getNode(this.getNumber()).hashCode() * 6271;
        }

        @Override
        public boolean isExitBlock() {
            return this == SSACFG.this.exit();
        }

        @Override
        public boolean isEntryBlock() {
            return this == SSACFG.this.entry();
        }

        @Override
        public SSAInstruction getLastInstruction() {
            return SSACFG.this.instructions[this.getLastInstructionIndex()];
        }

        @Override
        public Iterator<TypeReference> getCaughtExceptionTypes() {
            return EmptyIterator.instance();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExceptionHandlerBasicBlock
    extends BasicBlock {
        private TypeReference[] exceptionTypes;
        private static final int initialCapacity = 3;
        private int nExceptionTypes;
        private SSAGetCaughtExceptionInstruction catchInstruction;

        public ExceptionHandlerBasicBlock(int n) {
            super(n);
            this.nExceptionTypes = 0;
        }

        public SSAGetCaughtExceptionInstruction getCatchInstruction() {
            return this.catchInstruction;
        }

        public void setCatchInstruction(SSAGetCaughtExceptionInstruction sSAGetCaughtExceptionInstruction) {
            this.catchInstruction = sSAGetCaughtExceptionInstruction;
        }

        @Override
        public Iterator<TypeReference> getCaughtExceptionTypes() {
            return new Iterator<TypeReference>(){
                int next = 0;

                @Override
                public boolean hasNext() {
                    return this.next < ExceptionHandlerBasicBlock.this.nExceptionTypes;
                }

                @Override
                public TypeReference next() {
                    return ExceptionHandlerBasicBlock.this.exceptionTypes[this.next++];
                }

                @Override
                public void remove() {
                    Assertions.UNREACHABLE();
                }
            };
        }

        @Override
        public String toString() {
            return "BB(Handler)[SSA]" + this.getNumber() + " - " + SSACFG.this.method.getSignature();
        }

        public void addCaughtExceptionType(TypeReference typeReference) {
            if (this.exceptionTypes == null) {
                this.exceptionTypes = new TypeReference[3];
            }
            ++this.nExceptionTypes;
            if (this.nExceptionTypes > this.exceptionTypes.length) {
                TypeReference[] typeReferenceArray = this.exceptionTypes;
                this.exceptionTypes = new TypeReference[this.nExceptionTypes * 2];
                System.arraycopy(typeReferenceArray, 0, this.exceptionTypes, 0, typeReferenceArray.length);
            }
            this.exceptionTypes[this.nExceptionTypes - 1] = typeReference;
        }

        @Override
        public List<SSAInstruction> getAllInstructions() {
            List<SSAInstruction> list = super.getAllInstructions();
            if (this.catchInstruction != null) {
                list.add(0, this.catchInstruction);
            }
            return list;
        }
    }

    private static class ExceptionLoadFailure
    extends Warning {
        final TypeReference type;
        final IMethod method;

        ExceptionLoadFailure(TypeReference typeReference, IMethod iMethod) {
            super((byte)1);
            this.type = typeReference;
            this.method = iMethod;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.type + " " + this.method;
        }

        public static ExceptionLoadFailure create(TypeReference typeReference, IMethod iMethod) {
            return new ExceptionLoadFailure(typeReference, iMethod);
        }
    }

    private static class RefPathKey {
        private final int n;
        private final Object src;
        private final Object path;

        RefPathKey(int n, Object object, Object object2) {
            this.n = n;
            this.src = object;
            this.path = object2;
        }

        public int hashCode() {
            return this.n * this.path.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof RefPathKey && this.n == ((RefPathKey)object).n && this.src == ((RefPathKey)object).src && this.path == ((RefPathKey)object).path;
        }
    }
}

