/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;

public abstract class SSAArrayLengthInstruction
extends SSAInstruction {
    private final int result;
    private final int arrayref;

    protected SSAArrayLengthInstruction(int n, int n2) {
        this.result = n;
        this.arrayref = n2;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory sSAInstructionFactory, int[] nArray, int[] nArray2) throws IllegalArgumentException {
        if (nArray != null && nArray.length != 1) {
            throw new IllegalArgumentException();
        }
        if (nArray2 != null && nArray2.length != 1) {
            throw new IllegalArgumentException();
        }
        return sSAInstructionFactory.ArrayLengthInstruction(nArray == null ? this.result : nArray[0], nArray2 == null ? this.arrayref : nArray2[0]);
    }

    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.result)) + " = arraylength " + this.getValueString(symbolTable, this.arrayref);
    }

    public void visit(SSAInstruction.IVisitor iVisitor) throws NullPointerException {
        iVisitor.visitArrayLength(this);
    }

    public int getDef() {
        return this.result;
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef(int n) {
        if (n != 0) {
            throw new IllegalArgumentException("invalid i " + n);
        }
        return this.result;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public int getArrayRef() {
        return this.arrayref;
    }

    public int getNumberOfUses() {
        return 1;
    }

    public int getUse(int n) {
        if (n != 0) {
            throw new IllegalArgumentException("invalid j: " + n);
        }
        return this.arrayref;
    }

    public int hashCode() {
        return this.arrayref * 7573 + this.result * 563;
    }

    public boolean isPEI() {
        return true;
    }

    public boolean isFallThrough() {
        return true;
    }
}

