/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.Value;

public class ConstantValue
implements Value {
    private final Object constant;

    public ConstantValue(Object object) {
        this.constant = object;
    }

    public ConstantValue(int n) {
        this(new Integer(n));
    }

    public ConstantValue(double d) {
        this(new Double(d));
    }

    public Object getValue() {
        return this.constant;
    }

    public String toString() {
        return "#" + this.constant;
    }

    public boolean isStringConstant() {
        return this.constant instanceof String;
    }

    public boolean isFalseConstant() {
        return this.constant instanceof Boolean && this.constant.equals(Boolean.FALSE);
    }

    public boolean isTrueConstant() {
        return this.constant instanceof Boolean && this.constant.equals(Boolean.TRUE);
    }

    public boolean isZeroConstant() {
        return this.constant instanceof Number && ((Number)this.constant).intValue() == 0;
    }

    public boolean isNullConstant() {
        return this.constant == null;
    }

    public boolean isOneConstant() {
        return this.constant instanceof Number && ((Number)this.constant).intValue() == 1;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass().equals(this.getClass())) {
            ConstantValue constantValue = (ConstantValue)object;
            if (this.constant == null) {
                return constantValue.constant == null;
            }
            return this.constant.equals(constantValue.constant);
        }
        return false;
    }

    public int hashCode() {
        return this.constant == null ? 74 : 91 * this.constant.hashCode();
    }
}

