/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.properties;

import com.ibm.wala.core.plugin.CorePlugin;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileProvider;
import com.ibm.wala.util.io.FileUtil;
import com.ibm.wala.util.warnings.WalaException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public final class WalaProperties {
    public static final String WALA_REPORT = "WALA_report";
    public static final String INPUT_DIR = "input_dir";
    public static final String OUTPUT_DIR = "output_dir";
    public static final String J2SE_DIR = "java_runtime_dir";
    public static final String J2EE_DIR = "j2ee_runtime_dir";
    public static final String ECLIPSE_PLUGINS_DIR = "eclipse_plugins_dir";
    static final String PROPERTY_FILENAME = "wala.properties";

    public static String[] getJ2SEJarFiles() {
        Properties properties = null;
        try {
            properties = WalaProperties.loadProperties();
        }
        catch (WalaException walaException) {
            walaException.printStackTrace();
            throw new IllegalStateException("problem loading wala.properties");
        }
        String string = properties.getProperty(J2SE_DIR);
        Assertions.productionAssertion(string != null);
        return WalaProperties.getJarsInDirectory(string);
    }

    public static String[] getJ2EEJarFiles() {
        Properties properties = null;
        try {
            properties = WalaProperties.loadProperties();
        }
        catch (WalaException walaException) {
            walaException.printStackTrace();
            throw new IllegalStateException("problem loading wala.properties");
        }
        String string = properties.getProperty(J2EE_DIR);
        if (string == null) {
            throw new IllegalStateException("No J2EE directory specified");
        }
        return WalaProperties.getJarsInDirectory(string);
    }

    public static String[] getJarsInDirectory(String string) {
        File file = new File(string);
        Assertions.productionAssertion(file.isDirectory(), "not a directory: " + string);
        Collection<File> collection = FileUtil.listFiles(string, ".*\\.jar$", true);
        String[] stringArray = new String[collection.size()];
        int n = 0;
        for (File file2 : collection) {
            stringArray[n++] = file2.getAbsolutePath();
        }
        return stringArray;
    }

    public static Properties loadProperties() throws WalaException {
        try {
            Properties properties = WalaProperties.loadPropertiesFromFile(WalaProperties.class.getClassLoader(), PROPERTY_FILENAME);
            String string = properties.getProperty(OUTPUT_DIR, "results");
            properties.setProperty(OUTPUT_DIR, WalaProperties.convertToAbsolute(string));
            String string2 = properties.getProperty(WALA_REPORT, "wala_report.txt");
            properties.setProperty(WALA_REPORT, WalaProperties.convertToAbsolute(string2));
            return properties;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new WalaException("Unable to set up wala properties ", exception);
        }
    }

    static String convertToAbsolute(String string) {
        File file = new File(string);
        return file.isAbsolute() ? file.getAbsolutePath() : WalaProperties.getWalaHomeDir().concat(File.separator).concat(string);
    }

    public static Properties loadPropertiesFromFile(ClassLoader classLoader, String string) throws IOException {
        if (classLoader == null) {
            throw new IllegalArgumentException("loader is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("null fileName");
        }
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException("property_file_unreadable " + string);
        }
        Properties properties = new Properties();
        properties.load(inputStream);
        return properties;
    }

    @Deprecated
    public static String getWalaHomeDir() {
        String string = System.getProperty("WALA_HOME");
        if (string != null) {
            return string;
        }
        URL uRL = WalaProperties.class.getClassLoader().getResource(PROPERTY_FILENAME);
        if (uRL == null) {
            return System.getProperty("user.dir");
        }
        return new File(FileProvider.filePathFromURL(uRL)).getParentFile().getParentFile().getPath();
    }

    public static String getWalaCorePluginHome() {
        if (CorePlugin.getDefault() == null) {
            return null;
        }
        String string = Platform.getInstallLocation().getURL().getPath();
        Bundle bundle = Platform.getBundle((String)"com.ibm.wala.core");
        String string2 = bundle.getLocation();
        if (string2.startsWith("update@")) {
            string2 = string2.replace("update@", "");
        }
        if (string2.startsWith("reference:file:")) {
            return string2.replace("reference:file:", "");
        }
        return String.valueOf(string) + File.separator + string2;
    }
}

