/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.shrikeBT.BytecodeConstants;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLMethodSummaryReader
implements BytecodeConstants {
    static final boolean DEBUG = false;
    private final AnalysisScope scope;
    private final HashMap<MethodReference, MethodSummary> summaries = HashMapFactory.make();
    private final HashSet<TypeReference> allocatable = HashSetFactory.make();
    private final HashSet<Atom> ignoredPackages = HashSetFactory.make();
    private static final int E_CLASSLOADER = 0;
    private static final int E_METHOD = 1;
    private static final int E_CLASS = 2;
    private static final int E_PACKAGE = 3;
    private static final int E_CALL = 4;
    private static final int E_NEW = 5;
    private static final int E_POISON = 6;
    private static final int E_SUMMARY_SPEC = 7;
    private static final int E_RETURN = 8;
    private static final int E_PUTSTATIC = 9;
    private static final int E_AASTORE = 10;
    private static final int E_PUTFIELD = 11;
    private static final int E_GETFIELD = 12;
    private static final int E_ATHROW = 13;
    private static final int E_CONSTANT = 14;
    private static final Map<String, Integer> elementMap = HashMapFactory.make(14);
    private static final String A_NAME = "name";
    private static final String A_TYPE = "type";
    private static final String A_CLASS = "class";
    private static final String A_SIZE = "size";
    private static final String A_DESCRIPTOR = "descriptor";
    private static final String A_REASON = "reason";
    private static final String A_LEVEL = "level";
    private static final String A_WILDCARD = "*";
    private static final String A_DEF = "def";
    private static final String A_STATIC = "static";
    private static final String A_VALUE = "value";
    private static final String A_FIELD = "field";
    private static final String A_FIELD_TYPE = "fieldType";
    private static final String A_ARG = "arg";
    private static final String A_ALLOCATABLE = "allocatable";
    private static final String A_REF = "ref";
    private static final String A_INDEX = "index";
    private static final String A_IGNORE = "ignore";
    private static final String A_FACTORY = "factory";
    private static final String A_NUM_ARGS = "numArgs";
    private static final String V_NULL = "null";
    private static final String V_TRUE = "true";

    static {
        elementMap.put("classloader", new Integer(0));
        elementMap.put("method", new Integer(1));
        elementMap.put(A_CLASS, new Integer(2));
        elementMap.put("package", new Integer(3));
        elementMap.put("call", new Integer(4));
        elementMap.put("new", new Integer(5));
        elementMap.put("poison", new Integer(6));
        elementMap.put("summary-spec", new Integer(7));
        elementMap.put("return", new Integer(8));
        elementMap.put("putstatic", new Integer(9));
        elementMap.put("aastore", new Integer(10));
        elementMap.put("putfield", new Integer(11));
        elementMap.put("getfield", new Integer(12));
        elementMap.put("throw", new Integer(13));
        elementMap.put("constant", new Integer(14));
    }

    public XMLMethodSummaryReader(InputStream inputStream, AnalysisScope analysisScope) {
        if (inputStream == null) {
            throw new IllegalArgumentException("null xmlFile");
        }
        if (analysisScope == null) {
            throw new IllegalArgumentException("null scope");
        }
        this.scope = analysisScope;
        try {
            this.readXML(inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    private void readXML(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        SAXHandler sAXHandler = new SAXHandler();
        assert (inputStream != null) : "Null xml stream";
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.newSAXParser().parse(new InputSource(inputStream), (DefaultHandler)sAXHandler);
    }

    public Map<MethodReference, MethodSummary> getSummaries() {
        return this.summaries;
    }

    public Set<TypeReference> getAllocatableClasses() {
        return this.allocatable;
    }

    public Set<Atom> getIgnoredPackages() {
        return this.ignoredPackages;
    }

    private class SAXHandler
    extends DefaultHandler {
        private ClassLoaderReference governingLoader = null;
        private MethodSummary governingMethod = null;
        private TypeReference governingClass = null;
        private Atom governingPackage = null;
        private int nextLocal = -1;
        private Map<String, Integer> symbolTable = null;

        private SAXHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            Integer n = (Integer)elementMap.get(string3);
            if (n == null) {
                Assertions.UNREACHABLE("Invalid element: " + string3);
            }
            switch (n) {
                case 0: {
                    String string4 = attributes.getValue(XMLMethodSummaryReader.A_NAME);
                    this.governingLoader = this.classLoaderName2Ref(string4);
                    break;
                }
                case 1: {
                    String string5 = attributes.getValue(XMLMethodSummaryReader.A_NAME);
                    if (string5.equals(XMLMethodSummaryReader.A_WILDCARD)) {
                        Assertions.UNREACHABLE("Wildcards not currently implemented.");
                        break;
                    }
                    this.startMethod(attributes);
                    break;
                }
                case 2: {
                    String string6 = attributes.getValue(XMLMethodSummaryReader.A_NAME);
                    if (string6.equals(XMLMethodSummaryReader.A_WILDCARD)) {
                        Assertions.UNREACHABLE("Wildcards not currently implemented");
                        break;
                    }
                    this.startClass(string6, attributes);
                    break;
                }
                case 3: {
                    this.governingPackage = Atom.findOrCreateUnicodeAtom(attributes.getValue(XMLMethodSummaryReader.A_NAME));
                    String string7 = attributes.getValue(XMLMethodSummaryReader.A_IGNORE);
                    if (string7 == null || !string7.equals(XMLMethodSummaryReader.V_TRUE)) break;
                    XMLMethodSummaryReader.this.ignoredPackages.add(this.governingPackage);
                    break;
                }
                case 4: {
                    this.processCallSite(attributes);
                    break;
                }
                case 5: {
                    this.processAllocation(attributes);
                    break;
                }
                case 9: {
                    this.processPutStatic(attributes);
                    break;
                }
                case 11: {
                    this.processPutField(attributes);
                    break;
                }
                case 12: {
                    this.processGetField(attributes);
                    break;
                }
                case 13: {
                    this.processAthrow(attributes);
                    break;
                }
                case 10: {
                    this.processAastore(attributes);
                    break;
                }
                case 8: {
                    this.processReturn(attributes);
                    break;
                }
                case 6: {
                    this.processPoison(attributes);
                    break;
                }
                case 14: {
                    this.processConstant(attributes);
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    Assertions.UNREACHABLE("Unexpected element: " + string2);
                }
            }
        }

        private void startClass(String string, Attributes attributes) {
            String string2 = "L" + this.governingPackage + "/" + string;
            this.governingClass = this.className2Ref(string2);
            String string3 = attributes.getValue(XMLMethodSummaryReader.A_ALLOCATABLE);
            if (string3 != null) {
                Assertions.productionAssertion(string3.equals(XMLMethodSummaryReader.V_TRUE));
                XMLMethodSummaryReader.this.allocatable.add(this.governingClass);
            }
        }

        public void endElement(String string, String string2, String string3) {
            Integer n = (Integer)elementMap.get(string3);
            if (n == null) {
                Assertions.UNREACHABLE("Invalid element: " + string2);
            }
            switch (n) {
                case 0: {
                    this.governingLoader = null;
                    break;
                }
                case 1: {
                    if (this.governingMethod != null) {
                        this.checkReturnValue(this.governingMethod);
                    }
                    this.governingMethod = null;
                    this.symbolTable = null;
                    break;
                }
                case 2: {
                    this.governingClass = null;
                    break;
                }
                case 3: {
                    this.governingPackage = null;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    break;
                }
                default: {
                    Assertions.UNREACHABLE("Unexpected element: " + string2);
                }
            }
        }

        private void checkReturnValue(MethodSummary methodSummary) {
            Assertions.productionAssertion(methodSummary != null);
            Assertions.productionAssertion(methodSummary.getReturnType() != null);
            if (methodSummary.getReturnType().isReferenceType()) {
                SSAInstruction[] sSAInstructionArray = methodSummary.getStatements();
                int n = 0;
                while (n < sSAInstructionArray.length) {
                    if (sSAInstructionArray[n] instanceof SSAReturnInstruction) {
                        return;
                    }
                    ++n;
                }
                Assertions.UNREACHABLE("Method summary " + methodSummary + " must have a return statement.");
            }
        }

        private void processCallSite(Attributes attributes) {
            String string;
            String string2 = attributes.getValue(XMLMethodSummaryReader.A_TYPE);
            String string3 = attributes.getValue(XMLMethodSummaryReader.A_NAME);
            String string4 = attributes.getValue(XMLMethodSummaryReader.A_CLASS);
            String string5 = attributes.getValue(XMLMethodSummaryReader.A_DESCRIPTOR);
            TypeReference typeReference = TypeReference.findOrCreate(this.governingLoader, TypeName.string2TypeName(string4));
            Atom atom = Atom.findOrCreateAsciiAtom(string3);
            Language language = XMLMethodSummaryReader.this.scope.getLanguage(this.governingLoader.getLanguage());
            SSAInstructionFactory sSAInstructionFactory = language.instructionFactory();
            Descriptor descriptor = Descriptor.findOrCreateUTF8(language, string5);
            MethodReference methodReference = MethodReference.findOrCreate(typeReference, atom, descriptor);
            CallSiteReference callSiteReference = null;
            int n = methodReference.getNumberOfParameters();
            if (string2.equals("virtual")) {
                callSiteReference = CallSiteReference.make(this.governingMethod.getNextProgramCounter(), methodReference, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.VIRTUAL);
                ++n;
            } else if (string2.equals("special")) {
                callSiteReference = CallSiteReference.make(this.governingMethod.getNextProgramCounter(), methodReference, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.SPECIAL);
                ++n;
            } else if (string2.equals("interface")) {
                callSiteReference = CallSiteReference.make(this.governingMethod.getNextProgramCounter(), methodReference, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.INTERFACE);
                ++n;
            } else if (string2.equals(XMLMethodSummaryReader.A_STATIC)) {
                callSiteReference = CallSiteReference.make(this.governingMethod.getNextProgramCounter(), methodReference, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.STATIC);
            } else {
                Assertions.UNREACHABLE("Invalid call type " + string2);
            }
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < nArray.length) {
                string = attributes.getValue(XMLMethodSummaryReader.A_ARG + n2);
                Assertions.productionAssertion(string != null, "unspecified arg in method " + this.governingMethod + " " + callSiteReference);
                Integer n3 = this.symbolTable.get(string);
                if (n3 == null) {
                    Assertions.UNREACHABLE("Cannot lookup value: " + string);
                }
                nArray[n2] = n3;
                ++n2;
            }
            n2 = this.nextLocal++;
            string = attributes.getValue(XMLMethodSummaryReader.A_DEF);
            if (string != null) {
                if (this.symbolTable.keySet().contains(string)) {
                    Assertions.UNREACHABLE("Cannot def variable twice: " + string + " in " + this.governingMethod);
                }
                int n4 = this.nextLocal;
                this.symbolTable.put(string, new Integer(this.nextLocal++));
                this.governingMethod.addStatement(sSAInstructionFactory.InvokeInstruction(n4, nArray, n2, callSiteReference));
            } else {
                this.governingMethod.addStatement(sSAInstructionFactory.InvokeInstruction(nArray, n2, callSiteReference));
            }
        }

        private void processAllocation(Attributes attributes) {
            Language language = XMLMethodSummaryReader.this.scope.getLanguage(this.governingLoader.getLanguage());
            SSAInstructionFactory sSAInstructionFactory = language.instructionFactory();
            String string = attributes.getValue(XMLMethodSummaryReader.A_CLASS);
            TypeReference typeReference = TypeReference.findOrCreate(this.governingLoader, TypeName.string2TypeName(string));
            String string2 = attributes.getValue(XMLMethodSummaryReader.A_DEF);
            if (this.symbolTable.keySet().contains(string2)) {
                Assertions.UNREACHABLE("Cannot def variable twice: " + string2 + " in " + this.governingMethod);
            }
            if (string2 == null) {
                string2 = "L" + this.nextLocal;
            }
            int n = this.nextLocal;
            this.symbolTable.put(string2, new Integer(this.nextLocal++));
            NewSiteReference newSiteReference = NewSiteReference.make(this.governingMethod.getNextProgramCounter(), typeReference);
            SSANewInstruction sSANewInstruction = null;
            if (typeReference.isArrayType()) {
                String string3 = attributes.getValue(XMLMethodSummaryReader.A_SIZE);
                Assertions.productionAssertion(string3 != null);
                Integer n2 = this.symbolTable.get(string3);
                Assertions.productionAssertion(n2 != null);
                Assertions.productionAssertion(typeReference.getDimensionality() == 1);
                sSANewInstruction = sSAInstructionFactory.NewInstruction(n, newSiteReference, new int[]{n2});
            } else {
                sSANewInstruction = sSAInstructionFactory.NewInstruction(n, newSiteReference);
            }
            this.governingMethod.addStatement(sSANewInstruction);
        }

        private void processAthrow(Attributes attributes) {
            Integer n;
            Language language = XMLMethodSummaryReader.this.scope.getLanguage(this.governingLoader.getLanguage());
            SSAInstructionFactory sSAInstructionFactory = language.instructionFactory();
            String string = attributes.getValue(XMLMethodSummaryReader.A_VALUE);
            if (string == null) {
                Assertions.UNREACHABLE("Must specify value for putfield " + this.governingMethod);
            }
            if ((n = this.symbolTable.get(string)) == null) {
                Assertions.UNREACHABLE("Cannot lookup value: " + string);
            }
            SSAThrowInstruction sSAThrowInstruction = sSAInstructionFactory.ThrowInstruction(n);
            this.governingMethod.addStatement(sSAThrowInstruction);
        }

        private void processGetField(Attributes attributes) {
            Integer n;
            Language language = XMLMethodSummaryReader.this.scope.getLanguage(this.governingLoader.getLanguage());
            SSAInstructionFactory sSAInstructionFactory = language.instructionFactory();
            String string = attributes.getValue(XMLMethodSummaryReader.A_CLASS);
            TypeReference typeReference = TypeReference.findOrCreate(this.governingLoader, TypeName.string2TypeName(string));
            String string2 = attributes.getValue(XMLMethodSummaryReader.A_FIELD);
            Atom atom = Atom.findOrCreateAsciiAtom(string2);
            String string3 = attributes.getValue(XMLMethodSummaryReader.A_FIELD_TYPE);
            TypeReference typeReference2 = TypeReference.findOrCreate(this.governingLoader, TypeName.string2TypeName(string3));
            FieldReference fieldReference = FieldReference.findOrCreate(typeReference, atom, typeReference2);
            String string4 = attributes.getValue(XMLMethodSummaryReader.A_DEF);
            if (this.symbolTable.keySet().contains(string4)) {
                Assertions.UNREACHABLE("Cannot def variable twice: " + string4 + " in " + this.governingMethod);
            }
            if (string4 == null) {
                Assertions.UNREACHABLE("Must specify def for getfield " + this.governingMethod);
            }
            int n2 = this.nextLocal;
            this.symbolTable.put(string4, new Integer(this.nextLocal++));
            String string5 = attributes.getValue(XMLMethodSummaryReader.A_REF);
            if (string5 == null) {
                Assertions.UNREACHABLE("Must specify ref for getfield " + this.governingMethod);
            }
            if ((n = this.symbolTable.get(string5)) == null) {
                Assertions.UNREACHABLE("Cannot lookup ref: " + string5);
            }
            SSAGetInstruction sSAGetInstruction = sSAInstructionFactory.GetInstruction(n2, n, fieldReference);
            this.governingMethod.addStatement(sSAGetInstruction);
        }

        private void processPutField(Attributes attributes) {
            Integer n;
            String string;
            Integer n2;
            Language language = XMLMethodSummaryReader.this.scope.getLanguage(this.governingLoader.getLanguage());
            SSAInstructionFactory sSAInstructionFactory = language.instructionFactory();
            String string2 = attributes.getValue(XMLMethodSummaryReader.A_CLASS);
            TypeReference typeReference = TypeReference.findOrCreate(this.governingLoader, TypeName.string2TypeName(string2));
            String string3 = attributes.getValue(XMLMethodSummaryReader.A_FIELD);
            Atom atom = Atom.findOrCreateAsciiAtom(string3);
            String string4 = attributes.getValue(XMLMethodSummaryReader.A_FIELD_TYPE);
            TypeReference typeReference2 = TypeReference.findOrCreate(this.governingLoader, TypeName.string2TypeName(string4));
            FieldReference fieldReference = FieldReference.findOrCreate(typeReference, atom, typeReference2);
            String string5 = attributes.getValue(XMLMethodSummaryReader.A_VALUE);
            if (string5 == null) {
                Assertions.UNREACHABLE("Must specify value for putfield " + this.governingMethod);
            }
            if ((n2 = this.symbolTable.get(string5)) == null) {
                Assertions.UNREACHABLE("Cannot lookup value: " + string5);
            }
            if ((string = attributes.getValue(XMLMethodSummaryReader.A_REF)) == null) {
                Assertions.UNREACHABLE("Must specify ref for putfield " + this.governingMethod);
            }
            if ((n = this.symbolTable.get(string)) == null) {
                Assertions.UNREACHABLE("Cannot lookup ref: " + string);
            }
            SSAPutInstruction sSAPutInstruction = sSAInstructionFactory.PutInstruction(n, n2, fieldReference);
            this.governingMethod.addStatement(sSAPutInstruction);
        }

        private void processPutStatic(Attributes attributes) {
            Integer n;
            Language language = XMLMethodSummaryReader.this.scope.getLanguage(this.governingLoader.getLanguage());
            SSAInstructionFactory sSAInstructionFactory = language.instructionFactory();
            String string = attributes.getValue(XMLMethodSummaryReader.A_CLASS);
            TypeReference typeReference = TypeReference.findOrCreate(this.governingLoader, TypeName.string2TypeName(string));
            String string2 = attributes.getValue(XMLMethodSummaryReader.A_FIELD);
            Atom atom = Atom.findOrCreateAsciiAtom(string2);
            String string3 = attributes.getValue(XMLMethodSummaryReader.A_FIELD_TYPE);
            TypeReference typeReference2 = TypeReference.findOrCreate(this.governingLoader, TypeName.string2TypeName(string3));
            FieldReference fieldReference = FieldReference.findOrCreate(typeReference, atom, typeReference2);
            String string4 = attributes.getValue(XMLMethodSummaryReader.A_VALUE);
            if (string4 == null) {
                Assertions.UNREACHABLE("Must specify value for putstatic " + this.governingMethod);
            }
            if ((n = this.symbolTable.get(string4)) == null) {
                Assertions.UNREACHABLE("Cannot lookup value: " + string4);
            }
            SSAPutInstruction sSAPutInstruction = sSAInstructionFactory.PutInstruction(n, fieldReference);
            this.governingMethod.addStatement(sSAPutInstruction);
        }

        private void processAastore(Attributes attributes) {
            Integer n;
            String string;
            String string2;
            Integer n2;
            Language language = XMLMethodSummaryReader.this.scope.getLanguage(this.governingLoader.getLanguage());
            SSAInstructionFactory sSAInstructionFactory = language.instructionFactory();
            String string3 = attributes.getValue(XMLMethodSummaryReader.A_REF);
            if (string3 == null) {
                Assertions.UNREACHABLE("Must specify ref for aastore " + this.governingMethod);
            }
            if ((n2 = this.symbolTable.get(string3)) == null) {
                Assertions.UNREACHABLE("Cannot lookup value: " + string3);
            }
            if ((string2 = attributes.getValue(XMLMethodSummaryReader.A_INDEX)) == null) {
                Assertions.UNREACHABLE("Must specify index for aastore " + this.governingMethod);
            }
            if ((string = attributes.getValue(XMLMethodSummaryReader.A_VALUE)) == null) {
                Assertions.UNREACHABLE("Must specify value for aastore " + this.governingMethod);
            }
            if ((n = this.symbolTable.get(string)) == null) {
                Assertions.UNREACHABLE("Cannot lookup value: " + string);
            }
            SSAArrayStoreInstruction sSAArrayStoreInstruction = sSAInstructionFactory.ArrayStoreInstruction(n2, 0, n, TypeReference.JavaLangObject);
            this.governingMethod.addStatement(sSAArrayStoreInstruction);
        }

        private void processReturn(Attributes attributes) {
            Language language = XMLMethodSummaryReader.this.scope.getLanguage(this.governingLoader.getLanguage());
            SSAInstructionFactory sSAInstructionFactory = language.instructionFactory();
            if (this.governingMethod.getReturnType() != null) {
                String string = attributes.getValue(XMLMethodSummaryReader.A_VALUE);
                if (string == null) {
                    SSAReturnInstruction sSAReturnInstruction = sSAInstructionFactory.ReturnInstruction();
                    this.governingMethod.addStatement(sSAReturnInstruction);
                } else {
                    Integer n = this.symbolTable.get(string);
                    if (n == null) {
                        if (!string.equals(XMLMethodSummaryReader.V_NULL)) {
                            Assertions.UNREACHABLE("Cannot return value with no def: " + string);
                        } else {
                            n = this.symbolTable.get(XMLMethodSummaryReader.V_NULL);
                            if (n == null) {
                                n = new Integer(this.nextLocal++);
                                this.symbolTable.put(XMLMethodSummaryReader.V_NULL, n);
                            }
                        }
                    }
                    boolean bl = this.governingMethod.getReturnType().isPrimitiveType();
                    SSAReturnInstruction sSAReturnInstruction = sSAInstructionFactory.ReturnInstruction(n, bl);
                    this.governingMethod.addStatement(sSAReturnInstruction);
                }
            }
        }

        private void processConstant(Attributes attributes) {
            String string = attributes.getValue(XMLMethodSummaryReader.A_NAME);
            if (string == null) {
                Assertions.UNREACHABLE("Must give name for constant");
            }
            Integer n = new Integer(this.nextLocal++);
            this.symbolTable.put(string, n);
            String string2 = attributes.getValue(XMLMethodSummaryReader.A_TYPE);
            String string3 = attributes.getValue(XMLMethodSummaryReader.A_VALUE);
            this.governingMethod.addConstant(n, string2.equals("int") ? new ConstantValue(new Integer(string3)) : (string2.equals("long") ? new ConstantValue(new Long(string3)) : (string2.equals("short") ? new ConstantValue(new Short(string3)) : (string2.equals("float") ? new ConstantValue(new Float(string3)) : (string2.equals("double") ? new ConstantValue(new Double(string3)) : null)))));
        }

        private void processPoison(Attributes attributes) {
            String string = attributes.getValue(XMLMethodSummaryReader.A_REASON);
            this.governingMethod.addPoison(string);
            String string2 = attributes.getValue(XMLMethodSummaryReader.A_LEVEL);
            if (string2.equals("severe")) {
                this.governingMethod.setPoisonLevel((byte)2);
            } else if (string2.equals("moderate")) {
                this.governingMethod.setPoisonLevel((byte)1);
            } else if (string2.equals("mild")) {
                this.governingMethod.setPoisonLevel((byte)0);
            } else {
                Assertions.UNREACHABLE("Unexpected level: " + string2);
            }
        }

        private void startMethod(Attributes attributes) {
            int n;
            String string;
            String string2;
            String string3 = attributes.getValue(XMLMethodSummaryReader.A_NAME);
            Atom atom = Atom.findOrCreateUnicodeAtom(string3);
            String string4 = attributes.getValue(XMLMethodSummaryReader.A_DESCRIPTOR);
            Language language = XMLMethodSummaryReader.this.scope.getLanguage(this.governingLoader.getLanguage());
            Descriptor descriptor = Descriptor.findOrCreateUTF8(language, string4);
            MethodReference methodReference = MethodReference.findOrCreate(this.governingClass, atom, descriptor);
            this.governingMethod = new MethodSummary(methodReference);
            XMLMethodSummaryReader.this.summaries.put(methodReference, this.governingMethod);
            boolean bl = false;
            String string5 = attributes.getValue(XMLMethodSummaryReader.A_STATIC);
            if (string5 != null) {
                if (string5.equals(XMLMethodSummaryReader.V_TRUE)) {
                    bl = true;
                    this.governingMethod.setStatic(true);
                } else if (string5.equals("false")) {
                    bl = false;
                    this.governingMethod.setStatic(false);
                } else {
                    Assertions.UNREACHABLE("Invalid attribute value static: " + string5);
                }
            }
            if ((string2 = attributes.getValue(XMLMethodSummaryReader.A_FACTORY)) != null) {
                if (string2.equals(XMLMethodSummaryReader.V_TRUE)) {
                    this.governingMethod.setFactory(true);
                } else if (string2.equals("false")) {
                    this.governingMethod.setFactory(false);
                } else {
                    Assertions.UNREACHABLE("Invalid attribute value factory: " + string2);
                }
            }
            if ((string = attributes.getValue(XMLMethodSummaryReader.A_NUM_ARGS)) == null) {
                n = methodReference.getNumberOfParameters();
                if (!bl) {
                    ++n;
                }
            } else {
                n = Integer.parseInt(string);
            }
            this.nextLocal = n + 1;
            this.symbolTable = HashMapFactory.make(5);
            int n2 = 0;
            while (n2 < n) {
                this.symbolTable.put(XMLMethodSummaryReader.A_ARG + n2, new Integer(n2 + 1));
                ++n2;
            }
        }

        private ClassLoaderReference classLoaderName2Ref(String string) {
            return XMLMethodSummaryReader.this.scope.getLoader(Atom.findOrCreateUnicodeAtom(string));
        }

        private TypeReference className2Ref(String string) {
            return TypeReference.findOrCreate(this.governingLoader, TypeName.string2TypeName(string));
        }
    }
}

