/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.SetType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionSummary {
    private final Map<Integer, Set<TypeReference>> map = HashMapFactory.make();

    public void addType(int n, TypeReference typeReference) {
        Set<TypeReference> set = this.findOrCreateSetForBCIndex(n);
        set.add(typeReference);
    }

    private Set<TypeReference> findOrCreateSetForBCIndex(int n) {
        Integer n2 = new Integer(n);
        Set<TypeReference> set = this.map.get(n2);
        if (set == null) {
            set = HashSetFactory.make(10);
            this.map.put(n2, set);
        }
        return set;
    }

    public TypeAbstraction getTypeForNewInstance(int n, IClassHierarchy iClassHierarchy) {
        if (iClassHierarchy == null) {
            throw new IllegalArgumentException("null cha");
        }
        Set<TypeReference> set = this.map.get(new Integer(n));
        if (set == null) {
            return null;
        }
        PointType[] pointTypeArray = new PointType[set.size()];
        Iterator<TypeReference> iterator = set.iterator();
        int n2 = 0;
        while (n2 < pointTypeArray.length) {
            TypeReference typeReference = iterator.next();
            IClass iClass = iClassHierarchy.lookupClass(typeReference);
            assert (iClass != null) : "null type for " + typeReference;
            pointTypeArray[n2] = new PointType(iClass);
            ++n2;
        }
        return new SetType(pointTypeArray);
    }

    public Set<TypeReference> getTypesForProgramLocation(int n) {
        return this.map.get(new Integer(n));
    }
}

