/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer.thin;

import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.modref.DelegatingExtendedHeapModel;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.SDG;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ipa.slicer.thin.CISDG;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.graph.traverse.DFS;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CISlicer {
    private final Graph<Statement> depGraph;

    public CISlicer(CallGraph callGraph, PointerAnalysis pointerAnalysis, Slicer.DataDependenceOptions dataDependenceOptions, Slicer.ControlDependenceOptions controlDependenceOptions) {
        this(callGraph, pointerAnalysis, ModRef.make(), dataDependenceOptions, controlDependenceOptions);
    }

    public CISlicer(CallGraph callGraph, PointerAnalysis pointerAnalysis, ModRef modRef, Slicer.DataDependenceOptions dataDependenceOptions, Slicer.ControlDependenceOptions controlDependenceOptions) throws IllegalArgumentException {
        if (dataDependenceOptions == null) {
            throw new IllegalArgumentException("dOptions == null");
        }
        if (dataDependenceOptions.equals((Object)Slicer.DataDependenceOptions.NO_BASE_PTRS) || dataDependenceOptions.equals((Object)Slicer.DataDependenceOptions.FULL)) {
            throw new IllegalArgumentException("Heap data dependences requested in CISlicer!");
        }
        SDG sDG = new SDG(callGraph, pointerAnalysis, modRef, dataDependenceOptions, controlDependenceOptions, null);
        Map<Statement, Set<PointerKey>> map = CISlicer.scanForMod(sDG, pointerAnalysis, modRef);
        Map<Statement, Set<PointerKey>> map2 = CISlicer.scanForRef(sDG, pointerAnalysis, modRef);
        this.depGraph = GraphInverter.invert(new CISDG(sDG, map, map2));
    }

    public CISlicer(SDG sDG, PointerAnalysis pointerAnalysis, ModRef modRef) {
        Map<Statement, Set<PointerKey>> map = CISlicer.scanForMod(sDG, pointerAnalysis, modRef);
        Map<Statement, Set<PointerKey>> map2 = CISlicer.scanForRef(sDG, pointerAnalysis, modRef);
        this.depGraph = GraphInverter.invert(new CISDG(sDG, map, map2));
    }

    public Collection<Statement> computeBackwardThinSlice(Statement statement) {
        Set<Statement> set = DFS.getReachableNodes(this.depGraph, Collections.singleton(statement));
        return set;
    }

    public Collection<Statement> computeBackwardThinSlice(Collection<Statement> collection) {
        Set<Statement> set = DFS.getReachableNodes(this.depGraph, collection);
        return set;
    }

    public static Map<Statement, Set<PointerKey>> scanForMod(SDG sDG, PointerAnalysis pointerAnalysis) {
        return CISlicer.scanForMod(sDG, pointerAnalysis, false, ModRef.make());
    }

    public static Map<Statement, Set<PointerKey>> scanForRef(SDG sDG, PointerAnalysis pointerAnalysis) {
        if (sDG == null) {
            throw new IllegalArgumentException("null sdg");
        }
        return CISlicer.scanForRef(sDG, pointerAnalysis, ModRef.make());
    }

    public static Map<Statement, Set<PointerKey>> scanForMod(SDG sDG, PointerAnalysis pointerAnalysis, ModRef modRef) {
        return CISlicer.scanForMod(sDG, pointerAnalysis, false, modRef);
    }

    public static Map<Statement, Set<PointerKey>> scanForMod(SDG sDG, PointerAnalysis pointerAnalysis, boolean bl, ModRef modRef) {
        if (pointerAnalysis == null) {
            throw new IllegalArgumentException("null pa");
        }
        DelegatingExtendedHeapModel delegatingExtendedHeapModel = new DelegatingExtendedHeapModel(pointerAnalysis.getHeapModel());
        HashMap<Statement, Set<PointerKey>> hashMap = HashMapFactory.make();
        for (CGNode cGNode : sDG.getCallGraph()) {
            IR iR = cGNode.getIR();
            if (iR == null) continue;
            int n = 0;
            while (n < iR.getInstructions().length) {
                Set<PointerKey> set;
                SSAInstruction sSAInstruction = iR.getInstructions()[n];
                if (sSAInstruction != null && !(set = modRef.getMod(cGNode, delegatingExtendedHeapModel, pointerAnalysis, sSAInstruction, null, bl)).isEmpty()) {
                    NormalStatement normalStatement = new NormalStatement(cGNode, n);
                    hashMap.put(normalStatement, set);
                }
                ++n;
            }
        }
        return hashMap;
    }

    public static Map<Statement, Set<PointerKey>> scanForRef(SDG sDG, PointerAnalysis pointerAnalysis, ModRef modRef) {
        if (pointerAnalysis == null) {
            throw new IllegalArgumentException("null pa");
        }
        DelegatingExtendedHeapModel delegatingExtendedHeapModel = new DelegatingExtendedHeapModel(pointerAnalysis.getHeapModel());
        HashMap<Statement, Set<PointerKey>> hashMap = HashMapFactory.make();
        for (CGNode cGNode : sDG.getCallGraph()) {
            IR iR = cGNode.getIR();
            if (iR == null) continue;
            int n = 0;
            while (n < iR.getInstructions().length) {
                Set<PointerKey> set;
                SSAInstruction sSAInstruction = iR.getInstructions()[n];
                if (sSAInstruction != null && !(set = modRef.getRef(cGNode, delegatingExtendedHeapModel, pointerAnalysis, sSAInstruction, null)).isEmpty()) {
                    NormalStatement normalStatement = new NormalStatement(cGNode, n);
                    hashMap.put(normalStatement, set);
                }
                ++n;
            }
        }
        return hashMap;
    }
}

