/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.dataflow.IFDS.BackwardsSupergraph;
import com.ibm.wala.dataflow.IFDS.IMergeFunction;
import com.ibm.wala.dataflow.IFDS.IPartiallyBalancedFlowFunctions;
import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.dataflow.IFDS.PartiallyBalancedTabulationProblem;
import com.ibm.wala.dataflow.IFDS.PartiallyBalancedTabulationSolver;
import com.ibm.wala.dataflow.IFDS.PathEdge;
import com.ibm.wala.dataflow.IFDS.TabulationDomain;
import com.ibm.wala.dataflow.IFDS.TabulationResult;
import com.ibm.wala.dataflow.IFDS.UnorderedDomain;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.ipa.slicer.ISDG;
import com.ibm.wala.ipa.slicer.MethodEntryStatement;
import com.ibm.wala.ipa.slicer.MethodExitStatement;
import com.ibm.wala.ipa.slicer.PDG;
import com.ibm.wala.ipa.slicer.SDG;
import com.ibm.wala.ipa.slicer.SDGSupergraph;
import com.ibm.wala.ipa.slicer.SliceFunctions;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slicer {
    public static final boolean DEBUG = false;
    public static final boolean VERBOSE = false;

    public static Collection<Statement> computeBackwardSlice(Statement statement, CallGraph callGraph, PointerAnalysis pointerAnalysis, DataDependenceOptions dataDependenceOptions, ControlDependenceOptions controlDependenceOptions) throws IllegalArgumentException, CancelException {
        return Slicer.computeSlice(new SDG(callGraph, pointerAnalysis, ModRef.make(), dataDependenceOptions, controlDependenceOptions), Collections.singleton(statement), true);
    }

    public static Collection<Statement> computeForwardSlice(Statement statement, CallGraph callGraph, PointerAnalysis pointerAnalysis, DataDependenceOptions dataDependenceOptions, ControlDependenceOptions controlDependenceOptions) throws IllegalArgumentException, CancelException {
        return Slicer.computeSlice(new SDG(callGraph, pointerAnalysis, ModRef.make(), dataDependenceOptions, controlDependenceOptions), Collections.singleton(statement), false);
    }

    public static Collection<Statement> computeBackwardSlice(SDG sDG, Statement statement) throws IllegalArgumentException, CancelException {
        return Slicer.computeSlice(sDG, Collections.singleton(statement), true);
    }

    public static Collection<Statement> computeForwardSlice(SDG sDG, Statement statement) throws IllegalArgumentException, CancelException {
        return Slicer.computeSlice(sDG, Collections.singleton(statement), false);
    }

    public static Collection<Statement> computeBackwardSlice(SDG sDG, Collection<Statement> collection) throws IllegalArgumentException, CancelException {
        return Slicer.computeSlice(sDG, collection, true);
    }

    protected static Collection<Statement> computeSlice(SDG sDG, Collection<Statement> collection, boolean bl) throws CancelException {
        if (sDG == null) {
            throw new IllegalArgumentException("sdg cannot be null");
        }
        return new Slicer().slice(sDG, collection, bl);
    }

    public Collection<Statement> slice(SDG sDG, Collection<Statement> collection, boolean bl) throws CancelException {
        if (sDG == null) {
            throw new IllegalArgumentException("sdg cannot be null");
        }
        SliceProblem sliceProblem = this.makeSliceProblem(collection, sDG, bl);
        PartiallyBalancedTabulationSolver<Statement, PDG, Object> partiallyBalancedTabulationSolver = PartiallyBalancedTabulationSolver.createPartiallyBalancedTabulationSolver(sliceProblem, null);
        TabulationResult tabulationResult = partiallyBalancedTabulationSolver.solve();
        Collection<Statement> collection2 = tabulationResult.getSupergraphNodesReached();
        return collection2;
    }

    protected SliceProblem makeSliceProblem(Collection<Statement> collection, ISDG iSDG, boolean bl) {
        return new SliceProblem(collection, iSDG, bl);
    }

    public static Collection<Statement> computeBackwardSlice(Statement statement, CallGraph callGraph, PointerAnalysis pointerAnalysis) throws IllegalArgumentException, CancelException {
        return Slicer.computeBackwardSlice(statement, callGraph, pointerAnalysis, DataDependenceOptions.FULL, ControlDependenceOptions.FULL);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ControlDependenceOptions {
        FULL("full"),
        NONE("none"),
        NO_EXCEPTIONAL_EDGES("no_exceptional_edges");

        private final String name;

        private ControlDependenceOptions(String string2) {
            this.name = string2;
        }

        public final String getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataDependenceOptions {
        FULL("full", false, false, false, false),
        NO_BASE_PTRS("no_base_ptrs", true, false, false, false),
        NO_BASE_NO_HEAP("no_base_no_heap", true, true, false, false),
        NO_BASE_NO_EXCEPTIONS("no_base_no_exceptions", true, false, false, true),
        NO_BASE_NO_HEAP_NO_EXCEPTIONS("no_base_no_heap_no_exceptions", true, true, false, true),
        NO_HEAP("no_heap", false, true, false, false),
        NO_HEAP_NO_EXCEPTIONS("no_heap_no_exceptions", false, true, false, true),
        NO_EXCEPTIONS("no_exceptions", false, false, false, true),
        NONE("none", true, true, true, true),
        REFLECTION("no_base_no_heap_no_cast", true, true, true, true);

        private final String name;
        private final boolean ignoreBasePtrs;
        private final boolean ignoreHeap;
        private final boolean terminateAtCast;
        private final boolean ignoreExceptions;

        private DataDependenceOptions(String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.name = string2;
            this.ignoreBasePtrs = bl;
            this.ignoreHeap = bl2;
            this.terminateAtCast = bl3;
            this.ignoreExceptions = bl4;
        }

        public final boolean isIgnoreBasePtrs() {
            return this.ignoreBasePtrs;
        }

        public final boolean isIgnoreHeap() {
            return this.ignoreHeap;
        }

        public final boolean isIgnoreExceptions() {
            return this.ignoreExceptions;
        }

        public final boolean isTerminateAtCast() {
            return this.terminateAtCast;
        }

        public final String getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SliceProblem
    implements PartiallyBalancedTabulationProblem<Statement, PDG, Object> {
        private final Collection<Statement> roots;
        private final ISupergraph<Statement, PDG> supergraph;
        private final SliceFunctions f;
        private final boolean backward;

        public SliceProblem(Collection<Statement> collection, ISDG iSDG, boolean bl) {
            this.roots = collection;
            this.backward = bl;
            SDGSupergraph sDGSupergraph = new SDGSupergraph(iSDG, bl);
            this.supergraph = bl ? BackwardsSupergraph.make(sDGSupergraph) : sDGSupergraph;
            this.f = new SliceFunctions();
        }

        @Override
        public TabulationDomain<Object, Statement> getDomain() {
            return new UnorderedDomain<Object, Statement>();
        }

        @Override
        public IPartiallyBalancedFlowFunctions<Statement> getFunctionMap() {
            return this.f;
        }

        @Override
        public IMergeFunction getMergeFunction() {
            return null;
        }

        @Override
        public ISupergraph<Statement, PDG> getSupergraph() {
            return this.supergraph;
        }

        @Override
        public Collection<PathEdge<Statement>> initialSeeds() {
            if (this.backward) {
                HashSet<PathEdge<Statement>> hashSet = HashSetFactory.make();
                for (Statement statement : this.roots) {
                    PathEdge<Statement> pathEdge = PathEdge.createPathEdge(new MethodExitStatement(statement.getNode()), 0, statement, 0);
                    hashSet.add(pathEdge);
                }
                return hashSet;
            }
            HashSet<PathEdge<Statement>> hashSet = HashSetFactory.make();
            for (Statement statement : this.roots) {
                PathEdge<Statement> pathEdge = PathEdge.createPathEdge(new MethodEntryStatement(statement.getNode()), 0, statement, 0);
                hashSet.add(pathEdge);
            }
            return hashSet;
        }

        @Override
        public Statement getFakeEntry(Statement statement) {
            return this.backward ? new MethodExitStatement(statement.getNode()) : new MethodEntryStatement(statement.getNode());
        }
    }
}

