/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;

public abstract class HeapStatement
extends Statement {
    private final PointerKey loc;

    public HeapStatement(CGNode cGNode, PointerKey pointerKey) {
        super(cGNode);
        if (pointerKey == null) {
            throw new IllegalArgumentException("loc is null");
        }
        this.loc = pointerKey;
    }

    public PointerKey getLocation() {
        return this.loc;
    }

    public static final class HeapParamCallee
    extends HeapStatement {
        public HeapParamCallee(CGNode cGNode, PointerKey pointerKey) {
            super(cGNode, pointerKey);
        }

        public Statement.Kind getKind() {
            return Statement.Kind.HEAP_PARAM_CALLEE;
        }

        public int hashCode() {
            return this.getLocation().hashCode() + 7727 * this.getNode().hashCode() + 7841;
        }

        public boolean equals(Object object) {
            if (object instanceof HeapParamCallee) {
                HeapParamCallee heapParamCallee = (HeapParamCallee)object;
                return this.getNode().equals(heapParamCallee.getNode()) && this.getLocation().equals(heapParamCallee.getLocation());
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.getKind().toString()) + ":" + this.getNode() + " " + this.getLocation();
        }
    }

    public static final class HeapParamCaller
    extends HeapStatement {
        private final int callIndex;

        public HeapParamCaller(CGNode cGNode, int n, PointerKey pointerKey) {
            super(cGNode, pointerKey);
            this.callIndex = n;
        }

        public Statement.Kind getKind() {
            return Statement.Kind.HEAP_PARAM_CALLER;
        }

        public int getCallIndex() {
            return this.callIndex;
        }

        public SSAAbstractInvokeInstruction getCall() {
            return (SSAAbstractInvokeInstruction)this.getNode().getIR().getInstructions()[this.callIndex];
        }

        public String toString() {
            return String.valueOf(this.getKind().toString()) + ":" + this.getNode() + " " + this.getLocation() + " call:" + this.getCall();
        }

        public int hashCode() {
            return this.getLocation().hashCode() + 4289 * this.callIndex + 4133 * this.getNode().hashCode() + 8831;
        }

        public boolean equals(Object object) {
            if (object instanceof HeapParamCaller) {
                HeapParamCaller heapParamCaller = (HeapParamCaller)object;
                return this.getNode().equals(heapParamCaller.getNode()) && this.getLocation().equals(heapParamCaller.getLocation()) && this.callIndex == heapParamCaller.callIndex;
            }
            return false;
        }
    }

    public static final class HeapReturnCallee
    extends HeapStatement {
        public HeapReturnCallee(CGNode cGNode, PointerKey pointerKey) {
            super(cGNode, pointerKey);
        }

        public Statement.Kind getKind() {
            return Statement.Kind.HEAP_RET_CALLEE;
        }

        public int hashCode() {
            return this.getLocation().hashCode() + 9533 * this.getNode().hashCode() + 9631;
        }

        public boolean equals(Object object) {
            if (object instanceof HeapReturnCallee) {
                HeapReturnCallee heapReturnCallee = (HeapReturnCallee)object;
                return this.getNode().equals(heapReturnCallee.getNode()) && this.getLocation().equals(heapReturnCallee.getLocation());
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.getKind().toString()) + ":" + this.getNode() + " " + this.getLocation();
        }
    }

    public static final class HeapReturnCaller
    extends HeapStatement {
        private final int callIndex;

        public HeapReturnCaller(CGNode cGNode, int n, PointerKey pointerKey) {
            super(cGNode, pointerKey);
            this.callIndex = n;
        }

        public Statement.Kind getKind() {
            return Statement.Kind.HEAP_RET_CALLER;
        }

        public int getCallIndex() {
            return this.callIndex;
        }

        public SSAAbstractInvokeInstruction getCall() {
            return (SSAAbstractInvokeInstruction)this.getNode().getIR().getInstructions()[this.callIndex];
        }

        public String toString() {
            return String.valueOf(this.getKind().toString()) + ":" + this.getNode() + " " + this.getLocation() + " call:" + this.getCall();
        }

        public int hashCode() {
            return this.getLocation().hashCode() + 8887 * this.callIndex + 8731 * this.getNode().hashCode() + 7919;
        }

        public boolean equals(Object object) {
            if (object instanceof HeapReturnCaller) {
                HeapReturnCaller heapReturnCaller = (HeapReturnCaller)object;
                return this.getNode().equals(heapReturnCaller.getNode()) && this.getLocation().equals(heapReturnCaller.getLocation()) && this.callIndex == heapReturnCaller.callIndex;
            }
            return false;
        }
    }
}

