/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.BitVectorFramework;
import com.ibm.wala.dataflow.graph.BitVectorIdentity;
import com.ibm.wala.dataflow.graph.BitVectorKillGen;
import com.ibm.wala.dataflow.graph.BitVectorMinusVector;
import com.ibm.wala.dataflow.graph.BitVectorSolver;
import com.ibm.wala.dataflow.graph.BitVectorUnion;
import com.ibm.wala.dataflow.graph.BitVectorUnionVector;
import com.ibm.wala.dataflow.graph.IKilldallFramework;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixedpoint.impl.UnaryOperator;
import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.modref.DelegatingExtendedHeapModel;
import com.ibm.wala.ipa.modref.ExtendedHeapModel;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.ipa.slicer.HeapExclusions;
import com.ibm.wala.ipa.slicer.HeapStatement;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.analysis.ExplodedControlFlowGraph;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.Iterator2Set;
import com.ibm.wala.util.collections.ObjectArrayMapping;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeapReachingDefs {
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE = false;
    private final ModRef modRef;

    public HeapReachingDefs(ModRef modRef) {
        this.modRef = modRef;
    }

    public Map<Statement, OrdinalSet<Statement>> computeReachingDefs(CGNode cGNode, IR iR, PointerAnalysis pointerAnalysis, Map<CGNode, OrdinalSet<PointerKey>> map, Collection<Statement> collection, HeapExclusions heapExclusions, CallGraph callGraph) {
        if (collection == null) {
            throw new IllegalArgumentException("statements is null");
        }
        if (pointerAnalysis == null) {
            throw new IllegalArgumentException("pa is null");
        }
        ExplodedControlFlowGraph explodedControlFlowGraph = ExplodedControlFlowGraph.make(iR);
        OrdinalSetMapping<Statement> ordinalSetMapping = HeapReachingDefs.createStatementDomain(collection);
        Map<Integer, NormalStatement> map2 = HeapReachingDefs.mapInstructionsToStatements(ordinalSetMapping);
        BitVectorFramework<IExplodedBasicBlock, Statement> bitVectorFramework = new BitVectorFramework<IExplodedBasicBlock, Statement>(explodedControlFlowGraph, new RD(cGNode, explodedControlFlowGraph, pointerAnalysis, ordinalSetMapping, map2, heapExclusions), ordinalSetMapping);
        BitVectorSolver<IExplodedBasicBlock> bitVectorSolver = new BitVectorSolver<IExplodedBasicBlock>((IKilldallFramework<IExplodedBasicBlock, BitVectorVariable>)bitVectorFramework);
        try {
            bitVectorSolver.solve(null);
        }
        catch (CancelException cancelException) {
            throw new CancelRuntimeException(cancelException);
        }
        return this.makeResult(bitVectorSolver, ordinalSetMapping, cGNode, new DelegatingExtendedHeapModel(pointerAnalysis.getHeapModel()), pointerAnalysis, map, explodedControlFlowGraph, map2, heapExclusions, callGraph);
    }

    private Map<Statement, OrdinalSet<Statement>> makeResult(BitVectorSolver<? extends ISSABasicBlock> bitVectorSolver, OrdinalSetMapping<Statement> ordinalSetMapping, CGNode cGNode, ExtendedHeapModel extendedHeapModel, PointerAnalysis pointerAnalysis, Map<CGNode, OrdinalSet<PointerKey>> map, ExplodedControlFlowGraph explodedControlFlowGraph, Map<Integer, NormalStatement> map2, HeapExclusions heapExclusions, CallGraph callGraph) {
        return new RDMap(bitVectorSolver, ordinalSetMapping, cGNode, extendedHeapModel, pointerAnalysis, map, explodedControlFlowGraph, map2, heapExclusions, callGraph);
    }

    private static boolean allCalleesMod(CallGraph callGraph, HeapStatement.HeapReturnCaller heapReturnCaller, Map<CGNode, OrdinalSet<PointerKey>> map) {
        Set<CGNode> set = callGraph.getPossibleTargets(heapReturnCaller.getNode(), heapReturnCaller.getCall().getCallSite());
        if (set.isEmpty()) {
            return false;
        }
        for (CGNode cGNode : set) {
            if (map.get(cGNode).contains(heapReturnCaller.getLocation())) continue;
            return false;
        }
        return true;
    }

    private Collection<PointerKey> getMod(Statement statement, CGNode cGNode, ExtendedHeapModel extendedHeapModel, PointerAnalysis pointerAnalysis, HeapExclusions heapExclusions) {
        switch (statement.getKind()) {
            case NORMAL: {
                NormalStatement normalStatement = (NormalStatement)statement;
                return this.modRef.getMod(cGNode, extendedHeapModel, pointerAnalysis, normalStatement.getInstruction(), heapExclusions);
            }
            case HEAP_PARAM_CALLEE: 
            case HEAP_RET_CALLER: {
                HeapStatement heapStatement = (HeapStatement)statement;
                return Collections.singleton(heapStatement.getLocation());
            }
            case PHI: 
            case PI: 
            case CATCH: 
            case PARAM_CALLER: 
            case PARAM_CALLEE: 
            case NORMAL_RET_CALLER: 
            case NORMAL_RET_CALLEE: 
            case EXC_RET_CALLER: 
            case EXC_RET_CALLEE: 
            case HEAP_PARAM_CALLER: 
            case HEAP_RET_CALLEE: 
            case METHOD_ENTRY: 
            case METHOD_EXIT: {
                return Collections.emptySet();
            }
        }
        Assertions.UNREACHABLE((Object)((Object)statement.getKind()) + " " + statement.toString());
        return null;
    }

    private static Map<Integer, NormalStatement> mapInstructionsToStatements(OrdinalSetMapping<Statement> ordinalSetMapping) {
        HashMap<Integer, NormalStatement> hashMap = HashMapFactory.make();
        for (Statement statement : ordinalSetMapping) {
            if (!statement.getKind().equals((Object)Statement.Kind.NORMAL)) continue;
            NormalStatement normalStatement = (NormalStatement)statement;
            hashMap.put(normalStatement.getInstructionIndex(), normalStatement);
        }
        return hashMap;
    }

    private static OrdinalSetMapping<Statement> createStatementDomain(Collection<Statement> collection) {
        Statement[] statementArray = new Statement[collection.size()];
        ObjectArrayMapping<Statement> objectArrayMapping = new ObjectArrayMapping<Statement>(collection.toArray(statementArray));
        return objectArrayMapping;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RD
    implements ITransferFunctionProvider<IExplodedBasicBlock, BitVectorVariable> {
        private final CGNode node;
        private final ExplodedControlFlowGraph cfg;
        private final OrdinalSetMapping<Statement> domain;
        private final PointerAnalysis pa;
        private final ExtendedHeapModel h;
        private final Map<Integer, NormalStatement> ssaInstructionIndex2Statement;
        private final HeapExclusions exclusions;
        private final IBinaryNaturalRelation heapReturnCaller = new BasicNaturalRelation();

        public RD(CGNode cGNode, ExplodedControlFlowGraph explodedControlFlowGraph, PointerAnalysis pointerAnalysis, OrdinalSetMapping<Statement> ordinalSetMapping, Map<Integer, NormalStatement> map, HeapExclusions heapExclusions) {
            this.node = cGNode;
            this.cfg = explodedControlFlowGraph;
            this.domain = ordinalSetMapping;
            this.pa = pointerAnalysis;
            this.h = new DelegatingExtendedHeapModel(pointerAnalysis.getHeapModel());
            this.ssaInstructionIndex2Statement = map;
            this.exclusions = heapExclusions;
            this.initHeapReturnCaller();
        }

        private void initHeapReturnCaller() {
            for (Statement statement : this.domain) {
                if (!statement.getKind().equals((Object)Statement.Kind.HEAP_RET_CALLER)) continue;
                HeapStatement.HeapReturnCaller heapReturnCaller = (HeapStatement.HeapReturnCaller)statement;
                NormalStatement normalStatement = this.ssaInstructionIndex2Statement.get(heapReturnCaller.getCallIndex());
                int n = this.domain.getMappedIndex(normalStatement);
                int n2 = this.domain.getMappedIndex(heapReturnCaller);
                this.heapReturnCaller.add(n, n2);
            }
        }

        @Override
        public UnaryOperator<BitVectorVariable> getEdgeTransferFunction(IExplodedBasicBlock iExplodedBasicBlock, IExplodedBasicBlock iExplodedBasicBlock2) {
            if (iExplodedBasicBlock.isEntryBlock()) {
                return new BitVectorUnionVector(new BitVectorIntSet(this.heapEntryStatements()).getBitVector());
            }
            if (iExplodedBasicBlock.getInstruction() != null && !(iExplodedBasicBlock.getInstruction() instanceof SSAAbstractInvokeInstruction) && !this.cfg.getNormalSuccessors(iExplodedBasicBlock).contains(iExplodedBasicBlock2)) {
                return BitVectorIdentity.instance();
            }
            BitVector bitVector = this.kill(iExplodedBasicBlock);
            IntSet intSet = this.gen(iExplodedBasicBlock);
            if (bitVector == null) {
                if (intSet == null) {
                    return BitVectorIdentity.instance();
                }
                return new BitVectorUnionVector(new BitVectorIntSet(intSet).getBitVector());
            }
            if (intSet == null) {
                return new BitVectorMinusVector(bitVector);
            }
            return new BitVectorKillGen(bitVector, new BitVectorIntSet(intSet).getBitVector());
        }

        @Override
        public AbstractMeetOperator<BitVectorVariable> getMeetOperator() {
            return BitVectorUnion.instance();
        }

        @Override
        public UnaryOperator<BitVectorVariable> getNodeTransferFunction(IExplodedBasicBlock iExplodedBasicBlock) {
            return null;
        }

        @Override
        public boolean hasEdgeTransferFunctions() {
            return true;
        }

        @Override
        public boolean hasNodeTransferFunctions() {
            return false;
        }

        IntSet gen(IExplodedBasicBlock iExplodedBasicBlock) {
            SSAInstruction sSAInstruction = iExplodedBasicBlock.getInstruction();
            if (sSAInstruction == null) {
                return null;
            }
            if (sSAInstruction instanceof SSAAbstractInvokeInstruction) {
                Statement statement = this.ssaInstructionIndex2Statement.get(iExplodedBasicBlock.getLastInstructionIndex());
                if (statement == null) {
                    System.err.println(this.ssaInstructionIndex2Statement);
                    Assertions.UNREACHABLE("bang " + iExplodedBasicBlock + " " + iExplodedBasicBlock.getLastInstructionIndex() + " " + sSAInstruction);
                }
                int n = this.domain.getMappedIndex(statement);
                assert (n != -1);
                return this.heapReturnCaller.getRelated(n);
            }
            Set<PointerKey> set = HeapReachingDefs.this.modRef.getMod(this.node, this.h, this.pa, sSAInstruction, this.exclusions);
            if (set.isEmpty()) {
                return null;
            }
            NormalStatement normalStatement = this.ssaInstructionIndex2Statement.get(iExplodedBasicBlock.getLastInstructionIndex());
            return SparseIntSet.singleton(this.domain.getMappedIndex(normalStatement));
        }

        private IntSet heapEntryStatements() {
            BitVectorIntSet bitVectorIntSet = new BitVectorIntSet();
            for (Statement statement : this.domain) {
                if (!statement.getKind().equals((Object)Statement.Kind.HEAP_PARAM_CALLEE)) continue;
                bitVectorIntSet.add(this.domain.getMappedIndex(statement));
            }
            return bitVectorIntSet;
        }

        BitVector kill(IExplodedBasicBlock iExplodedBasicBlock) {
            SSAInstruction sSAInstruction = iExplodedBasicBlock.getInstruction();
            if (sSAInstruction == null) {
                return null;
            }
            Set<PointerKey> set = HeapReachingDefs.this.modRef.getMod(this.node, this.h, this.pa, sSAInstruction, this.exclusions);
            if (set.isEmpty()) {
                return null;
            }
            Filter filter = new Filter(){

                public boolean accepts(Object object) {
                    return object instanceof StaticFieldKey;
                }
            };
            final Iterator2Set iterator2Set = Iterator2Collection.toSet(new FilterIterator(set.iterator(), filter));
            if (iterator2Set.isEmpty()) {
                return null;
            }
            Filter filter2 = new Filter(){

                public boolean accepts(Object object) {
                    Statement statement = (Statement)object;
                    Collection collection = HeapReachingDefs.this.getMod(statement, RD.this.node, RD.this.h, RD.this.pa, RD.this.exclusions);
                    for (PointerKey pointerKey : iterator2Set) {
                        if (!collection.contains(pointerKey)) continue;
                        return true;
                    }
                    return false;
                }
            };
            BitVector bitVector = new BitVector();
            for (Statement statement : Iterator2Iterable.make(new FilterIterator(this.domain.iterator(), filter2))) {
                bitVector.set(this.domain.getMappedIndex(statement));
            }
            return bitVector;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RDMap
    implements Map<Statement, OrdinalSet<Statement>> {
        final Map<Statement, OrdinalSet<Statement>> delegate = HashMapFactory.make();
        private final HeapExclusions exclusions;
        private final CallGraph cg;

        RDMap(BitVectorSolver<? extends ISSABasicBlock> bitVectorSolver, OrdinalSetMapping<Statement> ordinalSetMapping, CGNode cGNode, ExtendedHeapModel extendedHeapModel, PointerAnalysis pointerAnalysis, Map<CGNode, OrdinalSet<PointerKey>> map, ExplodedControlFlowGraph explodedControlFlowGraph, Map<Integer, NormalStatement> map2, HeapExclusions heapExclusions, CallGraph callGraph) {
            this.exclusions = heapExclusions;
            this.cg = callGraph;
            Map<PointerKey, MutableIntSet> map3 = this.initPointerKeyMod(ordinalSetMapping, cGNode, extendedHeapModel, pointerAnalysis);
            this.eagerPopulate(map3, bitVectorSolver, ordinalSetMapping, cGNode, extendedHeapModel, pointerAnalysis, map, explodedControlFlowGraph, map2);
        }

        private void eagerPopulate(Map<PointerKey, MutableIntSet> map, BitVectorSolver<? extends ISSABasicBlock> bitVectorSolver, OrdinalSetMapping<Statement> ordinalSetMapping, CGNode cGNode, ExtendedHeapModel extendedHeapModel, PointerAnalysis pointerAnalysis, Map<CGNode, OrdinalSet<PointerKey>> map2, ExplodedControlFlowGraph explodedControlFlowGraph, Map<Integer, NormalStatement> map3) {
            for (Statement statement : ordinalSetMapping) {
                this.delegate.put(statement, this.computeResult(statement, map, bitVectorSolver, ordinalSetMapping, cGNode, extendedHeapModel, pointerAnalysis, map2, explodedControlFlowGraph, map3));
            }
        }

        private Map<PointerKey, MutableIntSet> initPointerKeyMod(OrdinalSetMapping<Statement> ordinalSetMapping, CGNode cGNode, ExtendedHeapModel extendedHeapModel, PointerAnalysis pointerAnalysis) {
            HashMap<PointerKey, MutableIntSet> hashMap = HashMapFactory.make();
            block3: for (Statement statement : ordinalSetMapping) {
                switch (statement.getKind()) {
                    case HEAP_PARAM_CALLEE: 
                    case HEAP_RET_CALLER: {
                        Object object = (HeapStatement)statement;
                        Object object2 = this.findOrCreateIntSet(hashMap, ((HeapStatement)object).getLocation());
                        object2.add(ordinalSetMapping.getMappedIndex(statement));
                        break;
                    }
                    default: {
                        Object object2;
                        Object object = HeapReachingDefs.this.getMod(statement, cGNode, extendedHeapModel, pointerAnalysis, this.exclusions);
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            object2 = (PointerKey)iterator.next();
                            MutableIntSet mutableIntSet = this.findOrCreateIntSet(hashMap, (PointerKey)object2);
                            mutableIntSet.add(ordinalSetMapping.getMappedIndex(statement));
                        }
                        continue block3;
                    }
                }
            }
            return hashMap;
        }

        private MutableIntSet findOrCreateIntSet(Map<PointerKey, MutableIntSet> map, PointerKey pointerKey) {
            MutableIntSet mutableIntSet = map.get(pointerKey);
            if (mutableIntSet == null) {
                mutableIntSet = MutableSparseIntSet.makeEmpty();
                map.put(pointerKey, mutableIntSet);
            }
            return mutableIntSet;
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public void clear() {
            Assertions.UNREACHABLE();
            this.delegate.clear();
        }

        @Override
        public boolean containsKey(Object object) {
            Assertions.UNREACHABLE();
            return this.delegate.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            Assertions.UNREACHABLE();
            return this.delegate.containsValue(object);
        }

        @Override
        public Set<Map.Entry<Statement, OrdinalSet<Statement>>> entrySet() {
            Assertions.UNREACHABLE();
            return this.delegate.entrySet();
        }

        @Override
        public boolean equals(Object object) {
            Assertions.UNREACHABLE();
            return this.delegate.equals(object);
        }

        @Override
        public OrdinalSet<Statement> get(Object object) {
            return this.delegate.get(object);
        }

        @Override
        public int hashCode() {
            Assertions.UNREACHABLE();
            return this.delegate.hashCode();
        }

        @Override
        public boolean isEmpty() {
            Assertions.UNREACHABLE();
            return this.delegate.isEmpty();
        }

        @Override
        public Set<Statement> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public OrdinalSet<Statement> put(Statement statement, OrdinalSet<Statement> ordinalSet) {
            Assertions.UNREACHABLE();
            return this.delegate.put(statement, ordinalSet);
        }

        @Override
        public void putAll(Map<? extends Statement, ? extends OrdinalSet<Statement>> map) {
            Assertions.UNREACHABLE();
            this.delegate.putAll(map);
        }

        @Override
        public OrdinalSet<Statement> remove(Object object) {
            Assertions.UNREACHABLE();
            return this.delegate.remove(object);
        }

        @Override
        public int size() {
            Assertions.UNREACHABLE();
            return this.delegate.size();
        }

        @Override
        public Collection<OrdinalSet<Statement>> values() {
            Assertions.UNREACHABLE();
            return this.delegate.values();
        }

        OrdinalSet<Statement> computeResult(Statement statement, Map<PointerKey, MutableIntSet> map, BitVectorSolver<? extends ISSABasicBlock> bitVectorSolver, OrdinalSetMapping<Statement> ordinalSetMapping, CGNode cGNode, ExtendedHeapModel extendedHeapModel, PointerAnalysis pointerAnalysis, Map<CGNode, OrdinalSet<PointerKey>> map2, ExplodedControlFlowGraph explodedControlFlowGraph, Map<Integer, NormalStatement> map3) {
            switch (statement.getKind()) {
                case NORMAL: {
                    NormalStatement normalStatement = (NormalStatement)statement;
                    Set<PointerKey> set = HeapReachingDefs.this.modRef.getRef(cGNode, extendedHeapModel, pointerAnalysis, normalStatement.getInstruction(), this.exclusions);
                    if (!set.isEmpty()) {
                        IExplodedBasicBlock iExplodedBasicBlock = explodedControlFlowGraph.getBlockForInstruction(normalStatement.getInstructionIndex());
                        BitVectorVariable bitVectorVariable = (BitVectorVariable)bitVectorSolver.getIn(iExplodedBasicBlock);
                        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
                        if (bitVectorVariable.getValue() != null) {
                            for (PointerKey pointerKey : set) {
                                if (map.get(pointerKey) == null) continue;
                                mutableSparseIntSet.addAll(map.get(pointerKey).intersection(bitVectorVariable.getValue()));
                            }
                        }
                        return new OrdinalSet<Statement>(mutableSparseIntSet, ordinalSetMapping);
                    }
                    return OrdinalSet.empty();
                }
                case HEAP_RET_CALLEE: {
                    HeapStatement.HeapReturnCallee heapReturnCallee = (HeapStatement.HeapReturnCallee)statement;
                    PointerKey pointerKey = heapReturnCallee.getLocation();
                    BitVectorVariable bitVectorVariable = (BitVectorVariable)bitVectorSolver.getIn(explodedControlFlowGraph.exit());
                    if (map.get(pointerKey) == null) {
                        return OrdinalSet.empty();
                    }
                    return new OrdinalSet<Statement>(map.get(pointerKey).intersection(bitVectorVariable.getValue()), ordinalSetMapping);
                }
                case HEAP_RET_CALLER: {
                    HeapStatement.HeapReturnCaller heapReturnCaller = (HeapStatement.HeapReturnCaller)statement;
                    IExplodedBasicBlock iExplodedBasicBlock = explodedControlFlowGraph.getBlockForInstruction(heapReturnCaller.getCallIndex());
                    BitVectorVariable bitVectorVariable = (BitVectorVariable)bitVectorSolver.getIn(iExplodedBasicBlock);
                    if (HeapReachingDefs.allCalleesMod(this.cg, heapReturnCaller, map2) || map.get(heapReturnCaller.getLocation()) == null || bitVectorVariable.getValue() == null) {
                        return OrdinalSet.empty();
                    }
                    return new OrdinalSet<Statement>(map.get(heapReturnCaller.getLocation()).intersection(bitVectorVariable.getValue()), ordinalSetMapping);
                }
                case HEAP_PARAM_CALLER: {
                    HeapStatement.HeapParamCaller heapParamCaller = (HeapStatement.HeapParamCaller)statement;
                    NormalStatement normalStatement = map3.get(heapParamCaller.getCallIndex());
                    IExplodedBasicBlock iExplodedBasicBlock = explodedControlFlowGraph.getBlockForInstruction(normalStatement.getInstructionIndex());
                    if (iExplodedBasicBlock.isEntryBlock()) {
                        int n = ordinalSetMapping.getMappedIndex(new HeapStatement.HeapParamCallee(cGNode, heapParamCaller.getLocation()));
                        assert (n >= 0);
                        SparseIntSet sparseIntSet = SparseIntSet.singleton(n);
                        return new OrdinalSet<Statement>(sparseIntSet, ordinalSetMapping);
                    }
                    BitVectorVariable bitVectorVariable = (BitVectorVariable)bitVectorSolver.getIn(iExplodedBasicBlock);
                    if (map.get(heapParamCaller.getLocation()) == null || bitVectorVariable.getValue() == null) {
                        return OrdinalSet.empty();
                    }
                    return new OrdinalSet<Statement>(map.get(heapParamCaller.getLocation()).intersection(bitVectorVariable.getValue()), ordinalSetMapping);
                }
                case PHI: 
                case PI: 
                case CATCH: 
                case PARAM_CALLER: 
                case PARAM_CALLEE: 
                case NORMAL_RET_CALLER: 
                case NORMAL_RET_CALLEE: 
                case EXC_RET_CALLER: 
                case EXC_RET_CALLEE: 
                case METHOD_ENTRY: 
                case METHOD_EXIT: {
                    return OrdinalSet.empty();
                }
                case HEAP_PARAM_CALLEE: {
                    return OrdinalSet.empty();
                }
            }
            Assertions.UNREACHABLE(statement.getKind().toString());
            return null;
        }
    }
}

