/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.rta;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AbstractPointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.ArrayContentsKey;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKeyWithFilter;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.rta.TypeBasedHeapModel;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BimodalMutableIntSet;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeBasedPointerAnalysis
extends AbstractPointerAnalysis {
    private final Collection<IClass> klasses;
    private final TypeBasedHeapModel heapModel;
    private final Map<IClass, OrdinalSet<InstanceKey>> pointsTo = HashMapFactory.make();

    private TypeBasedPointerAnalysis(AnalysisOptions analysisOptions, Collection<IClass> collection, CallGraph callGraph) throws AssertionError {
        super(callGraph, TypeBasedPointerAnalysis.makeInstanceKeys(collection));
        this.klasses = collection;
        this.heapModel = new TypeBasedHeapModel(analysisOptions, collection, callGraph);
    }

    private static MutableMapping<InstanceKey> makeInstanceKeys(Collection<IClass> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("null c");
        }
        MutableMapping<InstanceKey> mutableMapping = MutableMapping.make();
        for (IClass iClass : collection) {
            if (iClass.isAbstract() || iClass.isInterface()) continue;
            mutableMapping.add(new ConcreteTypeKey(iClass));
        }
        return mutableMapping;
    }

    public static TypeBasedPointerAnalysis make(AnalysisOptions analysisOptions, Collection<IClass> collection, CallGraph callGraph) throws AssertionError {
        return new TypeBasedPointerAnalysis(analysisOptions, collection, callGraph);
    }

    @Override
    public OrdinalSet<InstanceKey> getPointsToSet(PointerKey pointerKey) throws IllegalArgumentException {
        if (pointerKey == null) {
            throw new IllegalArgumentException("key == null");
        }
        IClass iClass = this.inferType(pointerKey);
        if (iClass == null) {
            return OrdinalSet.empty();
        }
        OrdinalSet<InstanceKey> ordinalSet = this.pointsTo.get(iClass);
        if (ordinalSet == null) {
            ordinalSet = this.computeOrdinalInstanceSet(iClass);
            this.pointsTo.put(iClass, ordinalSet);
        }
        return ordinalSet;
    }

    private OrdinalSet<InstanceKey> computeOrdinalInstanceSet(IClass iClass) {
        Collection<IClass> collection;
        Set<IClass> set = null;
        if (iClass.isInterface()) {
            set = this.getCallGraph().getClassHierarchy().getImplementors(iClass.getReference());
        } else {
            collection = this.getCallGraph().getClassHierarchy().computeSubClasses(iClass.getReference());
            set = HashSetFactory.make();
            for (IClass object2 : collection) {
                if (object2.isInterface()) continue;
                set.add(object2);
            }
        }
        collection = HashSetFactory.make();
        for (IClass iClass2 : set) {
            if (iClass2.isArrayClass()) {
                TypeReference typeReference = iClass2.getReference().getArrayElementType();
                if (typeReference.isPrimitiveType()) {
                    collection.add(iClass2);
                    continue;
                }
                collection.add(iClass2.getClassHierarchy().lookupClass(TypeReference.JavaLangObject.getArrayTypeForElementType()));
                continue;
            }
            if (!this.klasses.contains(iClass2)) continue;
            collection.add(iClass2);
        }
        OrdinalSet<InstanceKey> ordinalSet = this.toOrdinalInstanceKeySet(collection);
        return ordinalSet;
    }

    private OrdinalSet<InstanceKey> toOrdinalInstanceKeySet(Collection collection) {
        BimodalMutableIntSet bimodalMutableIntSet = new BimodalMutableIntSet();
        for (IClass iClass : collection) {
            int n = this.getInstanceKeyMapping().add(new ConcreteTypeKey(iClass));
            bimodalMutableIntSet.add(n);
        }
        return new OrdinalSet<InstanceKey>(bimodalMutableIntSet, this.getInstanceKeyMapping());
    }

    private IClass inferType(PointerKey pointerKey) {
        if (pointerKey instanceof LocalPointerKeyWithFilter) {
            LocalPointerKeyWithFilter localPointerKeyWithFilter = (LocalPointerKeyWithFilter)pointerKey;
            FilteredPointerKey.TypeFilter typeFilter = localPointerKeyWithFilter.getTypeFilter();
            assert (typeFilter instanceof FilteredPointerKey.SingleClassFilter);
            return ((FilteredPointerKey.SingleClassFilter)typeFilter).getConcreteType();
        }
        if (pointerKey instanceof StaticFieldKey) {
            StaticFieldKey staticFieldKey = (StaticFieldKey)pointerKey;
            return this.getCallGraph().getClassHierarchy().lookupClass(staticFieldKey.getField().getFieldTypeReference());
        }
        if (pointerKey instanceof InstanceFieldKey) {
            InstanceFieldKey instanceFieldKey = (InstanceFieldKey)pointerKey;
            return this.getCallGraph().getClassHierarchy().lookupClass(instanceFieldKey.getField().getFieldTypeReference());
        }
        if (pointerKey instanceof ArrayContentsKey) {
            ArrayContentsKey arrayContentsKey = (ArrayContentsKey)pointerKey;
            FilteredPointerKey.TypeFilter typeFilter = arrayContentsKey.getTypeFilter();
            assert (typeFilter instanceof FilteredPointerKey.SingleClassFilter);
            return ((FilteredPointerKey.SingleClassFilter)typeFilter).getConcreteType();
        }
        Assertions.UNREACHABLE("inferType " + pointerKey.getClass());
        return null;
    }

    @Override
    public HeapModel getHeapModel() {
        return this.heapModel;
    }

    @Override
    public Collection<PointerKey> getPointerKeys() {
        return Iterator2Collection.toSet(this.heapModel.iteratePointerKeys());
    }

    @Override
    public boolean isFiltered(PointerKey pointerKey) {
        return false;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.heapModel.getClassHierarchy();
    }
}

