/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.rta;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.CodeScanner;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.rta.RTAContextInterpreter;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContextInsensitiveRTAInterpreter
implements RTAContextInterpreter,
SSAContextInterpreter {
    private final AnalysisCache analysisCache;

    public ContextInsensitiveRTAInterpreter(AnalysisCache analysisCache) {
        this.analysisCache = analysisCache;
    }

    public AnalysisCache getAnalysisCache() {
        return this.analysisCache;
    }

    @Override
    public Iterator<NewSiteReference> iterateNewSites(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        try {
            return CodeScanner.getNewSites(cGNode.getMethod()).iterator();
        }
        catch (InvalidClassFileException invalidClassFileException) {
            invalidClassFileException.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public Iterator<CallSiteReference> iterateCallSites(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        try {
            return CodeScanner.getCallSites(cGNode.getMethod()).iterator();
        }
        catch (InvalidClassFileException invalidClassFileException) {
            invalidClassFileException.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public Iterator<FieldReference> iterateFieldsRead(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        try {
            return CodeScanner.getFieldsRead(cGNode.getMethod()).iterator();
        }
        catch (InvalidClassFileException invalidClassFileException) {
            invalidClassFileException.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public Iterator<FieldReference> iterateFieldsWritten(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        try {
            return CodeScanner.getFieldsWritten(cGNode.getMethod()).iterator();
        }
        catch (InvalidClassFileException invalidClassFileException) {
            invalidClassFileException.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public boolean understands(CGNode cGNode) {
        return true;
    }

    @Override
    public boolean recordFactoryType(CGNode cGNode, IClass iClass) {
        return false;
    }
}

