/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.cfa;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSiteInNodeFactory;
import com.ibm.wala.ipa.callgraph.propagation.ClassBasedInstanceKeys;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.SmushedAllocationSiteInstanceKeys;
import com.ibm.wala.ipa.callgraph.propagation.rta.RTAContextInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZeroXInstanceKeys
implements InstanceKeyFactory {
    private static final TypeName JavaLangStringBufferName = TypeName.string2TypeName("Ljava/lang/StringBuffer");
    public static final TypeReference JavaLangStringBuffer = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangStringBufferName);
    private static final TypeName JavaLangStringBuilderName = TypeName.string2TypeName("Ljava/lang/StringBuilder");
    public static final TypeReference JavaLangStringBuilder = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangStringBuilderName);
    private static final TypeName JavaLangAbstractStringBuilderName = TypeName.string2TypeName("Ljava/lang/AbstractStringBuilder");
    public static final TypeReference JavaLangAbstractStringBuilder = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangAbstractStringBuilderName);
    public static final int NONE = 0;
    public static final int ALLOCATIONS = 1;
    public static final int SMUSH_STRINGS = 2;
    public static final int SMUSH_THROWABLES = 4;
    public static final int SMUSH_PRIMITIVE_HOLDERS = 8;
    public static final int SMUSH_MANY = 16;
    public static final int CONSTANT_SPECIFIC = 32;
    private final int SMUSH_LIMIT = 25;
    private final int policy;
    private final ClassBasedInstanceKeys classBased;
    private final AllocationSiteInNodeFactory siteBased;
    private final SmushedAllocationSiteInstanceKeys smushed;
    private final IClassHierarchy cha;
    private final RTAContextInterpreter contextInterpreter;
    protected final Map<CGNode, Set<IClass>> smushMap = HashMapFactory.make();

    public ZeroXInstanceKeys(AnalysisOptions analysisOptions, IClassHierarchy iClassHierarchy, RTAContextInterpreter rTAContextInterpreter, int n) {
        if (analysisOptions == null) {
            throw new IllegalArgumentException("null options");
        }
        this.policy = n;
        if (this.disambiguateConstants()) {
            analysisOptions.setUseConstantSpecificKeys(true);
        }
        this.classBased = new ClassBasedInstanceKeys(analysisOptions, iClassHierarchy);
        this.siteBased = new AllocationSiteInNodeFactory(analysisOptions, iClassHierarchy);
        this.smushed = new SmushedAllocationSiteInstanceKeys(analysisOptions, iClassHierarchy);
        this.cha = iClassHierarchy;
        this.contextInterpreter = rTAContextInterpreter;
    }

    private boolean smushMany() {
        return (this.policy & 0x10) > 0;
    }

    private boolean allocationPolicy() {
        return (this.policy & 1) > 0;
    }

    private boolean smushStrings() {
        return (this.policy & 2) > 0;
    }

    public boolean smushThrowables() {
        return (this.policy & 4) > 0;
    }

    private boolean smushPrimHolders() {
        return (this.policy & 8) > 0;
    }

    public boolean disambiguateConstants() {
        return (this.policy & 0x20) > 0;
    }

    @Override
    public InstanceKey getInstanceKeyForAllocation(CGNode cGNode, NewSiteReference newSiteReference) {
        if (newSiteReference == null) {
            throw new IllegalArgumentException("allocation is null");
        }
        TypeReference typeReference = newSiteReference.getDeclaredType();
        IClass iClass = this.cha.lookupClass(typeReference);
        if (iClass != null && this.isInteresting(iClass)) {
            if (this.smushMany()) {
                if (this.exceedsSmushLimit(iClass, cGNode)) {
                    return this.smushed.getInstanceKeyForAllocation(cGNode, newSiteReference);
                }
                return this.siteBased.getInstanceKeyForAllocation(cGNode, newSiteReference);
            }
            return this.siteBased.getInstanceKeyForAllocation(cGNode, newSiteReference);
        }
        return this.classBased.getInstanceKeyForAllocation(cGNode, newSiteReference);
    }

    private boolean exceedsSmushLimit(IClass iClass, CGNode cGNode) {
        Set<IClass> set = this.smushMap.get(cGNode);
        if (set == null) {
            Map<IClass, Integer> map = this.countAllocsByType(cGNode);
            HashSet hashSet = HashSetFactory.make(5);
            for (Map.Entry<IClass, Integer> entry : map.entrySet()) {
                Integer n = entry.getValue();
                if (n <= 25) continue;
                hashSet.add(entry.getKey());
            }
            set = hashSet.isEmpty() ? Collections.emptySet() : hashSet;
            this.smushMap.put(cGNode, set);
        }
        return set.contains(iClass);
    }

    private Map<IClass, Integer> countAllocsByType(CGNode cGNode) {
        HashMap<IClass, Integer> hashMap = HashMapFactory.make();
        Iterator<NewSiteReference> iterator = this.contextInterpreter.iterateNewSites(cGNode);
        while (iterator.hasNext()) {
            NewSiteReference newSiteReference = iterator.next();
            IClass iClass = this.cha.lookupClass(newSiteReference.getDeclaredType());
            if (iClass == null) continue;
            Integer n = (Integer)hashMap.get(iClass);
            if (n == null) {
                hashMap.put(iClass, new Integer(1));
                continue;
            }
            hashMap.put(iClass, new Integer(n + 1));
        }
        return hashMap;
    }

    @Override
    public InstanceKey getInstanceKeyForMultiNewArray(CGNode cGNode, NewSiteReference newSiteReference, int n) {
        if (this.allocationPolicy()) {
            return this.siteBased.getInstanceKeyForMultiNewArray(cGNode, newSiteReference, n);
        }
        return this.classBased.getInstanceKeyForMultiNewArray(cGNode, newSiteReference, n);
    }

    @Override
    public <T> InstanceKey getInstanceKeyForConstant(TypeReference typeReference, T t) {
        if (typeReference == null) {
            throw new IllegalArgumentException("null type");
        }
        if (this.disambiguateConstants() || this.isReflectiveType(typeReference)) {
            return new ConstantKey<T>(t, this.getClassHierarchy().lookupClass(typeReference));
        }
        return this.classBased.getInstanceKeyForConstant(typeReference, t);
    }

    private boolean isReflectiveType(TypeReference typeReference) {
        return typeReference.equals(TypeReference.JavaLangReflectConstructor) || typeReference.equals(TypeReference.JavaLangReflectMethod);
    }

    @Override
    public InstanceKey getInstanceKeyForPEI(CGNode cGNode, ProgramCounter programCounter, TypeReference typeReference) {
        return this.classBased.getInstanceKeyForPEI(cGNode, programCounter, typeReference);
    }

    @Override
    public InstanceKey getInstanceKeyForClassObject(TypeReference typeReference) {
        return this.classBased.getInstanceKeyForClassObject(typeReference);
    }

    public boolean isInteresting(IClass iClass) {
        if (!this.allocationPolicy()) {
            return false;
        }
        if (this.smushStrings() && ZeroXInstanceKeys.isStringish(iClass)) {
            return false;
        }
        if (this.smushThrowables() && (ZeroXInstanceKeys.isThrowable(iClass) || this.isStackTraceElement(iClass))) {
            return false;
        }
        return !this.smushPrimHolders() || !this.allFieldsArePrimitive(iClass);
    }

    public static boolean isStringish(IClass iClass) {
        if (iClass == null) {
            throw new IllegalArgumentException("C is null");
        }
        return iClass.getReference().equals(TypeReference.JavaLangString) || iClass.getReference().equals(JavaLangStringBuffer) || iClass.getReference().equals(JavaLangStringBuilder) || iClass.getReference().equals(JavaLangAbstractStringBuilder);
    }

    public static boolean isThrowable(IClass iClass) {
        if (iClass == null) {
            throw new IllegalArgumentException("null c");
        }
        return iClass.getClassHierarchy().isSubclassOf(iClass, iClass.getClassHierarchy().lookupClass(TypeReference.JavaLangThrowable));
    }

    public boolean isStackTraceElement(IClass iClass) {
        if (iClass == null) {
            throw new IllegalArgumentException("C is null");
        }
        return iClass.getReference().equals(TypeReference.JavaLangStackTraceElement);
    }

    private boolean allFieldsArePrimitive(IClass iClass) {
        if (iClass.isArrayClass()) {
            TypeReference typeReference = iClass.getReference().getArrayElementType();
            return typeReference.isPrimitiveType();
        }
        if (iClass.getReference().equals(TypeReference.JavaLangObject)) {
            return true;
        }
        for (IField iField : iClass.getDeclaredInstanceFields()) {
            if (!iField.getReference().getFieldType().isReferenceType()) continue;
            return false;
        }
        return this.allFieldsArePrimitive(iClass.getSuperclass());
    }

    protected IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    public ClassBasedInstanceKeys getClassBasedInstanceKeys() {
        return this.classBased;
    }
}

