/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.cfa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSiteInNode;
import com.ibm.wala.ipa.callgraph.propagation.ContainerUtil;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.ReceiverInstanceContext;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerContext;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerSiteContext;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ZeroXInstanceKeys;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;

public class ContainerContextSelector
implements ContextSelector {
    private static final boolean DEBUG = false;
    private static final TypeName SyntheticSystemName = TypeName.string2TypeName("Lcom/ibm/wala/model/java/lang/System");
    public static final TypeReference SyntheticSystem = TypeReference.findOrCreate(ClassLoaderReference.Primordial, SyntheticSystemName);
    public static final TypeReference JavaUtilHashtable = TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/util/Hashtable");
    public static final Atom arraycopyAtom = Atom.findOrCreateUnicodeAtom("arraycopy");
    private static final Descriptor arraycopyDesc = Descriptor.findOrCreateUTF8("(Ljava/lang/Object;Ljava/lang/Object;)V");
    public static final MethodReference synthArraycopy = MethodReference.findOrCreate(SyntheticSystem, arraycopyAtom, arraycopyDesc);
    private static final TypeReference Arrays = TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/util/Arrays");
    private static final Atom asList = Atom.findOrCreateUnicodeAtom("asList");
    private static final Atom copyOf = Atom.findOrCreateUnicodeAtom("copyOf");
    private static final Atom copyOfRange = Atom.findOrCreateUnicodeAtom("copyOfRange");
    private static final Atom toString = Atom.findOrCreateUnicodeAtom("toString");
    private static final MethodReference StringValueOf = MethodReference.findOrCreate(TypeReference.JavaLangString, "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;");
    private static final MethodReference HashtableNewEntry = MethodReference.findOrCreate(JavaUtilHashtable, "newEntry", "(Ljava/lang/Object;Ljava/lang/Object;I)Ljava/util/Hashtable$Entry;");
    private final IClassHierarchy cha;
    private final ZeroXInstanceKeys delegate;

    public ContainerContextSelector(IClassHierarchy iClassHierarchy, ZeroXInstanceKeys zeroXInstanceKeys) {
        this.cha = iClassHierarchy;
        this.delegate = zeroXInstanceKeys;
        if (zeroXInstanceKeys == null) {
            throw new IllegalArgumentException("null delegate");
        }
    }

    public Context getCalleeTarget(CGNode cGNode, CallSiteReference callSiteReference, IMethod iMethod, InstanceKey instanceKey) {
        if (this.mayUnderstand(cGNode, callSiteReference, iMethod, instanceKey)) {
            if (ContainerContextSelector.isWellKnownStaticFactory(iMethod.getReference())) {
                return new CallerSiteContext(cGNode, callSiteReference);
            }
            if (instanceKey == null) {
                Assertions.UNREACHABLE("null receiver for " + callSiteReference);
            }
            return new ReceiverInstanceContext(instanceKey);
        }
        return null;
    }

    public static boolean isWellKnownStaticFactory(MethodReference methodReference) {
        if (ContainerContextSelector.isArrayCopyingMethod(methodReference)) {
            return true;
        }
        if (ContainerContextSelector.isArrayToStringMethod(methodReference)) {
            return true;
        }
        if (methodReference.equals(StringValueOf)) {
            return true;
        }
        return methodReference.equals(HashtableNewEntry);
    }

    public static boolean isArrayCopyingMethod(MethodReference methodReference) {
        if (methodReference == null) {
            throw new IllegalArgumentException("null m");
        }
        if (methodReference.getDeclaringClass().equals(TypeReference.JavaLangSystem) && methodReference.getName().toString().equals("arraycopy")) {
            return true;
        }
        if (methodReference.equals(synthArraycopy)) {
            return true;
        }
        return ContainerContextSelector.isArrayCopyMethod(methodReference);
    }

    private static boolean isArrayCopyMethod(MethodReference methodReference) {
        return methodReference.getDeclaringClass().equals(Arrays) && (methodReference.getName().equals(asList) || methodReference.getName().equals(copyOf) || methodReference.getName().equals(copyOfRange));
    }

    private static boolean isArrayToStringMethod(MethodReference methodReference) {
        return methodReference.getDeclaringClass().equals(Arrays) && methodReference.getName().equals(toString);
    }

    public static Context findRecursiveMatchingContext(IMethod iMethod, Context context, InstanceKey instanceKey) {
        Context context2 = ContainerContextSelector.findRecursiveMatchingContext(iMethod, context);
        if (context2 != null) {
            return context2;
        }
        if (instanceKey instanceof AllocationSiteInNode) {
            AllocationSiteInNode allocationSiteInNode = (AllocationSiteInNode)instanceKey;
            IMethod iMethod2 = allocationSiteInNode.getNode().getMethod();
            return ContainerContextSelector.findRecursiveMatchingContext(iMethod2, context);
        }
        return null;
    }

    public static CGNode findNodeRecursiveMatchingContext(IMethod iMethod, Context context) {
        if (context instanceof ReceiverInstanceContext) {
            ReceiverInstanceContext receiverInstanceContext = (ReceiverInstanceContext)context;
            if (!(receiverInstanceContext.getReceiver() instanceof AllocationSiteInNode)) {
                return null;
            }
            AllocationSiteInNode allocationSiteInNode = (AllocationSiteInNode)receiverInstanceContext.getReceiver();
            CGNode cGNode = allocationSiteInNode.getNode();
            if (cGNode.getMethod().equals(iMethod)) {
                return cGNode;
            }
            return ContainerContextSelector.findNodeRecursiveMatchingContext(iMethod, cGNode.getContext());
        }
        if (context instanceof CallerContext) {
            CallerContext callerContext = (CallerContext)context;
            CGNode cGNode = callerContext.getCaller();
            if (cGNode.getMethod().equals(iMethod)) {
                return cGNode;
            }
            return ContainerContextSelector.findNodeRecursiveMatchingContext(iMethod, cGNode.getContext());
        }
        return null;
    }

    public static Context findRecursiveMatchingContext(IMethod iMethod, Context context) {
        CGNode cGNode = ContainerContextSelector.findNodeRecursiveMatchingContext(iMethod, context);
        return cGNode == null ? null : cGNode.getContext();
    }

    public int getBoundOnNumberOfTargets(CGNode cGNode, CallSiteReference callSiteReference, IMethod iMethod) {
        return -1;
    }

    public boolean mayUnderstand(CGNode cGNode, CallSiteReference callSiteReference, IMethod iMethod, InstanceKey instanceKey) {
        AllocationSiteInNode allocationSiteInNode;
        CGNode cGNode2;
        if (iMethod == null) {
            throw new IllegalArgumentException("targetMethod is null");
        }
        if (ContainerContextSelector.isWellKnownStaticFactory(iMethod.getReference())) {
            return true;
        }
        if (callSiteReference.isStatic()) {
            return false;
        }
        if (iMethod.getDeclaringClass().getReference().equals(TypeReference.JavaLangObject)) {
            return false;
        }
        if (this.isContainer(iMethod.getDeclaringClass())) {
            return true;
        }
        if (instanceKey == null) {
            IClass iClass = iMethod.getDeclaringClass();
            int n = this.cha.getNumberOfImmediateSubclasses(iClass);
            if (n > 0) {
                return true;
            }
            return this.delegate.isInteresting(iClass);
        }
        if (!this.delegate.isInteresting(instanceKey.getConcreteType())) {
            return false;
        }
        return instanceKey instanceof AllocationSiteInNode && (cGNode2 = (allocationSiteInNode = (AllocationSiteInNode)instanceKey).getNode()).getContext() instanceof ReceiverInstanceContext;
    }

    protected boolean isContainer(IClass iClass) {
        return ContainerUtil.isContainer(iClass);
    }

    public boolean contextIsIrrelevant(CGNode cGNode, CallSiteReference callSiteReference) {
        return false;
    }

    protected IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    public boolean allSitesDispatchIdentically(CGNode cGNode, CallSiteReference callSiteReference) {
        return false;
    }
}

