/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.cfa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.ContextItem;

public class CallString
implements ContextItem {
    private final CallSiteReference[] sites;
    private final IMethod[] methods;

    public CallString(CallSiteReference callSiteReference, IMethod iMethod) {
        if (callSiteReference == null) {
            throw new IllegalArgumentException("null site");
        }
        this.sites = new CallSiteReference[]{callSiteReference};
        this.methods = new IMethod[]{iMethod};
    }

    CallString(CallSiteReference callSiteReference, IMethod iMethod, int n, CallString callString) {
        int n2 = Math.min(n, callString.sites.length + 1);
        int n3 = Math.min(n, callString.methods.length + 1);
        this.sites = new CallSiteReference[n2];
        this.sites[0] = callSiteReference;
        System.arraycopy(callString.sites, 0, this.sites, 1, Math.min(n - 1, callString.sites.length));
        this.methods = new IMethod[n3];
        this.methods[0] = iMethod;
        System.arraycopy(callString.methods, 0, this.methods, 1, Math.min(n - 1, callString.methods.length));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        int n = 0;
        while (n < this.sites.length) {
            stringBuffer.append(" ").append(this.methods[n].getName()).append("@").append(this.sites[n].getProgramCounter());
            ++n;
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 1;
        int n2 = 0;
        while (n2 < this.sites.length) {
            n *= this.sites[n2].hashCode() * this.methods[n2].hashCode();
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof CallString) {
            CallString callString = (CallString)object;
            if (callString.sites.length == this.sites.length) {
                int n = 0;
                while (n < this.sites.length) {
                    if (!this.sites[n].equals(callString.sites[n]) || !this.methods[n].equals(callString.methods[n])) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
        }
        return false;
    }

    public CallSiteReference[] getCallSiteRefs() {
        return this.sites;
    }

    public IMethod[] getMethods() {
        return this.methods;
    }
}

