/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.analysis.reflection.CloneInterpreter;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.Util;
import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.fixedpoint.impl.UnaryOperator;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.impl.FakeRootMethod;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.IPointerOperator;
import com.ibm.wala.ipa.callgraph.propagation.IPointsToSolver;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.PropagationSystem;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.StandardSolver;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.cha.IClassHierarchyDweller;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.ref.ReferenceCleanser;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SSAPropagationCallGraphBuilder
extends PropagationCallGraphBuilder
implements HeapModel {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_MULTINEWARRAY = false;
    public static final boolean PERIODIC_WIPE_SOFT_CACHES = true;
    public static final int WIPE_SOFT_CACHE_INTERVAL = 2500;
    private static int wipeCount = 0;
    private static final boolean SHORT_CIRCUIT_INVARIANT_SETS = true;
    protected static final boolean SHORT_CIRCUIT_SINGLE_USES = true;
    private final boolean clone2Assign = false;
    private static final Selector cloneSelector = CloneInterpreter.CLONE.getSelector();
    private final Set<IClass> clinitVisited = HashSetFactory.make();

    protected SSAPropagationCallGraphBuilder(IClassHierarchy iClassHierarchy, AnalysisOptions analysisOptions, AnalysisCache analysisCache, PointerKeyFactory pointerKeyFactory) {
        super(iClassHierarchy, analysisOptions, analysisCache, pointerKeyFactory);
    }

    public SSAContextInterpreter getCFAContextInterpreter() {
        return (SSAContextInterpreter)this.getContextInterpreter();
    }

    public static InstanceKey getInstanceKeyForPEI(CGNode cGNode, ProgramCounter programCounter, TypeReference typeReference, InstanceKeyFactory instanceKeyFactory) {
        if (instanceKeyFactory == null) {
            throw new IllegalArgumentException("ikFactory is null");
        }
        return instanceKeyFactory.getInstanceKeyForPEI(cGNode, programCounter, typeReference);
    }

    @Override
    protected boolean addConstraintsFromNode(CGNode cGNode) {
        if (this.haveAlreadyVisited(cGNode)) {
            return false;
        }
        this.markAlreadyVisited(cGNode);
        return this.unconditionallyAddConstraintsFromNode(cGNode);
    }

    @Override
    protected boolean unconditionallyAddConstraintsFromNode(CGNode cGNode) {
        IR iR;
        if (++wipeCount >= 2500) {
            wipeCount = 0;
            ReferenceCleanser.clearSoftCaches();
        }
        if ((iR = this.getCFAContextInterpreter().getIR(cGNode)) == null) {
            return false;
        }
        this.addNodeInstructionConstraints(cGNode);
        DefUse defUse = this.getCFAContextInterpreter().getDU(cGNode);
        this.addNodePassthruExceptionConstraints(cGNode, iR, defUse);
        return true;
    }

    protected ConstraintVisitor makeVisitor(ExplicitCallGraph.ExplicitNode explicitNode) {
        return new ConstraintVisitor(this, explicitNode);
    }

    protected void addNodeInstructionConstraints(CGNode cGNode) {
        ConstraintVisitor constraintVisitor = this.makeVisitor((ExplicitCallGraph.ExplicitNode)cGNode);
        IR iR = this.getCFAContextInterpreter().getIR(cGNode);
        SSACFG sSACFG = iR.getControlFlowGraph();
        for (SSACFG.BasicBlock basicBlock : sSACFG) {
            this.addBlockInstructionConstraints(cGNode, sSACFG, basicBlock, constraintVisitor);
            if (!this.wasChanged(cGNode)) continue;
            return;
        }
    }

    protected void addBlockInstructionConstraints(CGNode cGNode, ControlFlowGraph<SSAInstruction, ISSABasicBlock> controlFlowGraph, SSACFG.BasicBlock basicBlock, ConstraintVisitor constraintVisitor) {
        constraintVisitor.setBasicBlock(basicBlock);
        for (SSAInstruction sSAInstruction : basicBlock) {
            if (sSAInstruction == null) continue;
            sSAInstruction.visit(constraintVisitor);
            if (!this.wasChanged(cGNode)) continue;
            return;
        }
        this.addPhiConstraints(cGNode, controlFlowGraph, basicBlock, constraintVisitor);
    }

    private void addPhiConstraints(CGNode cGNode, ControlFlowGraph<SSAInstruction, ISSABasicBlock> controlFlowGraph, SSACFG.BasicBlock basicBlock, ConstraintVisitor constraintVisitor) {
        Iterator<SSACFG.BasicBlock> iterator = controlFlowGraph.getSuccNodes(basicBlock);
        while (iterator.hasNext()) {
            SSACFG.BasicBlock basicBlock2 = iterator.next();
            if (!basicBlock2.hasPhi()) continue;
            int n = 0;
            Iterator<Object> iterator2 = controlFlowGraph.getPredNodes(basicBlock2);
            while (iterator2.hasNext()) {
                if (iterator2.next() == basicBlock) break;
                ++n;
            }
            assert (n < controlFlowGraph.getPredNodeCount(basicBlock2));
            iterator2 = basicBlock2.iteratePhis();
            while (iterator2.hasNext()) {
                SSAPhiInstruction sSAPhiInstruction = (SSAPhiInstruction)iterator2.next();
                if (sSAPhiInstruction == null) continue;
                PointerKey pointerKey = this.getPointerKeyForLocal(cGNode, sSAPhiInstruction.getDef());
                if (this.hasNoInterestingUses(cGNode, sSAPhiInstruction.getDef(), constraintVisitor.du)) {
                    this.system.recordImplicitPointsToSet(pointerKey);
                    continue;
                }
                if (sSAPhiInstruction.getUse(n) <= 0) continue;
                PointerKey pointerKey2 = this.getPointerKeyForLocal(cGNode, sSAPhiInstruction.getUse(n));
                if (this.contentsAreInvariant(constraintVisitor.symbolTable, constraintVisitor.du, sSAPhiInstruction.getUse(n))) {
                    this.system.recordImplicitPointsToSet(pointerKey2);
                    InstanceKey[] instanceKeyArray = this.getInvariantContents(constraintVisitor.symbolTable, constraintVisitor.du, cGNode, sSAPhiInstruction.getUse(n), this);
                    int n2 = 0;
                    while (n2 < instanceKeyArray.length) {
                        this.system.newConstraint(pointerKey, instanceKeyArray[n2]);
                        ++n2;
                    }
                    continue;
                }
                this.system.newConstraint(pointerKey, assignOperator, pointerKey2);
            }
        }
    }

    protected void addNodePassthruExceptionConstraints(CGNode cGNode, IR iR, DefUse defUse) {
        List<ProgramCounter> list = SSAPropagationCallGraphBuilder.getIncomingPEIs(iR, iR.getExitBlock());
        PointerKey pointerKey = this.getPointerKeyForExceptionalReturnValue(cGNode);
        TypeReference typeReference = cGNode.getMethod().getDeclaringClass().getClassLoader().getLanguage().getThrowableType();
        IClass iClass = cGNode.getClassHierarchy().lookupClass(typeReference);
        this.addExceptionDefConstraints(iR, defUse, cGNode, list, pointerKey, Collections.singleton(iClass));
    }

    private void addExceptionDefConstraints(IR iR, DefUse defUse, CGNode cGNode, List<ProgramCounter> list, PointerKey pointerKey, Set<IClass> set) {
        for (ProgramCounter programCounter : list) {
            InstanceKey[] instanceKeyArray;
            Object object;
            Object object2;
            SSAInstruction sSAInstruction = iR.getPEI(programCounter);
            if (sSAInstruction instanceof SSAAbstractInvokeInstruction) {
                object2 = (SSAAbstractInvokeInstruction)sSAInstruction;
                object = this.getPointerKeyForLocal(cGNode, ((SSAAbstractInvokeInstruction)object2).getException());
                if (!SSAPropagationCallGraphBuilder.hasUniqueCatchBlock((SSAAbstractInvokeInstruction)object2, iR)) {
                    this.addAssignmentsForCatchPointerKey(pointerKey, set, (PointerKey)object);
                }
            } else if (sSAInstruction instanceof SSAAbstractThrowInstruction) {
                object2 = (SSAAbstractThrowInstruction)sSAInstruction;
                object = this.getPointerKeyForLocal(cGNode, ((SSAAbstractThrowInstruction)object2).getException());
                if (this.contentsAreInvariant(iR.getSymbolTable(), defUse, ((SSAAbstractThrowInstruction)object2).getException())) {
                    instanceKeyArray = this.getInvariantContents(iR.getSymbolTable(), defUse, cGNode, ((SSAAbstractThrowInstruction)object2).getException(), this);
                    int n = 0;
                    while (n < instanceKeyArray.length) {
                        this.system.findOrCreateIndexForInstanceKey(instanceKeyArray[n]);
                        this.assignInstanceToCatch(pointerKey, set, instanceKeyArray[n]);
                        ++n;
                    }
                } else {
                    this.addAssignmentsForCatchPointerKey(pointerKey, set, (PointerKey)object);
                }
            }
            if ((object2 = sSAInstruction.getExceptionTypes()) == null) continue;
            object = object2.iterator();
            while (object.hasNext()) {
                InstanceKey instanceKey;
                instanceKeyArray = (InstanceKey[])object.next();
                if (instanceKeyArray == null || (instanceKey = SSAPropagationCallGraphBuilder.getInstanceKeyForPEI(cGNode, programCounter, (TypeReference)instanceKeyArray, this.instanceKeyFactory)) == null) continue;
                assert (instanceKey instanceof ConcreteTypeKey) : "uh oh: need to implement getCaughtException constraints for instance " + instanceKey;
                ConcreteTypeKey concreteTypeKey = (ConcreteTypeKey)instanceKey;
                IClass iClass = concreteTypeKey.getType();
                if (!PropagationCallGraphBuilder.catches(set, iClass, this.cha)) continue;
                this.system.newConstraint(pointerKey, SSAPropagationCallGraphBuilder.getInstanceKeyForPEI(cGNode, programCounter, (TypeReference)instanceKeyArray, this.instanceKeyFactory));
            }
        }
    }

    protected static boolean hasUniqueCatchBlock(SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction, IR iR) {
        Iterator<ISSABasicBlock> iterator;
        ISSABasicBlock[] iSSABasicBlockArray = iR.getBasicBlocksForCall(sSAAbstractInvokeInstruction.getCallSite());
        if (iSSABasicBlockArray.length == 1 && (iterator = iR.getControlFlowGraph().getExceptionalSuccessors(iSSABasicBlockArray[0]).iterator()).hasNext()) {
            iterator.next();
            return !iterator.hasNext();
        }
        return false;
    }

    public PointerKey getUniqueCatchKey(SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction, IR iR, CGNode cGNode) throws IllegalArgumentException, IllegalArgumentException {
        if (sSAAbstractInvokeInstruction == null) {
            throw new IllegalArgumentException("call == null");
        }
        if (iR == null) {
            throw new IllegalArgumentException("ir == null");
        }
        ISSABasicBlock[] iSSABasicBlockArray = iR.getBasicBlocksForCall(sSAAbstractInvokeInstruction.getCallSite());
        assert (iSSABasicBlockArray.length == 1);
        SSACFG.BasicBlock basicBlock = (SSACFG.BasicBlock)iR.getControlFlowGraph().getExceptionalSuccessors(iSSABasicBlockArray[0]).iterator().next();
        if (basicBlock.isExitBlock()) {
            return this.getPointerKeyForExceptionalReturnValue(cGNode);
        }
        SSACFG.ExceptionHandlerBasicBlock exceptionHandlerBasicBlock = (SSACFG.ExceptionHandlerBasicBlock)basicBlock;
        SSAGetCaughtExceptionInstruction sSAGetCaughtExceptionInstruction = exceptionHandlerBasicBlock.getCatchInstruction();
        return this.getPointerKeyForLocal(cGNode, sSAGetCaughtExceptionInstruction.getDef());
    }

    public static List<ProgramCounter> getIncomingPEIs(IR iR, ISSABasicBlock iSSABasicBlock) {
        if (iR == null) {
            throw new IllegalArgumentException("ir is null");
        }
        SSACFG sSACFG = iR.getControlFlowGraph();
        ArrayList<ProgramCounter> arrayList = new ArrayList<ProgramCounter>(sSACFG.getPredNodeCount(iSSABasicBlock));
        Iterator<ISSABasicBlock> iterator = sSACFG.getPredNodes(iSSABasicBlock);
        while (iterator.hasNext()) {
            SSACFG.BasicBlock basicBlock = (SSACFG.BasicBlock)iterator.next();
            if (basicBlock.isEntryBlock()) continue;
            int n = basicBlock.getLastInstructionIndex();
            SSAInstruction sSAInstruction = iR.getInstructions()[n];
            if (sSAInstruction == null || !sSAInstruction.isPEI()) continue;
            arrayList.add(new ProgramCounter(sSACFG.getProgramCounter(n)));
        }
        return arrayList;
    }

    private void processResolvedCall(CGNode cGNode, SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction, CGNode cGNode2, InstanceKey[][] instanceKeyArray, PointerKey pointerKey) {
        int n;
        int n2;
        cGNode.addTarget(sSAAbstractInvokeInstruction.getCallSite(), cGNode2);
        if (FakeRootMethod.isFakeRootMethod(cGNode.getMethod().getReference()) && this.entrypointCallSites.contains(sSAAbstractInvokeInstruction.getCallSite())) {
            this.callGraph.registerEntrypoint(cGNode2);
        }
        if (!this.haveAlreadyVisited(cGNode2)) {
            this.markDiscovered(cGNode2);
        }
        if ((n2 = sSAAbstractInvokeInstruction.getNumberOfParameters()) != (n = cGNode2.getMethod().getNumberOfParameters())) {
            return;
        }
        boolean bl = !sSAAbstractInvokeInstruction.getCallSite().isStatic() && this.needsFilterForReceiver(sSAAbstractInvokeInstruction, cGNode2);
        int n3 = 0;
        while (n3 < sSAAbstractInvokeInstruction.getNumberOfParameters()) {
            int n4 = n3 + 1;
            if (cGNode2.getMethod().getParameterType(n3).isReferenceType()) {
                Object object;
                Object object2;
                if (instanceKeyArray != null && instanceKeyArray[n3] != null) {
                    object2 = instanceKeyArray[n3];
                    int n5 = 0;
                    while (n5 < ((InstanceKey[])object2).length) {
                        if (bl && n3 == 0) {
                            object = this.getFilter(cGNode2);
                            PointerKey pointerKey2 = null;
                            pointerKey2 = this.isRootType((FilteredPointerKey.TypeFilter)object) ? this.getPointerKeyForLocal(cGNode2, n4) : this.getFilteredPointerKeyForLocal(cGNode2, n4, (FilteredPointerKey.TypeFilter)object);
                            this.system.newConstraint(pointerKey2, object2[n5]);
                        } else {
                            object = this.getPointerKeyForLocal(cGNode2, n4);
                            this.system.newConstraint((PointerKey)object, object2[n5]);
                        }
                        ++n5;
                    }
                } else {
                    if (sSAAbstractInvokeInstruction.getUse(n3) < 0) {
                        Assertions.UNREACHABLE("unexpected " + sSAAbstractInvokeInstruction + " in " + cGNode);
                    }
                    object2 = this.getPointerKeyForLocal(cGNode, sSAAbstractInvokeInstruction.getUse(n3));
                    if (bl && n3 == 0) {
                        FilteredPointerKey.TypeFilter typeFilter = this.getFilter(cGNode2);
                        if (this.isRootType(typeFilter)) {
                            object = this.getPointerKeyForLocal(cGNode2, n4);
                            this.system.newConstraint((PointerKey)object, assignOperator, (PointerKey)object2);
                        } else {
                            object = this.getFilteredPointerKeyForLocal(cGNode2, n4, typeFilter);
                            this.system.newConstraint((PointerKey)object, this.filterOperator, (PointerKey)object2);
                        }
                    } else {
                        PointerKey pointerKey3 = this.getPointerKeyForLocal(cGNode2, n4);
                        this.system.newConstraint(pointerKey3, assignOperator, (PointerKey)object2);
                    }
                }
            }
            ++n3;
        }
        if (sSAAbstractInvokeInstruction.hasDef() && sSAAbstractInvokeInstruction.getDeclaredResultType().isReferenceType()) {
            PointerKey pointerKey4 = this.getPointerKeyForLocal(cGNode, sSAAbstractInvokeInstruction.getDef());
            PointerKey pointerKey5 = this.getPointerKeyForReturnValue(cGNode2);
            this.system.newConstraint(pointerKey4, assignOperator, pointerKey5);
        }
        PointerKey pointerKey6 = this.getPointerKeyForLocal(cGNode, sSAAbstractInvokeInstruction.getException());
        PointerKey pointerKey7 = this.getPointerKeyForExceptionalReturnValue(cGNode2);
        if (pointerKey != null) {
            this.system.newConstraint(pointerKey, assignOperator, pointerKey7);
        } else {
            this.system.newConstraint(pointerKey6, assignOperator, pointerKey7);
        }
    }

    public boolean hasNoInterestingUses(CGNode cGNode, int n, DefUse defUse) {
        if (defUse == null) {
            throw new IllegalArgumentException("du is null");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("v is invalid: " + n);
        }
        InterestingVisitor interestingVisitor = this.makeInterestingVisitor(cGNode, n);
        Iterator<SSAInstruction> iterator = defUse.getUses(interestingVisitor.vn);
        while (iterator.hasNext()) {
            SSAInstruction sSAInstruction = iterator.next();
            sSAInstruction.visit(interestingVisitor);
            if (!interestingVisitor.bingo) continue;
            return false;
        }
        return true;
    }

    protected InterestingVisitor makeInterestingVisitor(CGNode cGNode, int n) {
        return new InterestingVisitor(n);
    }

    private boolean needsFilterForReceiver(SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction, CGNode cGNode) {
        FilteredPointerKey.TypeFilter typeFilter = (FilteredPointerKey.TypeFilter)cGNode.getContext().get(ContextKey.FILTER);
        if (typeFilter != null) {
            return true;
        }
        if (sSAAbstractInvokeInstruction.getCallSite().isStatic() || sSAAbstractInvokeInstruction.getCallSite().isSpecial()) {
            return false;
        }
        MethodReference methodReference = sSAAbstractInvokeInstruction.getDeclaredTarget();
        IMethod iMethod = this.getClassHierarchy().resolveMethod(methodReference);
        if (iMethod == null) {
            return true;
        }
        return true;
    }

    private boolean isRootType(IClass iClass) {
        return iClass.getClassHierarchy().isRootClass(iClass);
    }

    private boolean isRootType(FilteredPointerKey.TypeFilter typeFilter) {
        if (typeFilter instanceof FilteredPointerKey.SingleClassFilter) {
            return this.isRootType(((FilteredPointerKey.SingleClassFilter)typeFilter).getConcreteType());
        }
        return false;
    }

    private FilteredPointerKey.TypeFilter getFilter(CGNode cGNode) {
        FilteredPointerKey.TypeFilter typeFilter = (FilteredPointerKey.TypeFilter)cGNode.getContext().get(ContextKey.FILTER);
        if (typeFilter != null) {
            return typeFilter;
        }
        IClass iClass = this.getReceiverClass(cGNode.getMethod());
        return new FilteredPointerKey.SingleClassFilter(iClass);
    }

    private IClass getReceiverClass(IMethod iMethod) {
        TypeReference typeReference = iMethod.getParameterType(0);
        IClass iClass = this.getClassHierarchy().lookupClass(typeReference);
        if (iMethod.isStatic()) {
            Assertions.UNREACHABLE("asked for receiver of static method " + iMethod);
        }
        if (iClass == null) {
            Assertions.UNREACHABLE("no class found for " + typeReference + " recv of " + iMethod);
        }
        return iClass;
    }

    protected boolean contentsAreInvariant(SymbolTable symbolTable, DefUse defUse, int n) {
        if (this.isConstantRef(symbolTable, n)) {
            return true;
        }
        SSAInstruction sSAInstruction = defUse.getDef(n);
        return sSAInstruction instanceof SSANewInstruction;
    }

    protected InstanceKey[] getInvariantContents(SymbolTable symbolTable, DefUse defUse, CGNode cGNode, int n, HeapModel heapModel) {
        return this.getInvariantContents(symbolTable, defUse, cGNode, n, heapModel, false);
    }

    protected InstanceKey[] getInvariantContents(SymbolTable symbolTable, DefUse defUse, CGNode cGNode, int n, HeapModel heapModel, boolean bl) {
        InstanceKey[] instanceKeyArray;
        Object object;
        Object object2;
        if (this.isConstantRef(symbolTable, n)) {
            Object object3;
            object2 = symbolTable.getConstantValue(n);
            if (object2 instanceof String) {
                object = (String)object2;
                object3 = cGNode.getMethod().getDeclaringClass().getClassLoader().getLanguage().getConstantType(object);
                if (object3 == null) {
                    return new InstanceKey[0];
                }
                InstanceKey instanceKey = heapModel.getInstanceKeyForConstant((TypeReference)object3, object);
                instanceKeyArray = instanceKey != null ? new InstanceKey[]{instanceKey} : new InstanceKey[]{};
            } else {
                object = cGNode.getMethod().getDeclaringClass().getClassLoader().getLanguage().getConstantType(object2);
                if (object == null) {
                    return new InstanceKey[0];
                }
                object3 = heapModel.getInstanceKeyForConstant((TypeReference)object, object2);
                instanceKeyArray = object3 != null ? new InstanceKey[]{object3} : new InstanceKey[]{};
            }
        } else {
            InstanceKey[] instanceKeyArray2;
            object2 = (SSANewInstruction)defUse.getDef(n);
            object = heapModel.getInstanceKeyForAllocation(cGNode, ((SSANewInstruction)object2).getNewSite());
            if (object == null) {
                instanceKeyArray2 = new InstanceKey[]{};
            } else {
                InstanceKey[] instanceKeyArray3 = new InstanceKey[1];
                instanceKeyArray2 = instanceKeyArray3;
                instanceKeyArray3[0] = object;
            }
            instanceKeyArray = instanceKeyArray2;
        }
        if (bl) {
            int n2 = 0;
            while (n2 < instanceKeyArray.length) {
                this.system.findOrCreateIndexForInstanceKey(instanceKeyArray[n2]);
                ++n2;
            }
        }
        return instanceKeyArray;
    }

    protected boolean isConstantRef(SymbolTable symbolTable, int n) {
        if (n == -1) {
            return false;
        }
        if (symbolTable.isConstant(n)) {
            Object object = symbolTable.getConstantValue(n);
            return !(object instanceof Number);
        }
        return false;
    }

    @Override
    public Iterator<PointerKey> iteratePointerKeys() {
        return this.system.iteratePointerKeys();
    }

    public static Set<IClass> getCaughtExceptionTypes(SSAGetCaughtExceptionInstruction sSAGetCaughtExceptionInstruction, IR iR) {
        if (iR == null) {
            throw new IllegalArgumentException("ir is null");
        }
        if (sSAGetCaughtExceptionInstruction == null) {
            throw new IllegalArgumentException("instruction is null");
        }
        Iterator<TypeReference> iterator = ((SSACFG.ExceptionHandlerBasicBlock)iR.getControlFlowGraph().getNode(sSAGetCaughtExceptionInstruction.getBasicBlockNumber())).getCaughtExceptionTypes();
        HashSet<IClass> hashSet = HashSetFactory.make(10);
        while (iterator.hasNext()) {
            IClass iClass = iR.getMethod().getClassHierarchy().lookupClass(iterator.next());
            if (iClass == null) continue;
            hashSet.add(iClass);
        }
        return hashSet;
    }

    @Override
    public InstanceKey getInstanceKeyForPEI(CGNode cGNode, ProgramCounter programCounter, TypeReference typeReference) {
        return SSAPropagationCallGraphBuilder.getInstanceKeyForPEI(cGNode, programCounter, typeReference, this.instanceKeyFactory);
    }

    @Override
    protected IPointsToSolver makeSolver() {
        return new StandardSolver(this.system, this);
    }

    private static class CheckcastFailure
    extends Warning {
        final TypeReference type;

        CheckcastFailure(TypeReference typeReference) {
            super((byte)2);
            this.type = typeReference;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.type;
        }

        public static CheckcastFailure create(TypeReference typeReference) {
            return new CheckcastFailure(typeReference);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ConstraintVisitor
    extends SSAInstruction.Visitor {
        protected final SSAPropagationCallGraphBuilder builder;
        protected final ExplicitCallGraph.ExplicitNode node;
        private final ExplicitCallGraph callGraph;
        protected final IR ir;
        protected final PropagationSystem system;
        private ISSABasicBlock basicBlock;
        protected final SymbolTable symbolTable;
        protected final DefUse du;

        public ConstraintVisitor(SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder, ExplicitCallGraph.ExplicitNode explicitNode) {
            this.builder = sSAPropagationCallGraphBuilder;
            this.node = explicitNode;
            this.callGraph = sSAPropagationCallGraphBuilder.getCallGraph();
            this.system = sSAPropagationCallGraphBuilder.getPropagationSystem();
            this.ir = sSAPropagationCallGraphBuilder.getCFAContextInterpreter().getIR(explicitNode);
            this.symbolTable = this.ir.getSymbolTable();
            this.du = sSAPropagationCallGraphBuilder.getCFAContextInterpreter().getDU(explicitNode);
            assert (this.symbolTable != null);
        }

        protected SSAPropagationCallGraphBuilder getBuilder() {
            return this.builder;
        }

        protected AnalysisOptions getOptions() {
            return this.builder.options;
        }

        protected AnalysisCache getAnalysisCache() {
            return this.builder.getAnalysisCache();
        }

        public PointerKey getPointerKeyForLocal(int n) {
            return this.getBuilder().getPointerKeyForLocal(this.node, n);
        }

        public FilteredPointerKey getFilteredPointerKeyForLocal(int n, FilteredPointerKey.TypeFilter typeFilter) {
            return this.getBuilder().getFilteredPointerKeyForLocal((CGNode)this.node, n, typeFilter);
        }

        public PointerKey getPointerKeyForReturnValue() {
            return this.getBuilder().getPointerKeyForReturnValue(this.node);
        }

        public PointerKey getPointerKeyForExceptionalReturnValue() {
            return this.getBuilder().getPointerKeyForExceptionalReturnValue(this.node);
        }

        public PointerKey getPointerKeyForStaticField(IField iField) {
            return this.getBuilder().getPointerKeyForStaticField(iField);
        }

        public PointerKey getPointerKeyForInstanceField(InstanceKey instanceKey, IField iField) {
            return this.getBuilder().getPointerKeyForInstanceField(instanceKey, iField);
        }

        public PointerKey getPointerKeyForArrayContents(InstanceKey instanceKey) {
            return this.getBuilder().getPointerKeyForArrayContents(instanceKey);
        }

        public InstanceKey getInstanceKeyForAllocation(NewSiteReference newSiteReference) {
            return this.getBuilder().getInstanceKeyForAllocation(this.node, newSiteReference);
        }

        public InstanceKey getInstanceKeyForMultiNewArray(NewSiteReference newSiteReference, int n) {
            return this.getBuilder().getInstanceKeyForMultiNewArray(this.node, newSiteReference, n);
        }

        public <T> InstanceKey getInstanceKeyForConstant(T t) {
            TypeReference typeReference = this.node.getMethod().getDeclaringClass().getClassLoader().getLanguage().getConstantType(t);
            return this.getBuilder().getInstanceKeyForConstant(typeReference, t);
        }

        public InstanceKey getInstanceKeyForPEI(ProgramCounter programCounter, TypeReference typeReference) {
            return this.getBuilder().getInstanceKeyForPEI(this.node, programCounter, typeReference);
        }

        public InstanceKey getInstanceKeyForClassObject(TypeReference typeReference) {
            return this.getBuilder().getInstanceKeyForClassObject(typeReference);
        }

        public CGNode getTargetForCall(CGNode cGNode, CallSiteReference callSiteReference, InstanceKey instanceKey) {
            return this.getBuilder().getTargetForCall(cGNode, callSiteReference, instanceKey);
        }

        protected boolean contentsAreInvariant(SymbolTable symbolTable, DefUse defUse, int n) {
            return this.getBuilder().contentsAreInvariant(symbolTable, defUse, n);
        }

        protected InstanceKey[] getInvariantContents(int n) {
            return this.getInvariantContents(this.ir.getSymbolTable(), this.du, this.node, n);
        }

        protected InstanceKey[] getInvariantContents(SymbolTable symbolTable, DefUse defUse, CGNode cGNode, int n) {
            return this.getBuilder().getInvariantContents(symbolTable, defUse, cGNode, n, this.getBuilder());
        }

        protected IClassHierarchy getClassHierarchy() {
            return this.getBuilder().getClassHierarchy();
        }

        protected boolean hasNoInterestingUses(int n) {
            return this.getBuilder().hasNoInterestingUses(this.node, n, this.du);
        }

        protected boolean isRootType(IClass iClass) {
            return this.getBuilder().isRootType(iClass);
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction sSAArrayLoadInstruction) {
            if (sSAArrayLoadInstruction.typeIsPrimitive()) {
                return;
            }
            this.doVisitArrayLoad(sSAArrayLoadInstruction.getDef(), sSAArrayLoadInstruction.getArrayRef());
        }

        protected void doVisitArrayLoad(int n, int n2) {
            PointerKey pointerKey = this.getPointerKeyForLocal(n);
            PointerKey pointerKey2 = this.getPointerKeyForLocal(n2);
            if (this.hasNoInterestingUses(n)) {
                this.system.recordImplicitPointsToSet(pointerKey);
            } else if (this.contentsAreInvariant(this.symbolTable, this.du, n2)) {
                this.system.recordImplicitPointsToSet(pointerKey2);
                InstanceKey[] instanceKeyArray = this.getInvariantContents(n2);
                int n3 = 0;
                while (n3 < instanceKeyArray.length) {
                    if (!SSAPropagationCallGraphBuilder.representsNullType(instanceKeyArray[n3])) {
                        this.system.findOrCreateIndexForInstanceKey(instanceKeyArray[n3]);
                        PointerKey pointerKey3 = this.getPointerKeyForArrayContents(instanceKeyArray[n3]);
                        if (pointerKey3 != null) {
                            this.system.newConstraint(pointerKey, assignOperator, pointerKey3);
                        }
                    }
                    ++n3;
                }
            } else {
                assert (!this.system.isUnified(pointerKey));
                assert (!this.system.isUnified(pointerKey2));
                SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                sSAPropagationCallGraphBuilder.getClass();
                this.system.newSideEffect(sSAPropagationCallGraphBuilder.new PropagationCallGraphBuilder.ArrayLoadOperator(this.system.findOrCreatePointsToSet(pointerKey)), pointerKey2);
            }
        }

        public void doVisitArrayStore(int n, int n2) {
            PointerKey pointerKey = this.getPointerKeyForLocal(n2);
            PointerKey pointerKey2 = this.getPointerKeyForLocal(n);
            if (this.contentsAreInvariant(this.symbolTable, this.du, n)) {
                this.system.recordImplicitPointsToSet(pointerKey2);
                InstanceKey[] instanceKeyArray = this.getInvariantContents(n);
                int n3 = 0;
                while (n3 < instanceKeyArray.length) {
                    if (!SSAPropagationCallGraphBuilder.representsNullType(instanceKeyArray[n3])) {
                        this.system.findOrCreateIndexForInstanceKey(instanceKeyArray[n3]);
                        PointerKey pointerKey3 = this.getPointerKeyForArrayContents(instanceKeyArray[n3]);
                        IClass iClass = ((ArrayClass)instanceKeyArray[n3].getConcreteType()).getElementClass();
                        if (pointerKey3 != null) {
                            if (this.contentsAreInvariant(this.symbolTable, this.du, n2)) {
                                this.system.recordImplicitPointsToSet(pointerKey);
                                InstanceKey[] instanceKeyArray2 = this.getInvariantContents(n2);
                                int n4 = 0;
                                while (n4 < instanceKeyArray2.length) {
                                    this.system.findOrCreateIndexForInstanceKey(instanceKeyArray2[n4]);
                                    if (instanceKeyArray2[n4].getConcreteType() != null && this.getClassHierarchy().isAssignableFrom(iClass, instanceKeyArray2[n4].getConcreteType())) {
                                        this.system.newConstraint(pointerKey3, instanceKeyArray2[n4]);
                                    }
                                    ++n4;
                                }
                            } else if (this.isRootType(iClass)) {
                                this.system.newConstraint(pointerKey3, assignOperator, pointerKey);
                            } else {
                                this.system.newConstraint(pointerKey3, this.getBuilder().filterOperator, pointerKey);
                            }
                        }
                    }
                    ++n3;
                }
            } else if (this.contentsAreInvariant(this.symbolTable, this.du, n2)) {
                this.system.recordImplicitPointsToSet(pointerKey);
                InstanceKey[] instanceKeyArray = this.getInvariantContents(n2);
                int n5 = 0;
                while (n5 < instanceKeyArray.length) {
                    this.system.findOrCreateIndexForInstanceKey(instanceKeyArray[n5]);
                    assert (!this.system.isUnified(pointerKey2));
                    SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                    sSAPropagationCallGraphBuilder.getClass();
                    this.system.newSideEffect(sSAPropagationCallGraphBuilder.new PropagationCallGraphBuilder.InstanceArrayStoreOperator(instanceKeyArray[n5]), pointerKey2);
                    ++n5;
                }
            } else {
                SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                sSAPropagationCallGraphBuilder.getClass();
                this.system.newSideEffect(sSAPropagationCallGraphBuilder.new PropagationCallGraphBuilder.ArrayStoreOperator(this.system.findOrCreatePointsToSet(pointerKey)), pointerKey2);
            }
        }

        @Override
        public void visitArrayStore(SSAArrayStoreInstruction sSAArrayStoreInstruction) {
            if (sSAArrayStoreInstruction.typeIsPrimitive()) {
                return;
            }
            this.doVisitArrayStore(sSAArrayStoreInstruction.getArrayRef(), sSAArrayStoreInstruction.getValue());
        }

        @Override
        public void visitCheckCast(SSACheckCastInstruction sSACheckCastInstruction) {
            Object object;
            boolean bl = false;
            HashSet<IClass> hashSet = HashSetFactory.make();
            Object object2 = sSACheckCastInstruction.getDeclaredResultTypes();
            int n = ((TypeReference[])object2).length;
            int n2 = 0;
            while (n2 < n) {
                object = object2[n2];
                IClass iClass = this.getClassHierarchy().lookupClass((TypeReference)object);
                if (iClass == null) {
                    Warnings.add(CheckcastFailure.create((TypeReference)object));
                    return;
                }
                if (this.isRootType(iClass)) {
                    bl = true;
                }
                hashSet.add(iClass);
                ++n2;
            }
            object = this.getFilteredPointerKeyForLocal(sSACheckCastInstruction.getResult(), new FilteredPointerKey.MultipleClassesFilter(hashSet.toArray(new IClass[hashSet.size()])));
            PointerKey pointerKey = this.getPointerKeyForLocal(sSACheckCastInstruction.getVal());
            if (this.hasNoInterestingUses(sSACheckCastInstruction.getDef())) {
                this.system.recordImplicitPointsToSet((PointerKey)object);
            } else if (this.contentsAreInvariant(this.symbolTable, this.du, sSACheckCastInstruction.getVal())) {
                this.system.recordImplicitPointsToSet(pointerKey);
                InstanceKey[] instanceKeyArray = this.getInvariantContents(sSACheckCastInstruction.getVal());
                TypeReference[] typeReferenceArray = sSACheckCastInstruction.getDeclaredResultTypes();
                int n3 = typeReferenceArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    int n5;
                    object2 = typeReferenceArray[n4];
                    IClass iClass = this.getClassHierarchy().lookupClass((TypeReference)object2);
                    if (iClass.isInterface()) {
                        n5 = 0;
                        while (n5 < instanceKeyArray.length) {
                            this.system.findOrCreateIndexForInstanceKey(instanceKeyArray[n5]);
                            if (this.getClassHierarchy().implementsInterface(instanceKeyArray[n5].getConcreteType(), iClass)) {
                                this.system.newConstraint((PointerKey)object, instanceKeyArray[n5]);
                            }
                            ++n5;
                        }
                    } else {
                        n5 = 0;
                        while (n5 < instanceKeyArray.length) {
                            this.system.findOrCreateIndexForInstanceKey(instanceKeyArray[n5]);
                            if (this.getClassHierarchy().isSubclassOf(instanceKeyArray[n5].getConcreteType(), iClass)) {
                                this.system.newConstraint((PointerKey)object, instanceKeyArray[n5]);
                            }
                            ++n5;
                        }
                    }
                    ++n4;
                }
            } else if (bl) {
                this.system.newConstraint((PointerKey)object, assignOperator, pointerKey);
            } else {
                this.system.newConstraint((PointerKey)object, this.getBuilder().filterOperator, pointerKey);
            }
        }

        @Override
        public void visitReturn(SSAReturnInstruction sSAReturnInstruction) {
            if (sSAReturnInstruction.returnsPrimitiveType() || sSAReturnInstruction.returnsVoid()) {
                return;
            }
            PointerKey pointerKey = this.getPointerKeyForReturnValue();
            PointerKey pointerKey2 = this.getPointerKeyForLocal(sSAReturnInstruction.getResult());
            if (this.contentsAreInvariant(this.symbolTable, this.du, sSAReturnInstruction.getResult())) {
                this.system.recordImplicitPointsToSet(pointerKey2);
                InstanceKey[] instanceKeyArray = this.getInvariantContents(sSAReturnInstruction.getResult());
                int n = 0;
                while (n < instanceKeyArray.length) {
                    this.system.newConstraint(pointerKey, instanceKeyArray[n]);
                    ++n;
                }
            } else {
                this.system.newConstraint(pointerKey, assignOperator, pointerKey2);
            }
        }

        @Override
        public void visitGet(SSAGetInstruction sSAGetInstruction) {
            this.visitGetInternal(sSAGetInstruction.getDef(), sSAGetInstruction.getRef(), sSAGetInstruction.isStatic(), sSAGetInstruction.getDeclaredField());
        }

        protected void visitGetInternal(int n, int n2, boolean bl, FieldReference fieldReference) {
            if (fieldReference.getFieldType().isPrimitiveType()) {
                return;
            }
            PointerKey pointerKey = this.getPointerKeyForLocal(n);
            assert (pointerKey != null);
            IField iField = this.getClassHierarchy().resolveField(fieldReference);
            if (iField == null && this.callGraph.getFakeRootNode().getMethod().getDeclaringClass().getReference().equals(fieldReference.getDeclaringClass())) {
                iField = this.callGraph.getFakeRootNode().getMethod().getDeclaringClass().getField(fieldReference.getName());
            }
            if (iField == null) {
                return;
            }
            if (this.hasNoInterestingUses(n)) {
                this.system.recordImplicitPointsToSet(pointerKey);
            } else if (bl) {
                PointerKey pointerKey2 = this.getPointerKeyForStaticField(iField);
                this.system.newConstraint(pointerKey, assignOperator, pointerKey2);
                IClass iClass = this.getClassHierarchy().lookupClass(fieldReference.getDeclaringClass());
                if (iClass != null) {
                    this.processClassInitializer(iClass);
                }
            } else {
                PointerKey pointerKey3 = this.getPointerKeyForLocal(n2);
                if (this.contentsAreInvariant(this.symbolTable, this.du, n2)) {
                    this.system.recordImplicitPointsToSet(pointerKey3);
                    InstanceKey[] instanceKeyArray = this.getInvariantContents(n2);
                    int n3 = 0;
                    while (n3 < instanceKeyArray.length) {
                        if (!SSAPropagationCallGraphBuilder.representsNullType(instanceKeyArray[n3])) {
                            this.system.findOrCreateIndexForInstanceKey(instanceKeyArray[n3]);
                            PointerKey pointerKey4 = this.getPointerKeyForInstanceField(instanceKeyArray[n3], iField);
                            this.system.newConstraint(pointerKey, assignOperator, pointerKey4);
                        }
                        ++n3;
                    }
                } else {
                    SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                    sSAPropagationCallGraphBuilder.getClass();
                    this.system.newSideEffect(sSAPropagationCallGraphBuilder.new PropagationCallGraphBuilder.GetFieldOperator(iField, this.system.findOrCreatePointsToSet(pointerKey)), pointerKey3);
                }
            }
        }

        @Override
        public void visitPut(SSAPutInstruction sSAPutInstruction) {
            this.visitPutInternal(sSAPutInstruction.getVal(), sSAPutInstruction.getRef(), sSAPutInstruction.isStatic(), sSAPutInstruction.getDeclaredField());
        }

        public void visitPutInternal(int n, int n2, boolean bl, FieldReference fieldReference) {
            if (fieldReference.getFieldType().isPrimitiveType()) {
                return;
            }
            IField iField = this.getClassHierarchy().resolveField(fieldReference);
            if (iField == null) {
                Warnings.add(FieldResolutionFailure.create(fieldReference));
                return;
            }
            assert (bl || !this.symbolTable.isStringConstant(n2)) : "put to string constant shouldn't be allowed?";
            if (bl) {
                this.processPutStatic(n, fieldReference, iField);
            } else {
                this.processPutField(n, n2, iField);
            }
        }

        private void processPutField(int n, int n2, IField iField) {
            assert (!iField.getFieldTypeReference().isPrimitiveType());
            PointerKey pointerKey = this.getPointerKeyForLocal(n2);
            PointerKey pointerKey2 = this.getPointerKeyForLocal(n);
            if (this.contentsAreInvariant(this.symbolTable, this.du, n)) {
                this.system.recordImplicitPointsToSet(pointerKey2);
                InstanceKey[] instanceKeyArray = this.getInvariantContents(n);
                if (this.contentsAreInvariant(this.symbolTable, this.du, n2)) {
                    this.system.recordImplicitPointsToSet(pointerKey);
                    InstanceKey[] instanceKeyArray2 = this.getInvariantContents(n2);
                    int n3 = 0;
                    while (n3 < instanceKeyArray2.length) {
                        if (!SSAPropagationCallGraphBuilder.representsNullType(instanceKeyArray2[n3])) {
                            this.system.findOrCreateIndexForInstanceKey(instanceKeyArray2[n3]);
                            PointerKey pointerKey3 = this.getPointerKeyForInstanceField(instanceKeyArray2[n3], iField);
                            int n4 = 0;
                            while (n4 < instanceKeyArray.length) {
                                this.system.newConstraint(pointerKey3, instanceKeyArray[n4]);
                                ++n4;
                            }
                        }
                        ++n3;
                    }
                } else {
                    int n5 = 0;
                    while (n5 < instanceKeyArray.length) {
                        this.system.findOrCreateIndexForInstanceKey(instanceKeyArray[n5]);
                        SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                        sSAPropagationCallGraphBuilder.getClass();
                        this.system.newSideEffect(sSAPropagationCallGraphBuilder.new PropagationCallGraphBuilder.InstancePutFieldOperator(iField, instanceKeyArray[n5]), pointerKey);
                        ++n5;
                    }
                }
            } else if (this.contentsAreInvariant(this.symbolTable, this.du, n2)) {
                this.system.recordImplicitPointsToSet(pointerKey);
                InstanceKey[] instanceKeyArray = this.getInvariantContents(n2);
                int n6 = 0;
                while (n6 < instanceKeyArray.length) {
                    if (!SSAPropagationCallGraphBuilder.representsNullType(instanceKeyArray[n6])) {
                        this.system.findOrCreateIndexForInstanceKey(instanceKeyArray[n6]);
                        PointerKey pointerKey4 = this.getPointerKeyForInstanceField(instanceKeyArray[n6], iField);
                        this.system.newConstraint(pointerKey4, assignOperator, pointerKey2);
                    }
                    ++n6;
                }
            } else {
                SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                sSAPropagationCallGraphBuilder.getClass();
                this.system.newSideEffect(sSAPropagationCallGraphBuilder.new PropagationCallGraphBuilder.PutFieldOperator(iField, this.system.findOrCreatePointsToSet(pointerKey2)), pointerKey);
            }
        }

        private void processPutStatic(int n, FieldReference fieldReference, IField iField) {
            Object object;
            PointerKey pointerKey = this.getPointerKeyForStaticField(iField);
            PointerKey pointerKey2 = this.getPointerKeyForLocal(n);
            if (this.contentsAreInvariant(this.symbolTable, this.du, n)) {
                this.system.recordImplicitPointsToSet(pointerKey2);
                object = this.getInvariantContents(n);
                int n2 = 0;
                while (n2 < ((InstanceKey[])object).length) {
                    this.system.newConstraint(pointerKey, object[n2]);
                    ++n2;
                }
            } else {
                this.system.newConstraint(pointerKey, assignOperator, pointerKey2);
            }
            object = this.getClassHierarchy().lookupClass(fieldReference.getDeclaringClass());
            if (object == null) {
                Warnings.add(FieldResolutionFailure.create(fieldReference));
            } else {
                this.processClassInitializer((IClass)object);
            }
        }

        @Override
        public void visitInvoke(SSAInvokeInstruction sSAInvokeInstruction) {
            this.visitInvokeInternal(sSAInvokeInstruction);
        }

        protected void visitInvokeInternal(SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction) {
            PointerKey pointerKey = null;
            if (SSAPropagationCallGraphBuilder.hasUniqueCatchBlock(sSAAbstractInvokeInstruction, this.ir)) {
                pointerKey = this.getBuilder().getUniqueCatchKey(sSAAbstractInvokeInstruction, this.ir, this.node);
            }
            if (sSAAbstractInvokeInstruction.getCallSite().isStatic()) {
                CGNode cGNode = this.getTargetForCall(this.node, sSAAbstractInvokeInstruction.getCallSite(), null);
                if (cGNode != null) {
                    this.getBuilder().processResolvedCall(this.node, sSAAbstractInvokeInstruction, cGNode, this.computeInvariantParameters(sSAAbstractInvokeInstruction), pointerKey);
                    this.processClassInitializer(cGNode.getMethod().getDeclaringClass());
                }
            } else {
                PointerKey pointerKey2 = this.getPointerKeyForLocal(sSAAbstractInvokeInstruction.getReceiver());
                if (this.contentsAreInvariant(this.symbolTable, this.du, sSAAbstractInvokeInstruction.getReceiver())) {
                    this.system.recordImplicitPointsToSet(pointerKey2);
                    InstanceKey[] instanceKeyArray = this.getInvariantContents(sSAAbstractInvokeInstruction.getReceiver());
                    int n = 0;
                    while (n < instanceKeyArray.length) {
                        this.system.findOrCreateIndexForInstanceKey(instanceKeyArray[n]);
                        CGNode cGNode = this.getTargetForCall(this.node, sSAAbstractInvokeInstruction.getCallSite(), instanceKeyArray[n]);
                        if (cGNode != null) {
                            this.getBuilder().processResolvedCall(this.node, sSAAbstractInvokeInstruction, cGNode, this.computeInvariantParameters(sSAAbstractInvokeInstruction), pointerKey);
                            this.processClassInitializer(cGNode.getMethod().getDeclaringClass());
                        }
                        ++n;
                    }
                } else {
                    SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                    sSAPropagationCallGraphBuilder.getClass();
                    DispatchOperator dispatchOperator = sSAPropagationCallGraphBuilder.new DispatchOperator(sSAAbstractInvokeInstruction, this.node, this.computeInvariantParameters(sSAAbstractInvokeInstruction), pointerKey);
                    this.system.newSideEffect(dispatchOperator, pointerKey2);
                }
            }
        }

        @Override
        public void visitNew(SSANewInstruction sSANewInstruction) {
            InstanceKey instanceKey = this.getInstanceKeyForAllocation(sSANewInstruction.getNewSite());
            if (instanceKey == null) {
                return;
            }
            PointerKey pointerKey = this.getPointerKeyForLocal(sSANewInstruction.getDef());
            IClass iClass = instanceKey.getConcreteType();
            if (iClass == null) {
                return;
            }
            if (!this.contentsAreInvariant(this.symbolTable, this.du, sSANewInstruction.getDef())) {
                this.system.newConstraint(pointerKey, instanceKey);
            } else {
                this.system.findOrCreateIndexForInstanceKey(instanceKey);
                this.system.recordImplicitPointsToSet(pointerKey);
            }
            this.processClassInitializer(iClass);
            int n = 0;
            Object object = instanceKey;
            while (iClass != null && iClass.isArrayClass()) {
                Object object2;
                if ((iClass = ((ArrayClass)iClass).getElementClass()) == null || !iClass.isArrayClass()) continue;
                if (sSANewInstruction.getNumberOfUses() <= n + 1) break;
                int n2 = sSANewInstruction.getUse(n + 1);
                if (this.ir.getSymbolTable().isIntegerConstant(n2) && (Integer)(object2 = (Integer)this.ir.getSymbolTable().getConstantValue(n2)) == 0) break;
                object2 = this.getInstanceKeyForMultiNewArray(sSANewInstruction.getNewSite(), n);
                PointerKey pointerKey2 = this.getPointerKeyForArrayContents((InstanceKey)object);
                this.system.newConstraint(pointerKey2, (InstanceKey)object2);
                object = object2;
                ++n;
            }
        }

        @Override
        public void visitThrow(SSAThrowInstruction sSAThrowInstruction) {
        }

        @Override
        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction sSAGetCaughtExceptionInstruction) {
            List<ProgramCounter> list = SSAPropagationCallGraphBuilder.getIncomingPEIs(this.ir, this.getBasicBlock());
            PointerKey pointerKey = this.getPointerKeyForLocal(sSAGetCaughtExceptionInstruction.getDef());
            Set<IClass> set = SSAPropagationCallGraphBuilder.getCaughtExceptionTypes(sSAGetCaughtExceptionInstruction, this.ir);
            this.getBuilder().addExceptionDefConstraints(this.ir, this.du, this.node, list, pointerKey, set);
        }

        private int booleanConstantTest(SSAConditionalBranchInstruction sSAConditionalBranchInstruction, int n) {
            int n2 = 0;
            if (this.symbolTable.isZeroOrFalse(sSAConditionalBranchInstruction.getUse(0)) && sSAConditionalBranchInstruction.getUse(1) == n || this.symbolTable.isZeroOrFalse(sSAConditionalBranchInstruction.getUse(1)) && sSAConditionalBranchInstruction.getUse(0) == n) {
                n2 = -1;
            } else if (this.symbolTable.isOneOrTrue(sSAConditionalBranchInstruction.getUse(0)) && sSAConditionalBranchInstruction.getUse(1) == n || this.symbolTable.isOneOrTrue(sSAConditionalBranchInstruction.getUse(1)) && sSAConditionalBranchInstruction.getUse(0) == n) {
                n2 = 1;
            }
            if (sSAConditionalBranchInstruction.getOperator() == IConditionalBranchInstruction.Operator.NE) {
                n2 = -n2;
            }
            return n2;
        }

        private int nullConstantTest(SSAConditionalBranchInstruction sSAConditionalBranchInstruction, int n) {
            if (this.symbolTable.isNullConstant(sSAConditionalBranchInstruction.getUse(0)) && sSAConditionalBranchInstruction.getUse(1) == n || this.symbolTable.isNullConstant(sSAConditionalBranchInstruction.getUse(1)) && sSAConditionalBranchInstruction.getUse(0) == n) {
                if (sSAConditionalBranchInstruction.getOperator() == IConditionalBranchInstruction.Operator.EQ) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }

        @Override
        public void visitPhi(SSAPhiInstruction sSAPhiInstruction) {
            if (this.ir.getMethod() instanceof AbstractRootMethod) {
                PointerKey pointerKey = this.getPointerKeyForLocal(sSAPhiInstruction.getDef());
                if (this.hasNoInterestingUses(sSAPhiInstruction.getDef())) {
                    this.system.recordImplicitPointsToSet(pointerKey);
                } else {
                    int n = 0;
                    while (n < sSAPhiInstruction.getNumberOfUses()) {
                        PointerKey pointerKey2 = this.getPointerKeyForLocal(sSAPhiInstruction.getUse(n));
                        if (this.contentsAreInvariant(this.symbolTable, this.du, sSAPhiInstruction.getUse(n))) {
                            this.system.recordImplicitPointsToSet(pointerKey2);
                            InstanceKey[] instanceKeyArray = this.getInvariantContents(sSAPhiInstruction.getUse(n));
                            int n2 = 0;
                            while (n2 < instanceKeyArray.length) {
                                this.system.newConstraint(pointerKey, instanceKeyArray[n2]);
                                ++n2;
                            }
                        } else {
                            this.system.newConstraint(pointerKey, assignOperator, pointerKey2);
                        }
                        ++n;
                    }
                }
            }
        }

        @Override
        public void visitPi(SSAPiInstruction sSAPiInstruction) {
            if (this.hasNoInterestingUses(sSAPiInstruction.getDef())) {
                PointerKey pointerKey = this.getPointerKeyForLocal(sSAPiInstruction.getDef());
                this.system.recordImplicitPointsToSet(pointerKey);
            } else {
                SSACFG sSACFG = this.ir.getControlFlowGraph();
                if (Util.endsWithConditionalBranch(sSACFG, this.getBasicBlock()) && sSACFG.getSuccNodeCount(this.getBasicBlock()) == 2) {
                    SSAConditionalBranchInstruction sSAConditionalBranchInstruction = (SSAConditionalBranchInstruction)Util.getLastInstruction(sSACFG, this.getBasicBlock());
                    SSAInstruction sSAInstruction = sSAPiInstruction.getCause();
                    SSACFG.BasicBlock basicBlock = (SSACFG.BasicBlock)sSACFG.getNode(sSAPiInstruction.getSuccessor());
                    if (sSAInstruction instanceof SSAInstanceofInstruction) {
                        int n = this.booleanConstantTest(sSAConditionalBranchInstruction, sSAInstruction.getDef());
                        if (n != 0) {
                            TypeReference typeReference = ((SSAInstanceofInstruction)sSAInstruction).getCheckedType();
                            IClass iClass = this.getClassHierarchy().lookupClass(typeReference);
                            if (iClass == null) {
                                PointerKey pointerKey = this.getPointerKeyForLocal(sSAPiInstruction.getDef());
                                this.addPiAssignment(pointerKey, sSAPiInstruction.getVal());
                            } else {
                                FilteredPointerKey filteredPointerKey = this.getFilteredPointerKeyForLocal(sSAPiInstruction.getDef(), new FilteredPointerKey.SingleClassFilter(iClass));
                                PointerKey pointerKey = this.getPointerKeyForLocal(sSAPiInstruction.getVal());
                                if (basicBlock == Util.getTakenSuccessor(sSACFG, this.getBasicBlock()) && n == 1 || basicBlock == Util.getNotTakenSuccessor(sSACFG, this.getBasicBlock()) && n == -1) {
                                    this.system.newConstraint((PointerKey)filteredPointerKey, this.getBuilder().filterOperator, pointerKey);
                                } else {
                                    this.system.newConstraint((PointerKey)filteredPointerKey, this.getBuilder().inverseFilterOperator, pointerKey);
                                }
                            }
                        }
                    } else {
                        int n = this.nullConstantTest(sSAConditionalBranchInstruction, sSAPiInstruction.getVal());
                        if (n != 0) {
                            if (basicBlock == Util.getTakenSuccessor(sSACFG, this.getBasicBlock()) && n == -1 || basicBlock == Util.getNotTakenSuccessor(sSACFG, this.getBasicBlock()) && n == 1) {
                                PointerKey pointerKey = this.getPointerKeyForLocal(sSAPiInstruction.getDef());
                                this.addPiAssignment(pointerKey, sSAPiInstruction.getVal());
                            }
                        } else {
                            PointerKey pointerKey = this.getPointerKeyForLocal(sSAPiInstruction.getDef());
                            this.addPiAssignment(pointerKey, sSAPiInstruction.getVal());
                        }
                    }
                } else {
                    PointerKey pointerKey = this.getPointerKeyForLocal(sSAPiInstruction.getDef());
                    this.addPiAssignment(pointerKey, sSAPiInstruction.getVal());
                }
            }
        }

        private void addPiAssignment(PointerKey pointerKey, int n) {
            PointerKey pointerKey2 = this.getPointerKeyForLocal(n);
            if (this.contentsAreInvariant(this.symbolTable, this.du, n)) {
                this.system.recordImplicitPointsToSet(pointerKey2);
                InstanceKey[] instanceKeyArray = this.getInvariantContents(n);
                int n2 = 0;
                while (n2 < instanceKeyArray.length) {
                    this.system.newConstraint(pointerKey, instanceKeyArray[n2]);
                    ++n2;
                }
            } else {
                this.system.newConstraint(pointerKey, assignOperator, pointerKey2);
            }
        }

        public ISSABasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        public void setBasicBlock(ISSABasicBlock iSSABasicBlock) {
            this.basicBlock = iSSABasicBlock;
        }

        protected InstanceKey[][] computeInvariantParameters(SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction) {
            InstanceKey[][] instanceKeyArray = null;
            int n = 0;
            while (n < sSAAbstractInvokeInstruction.getNumberOfUses()) {
                if (sSAAbstractInvokeInstruction.getUse(n) > 0 && this.contentsAreInvariant(this.symbolTable, this.du, sSAAbstractInvokeInstruction.getUse(n))) {
                    this.system.recordImplicitPointsToSet(this.getPointerKeyForLocal(sSAAbstractInvokeInstruction.getUse(n)));
                    if (instanceKeyArray == null) {
                        instanceKeyArray = new InstanceKey[sSAAbstractInvokeInstruction.getNumberOfUses()][];
                    }
                    instanceKeyArray[n] = this.getInvariantContents(sSAAbstractInvokeInstruction.getUse(n));
                    int n2 = 0;
                    while (n2 < instanceKeyArray[n].length) {
                        this.system.findOrCreateIndexForInstanceKey(instanceKeyArray[n][n2]);
                        ++n2;
                    }
                }
                ++n;
            }
            return instanceKeyArray;
        }

        @Override
        public void visitLoadMetadata(SSALoadMetadataInstruction sSALoadMetadataInstruction) {
            PointerKey pointerKey = this.getPointerKeyForLocal(sSALoadMetadataInstruction.getDef());
            assert (sSALoadMetadataInstruction.getType() == TypeReference.JavaLangClass);
            InstanceKey instanceKey = this.getInstanceKeyForClassObject((TypeReference)sSALoadMetadataInstruction.getToken());
            IClass iClass = this.getClassHierarchy().lookupClass((TypeReference)sSALoadMetadataInstruction.getToken());
            if (iClass != null) {
                this.processClassInitializer(iClass);
            }
            if (!this.contentsAreInvariant(this.symbolTable, this.du, sSALoadMetadataInstruction.getDef())) {
                this.system.newConstraint(pointerKey, instanceKey);
            } else {
                this.system.findOrCreateIndexForInstanceKey(instanceKey);
                this.system.recordImplicitPointsToSet(pointerKey);
            }
        }

        private void processClassInitializer(IClass iClass) {
            IClassHierarchyDweller iClassHierarchyDweller;
            assert (iClass != null);
            if (!this.getBuilder().getOptions().getHandleStaticInit()) {
                return;
            }
            if (this.getBuilder().clinitVisited.contains(iClass)) {
                return;
            }
            this.getBuilder().clinitVisited.add(iClass);
            if (iClass.getClassInitializer() != null) {
                CGNode cGNode;
                iClassHierarchyDweller = (AbstractRootMethod)this.callGraph.getFakeWorldClinitNode().getMethod();
                MethodReference methodReference = iClass.getClassInitializer().getReference();
                CallSiteReference callSiteReference = CallSiteReference.make(1, methodReference, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.STATIC);
                IMethod iMethod = this.getOptions().getMethodTargetSelector().getCalleeTarget(this.callGraph.getFakeRootNode(), callSiteReference, null);
                if (iMethod != null && (cGNode = this.getTargetForCall(this.callGraph.getFakeRootNode(), callSiteReference, null)) != null && this.callGraph.getPredNodeCount(cGNode) == 0) {
                    SSAInvokeInstruction sSAInvokeInstruction = ((AbstractRootMethod)iClassHierarchyDweller).addInvocation(new int[0], callSiteReference);
                    PointerKey pointerKey = this.getBuilder().getPointerKeyForExceptionalReturnValue(this.callGraph.getFakeRootNode());
                    this.getBuilder().processResolvedCall(this.callGraph.getFakeWorldClinitNode(), sSAInvokeInstruction, cGNode, null, pointerKey);
                }
            }
            if ((iClassHierarchyDweller = iClass.getSuperclass()) != null) {
                this.processClassInitializer((IClass)iClassHierarchyDweller);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class DispatchOperator
    extends UnaryOperator<PointsToSetVariable>
    implements IPointerOperator {
        private final SSAAbstractInvokeInstruction call;
        private final ExplicitCallGraph.ExplicitNode node;
        private final InstanceKey[][] constParams;
        private final PointerKey uniqueCatch;
        private final MutableIntSet previousReceivers = IntSetUtil.getDefaultIntSetFactory().make();

        DispatchOperator(SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction, ExplicitCallGraph.ExplicitNode explicitNode, InstanceKey[][] instanceKeyArray, PointerKey pointerKey) {
            this.call = sSAAbstractInvokeInstruction;
            this.node = explicitNode;
            this.constParams = instanceKeyArray;
            this.uniqueCatch = pointerKey;
        }

        @Override
        public byte evaluate(PointsToSetVariable pointsToSetVariable, PointsToSetVariable pointsToSetVariable2) {
            PointsToSetVariable pointsToSetVariable3 = pointsToSetVariable2;
            final PropagationCallGraphBuilder.MutableBoolean mutableBoolean = new PropagationCallGraphBuilder.MutableBoolean();
            MutableIntSet mutableIntSet = pointsToSetVariable3.getValue();
            if (mutableIntSet == null) {
                return 0;
            }
            IntSetAction intSetAction = new IntSetAction(){

                public void act(int n) {
                    IntSet intSet;
                    InstanceKey instanceKey = ((DispatchOperator)DispatchOperator.this).SSAPropagationCallGraphBuilder.this.system.getInstanceKey(n);
                    CGNode cGNode = SSAPropagationCallGraphBuilder.this.getTargetForCall(DispatchOperator.this.node, DispatchOperator.this.call.getCallSite(), instanceKey);
                    if (!(cGNode == null || (intSet = SSAPropagationCallGraphBuilder.this.getCallGraph().getPossibleTargetNumbers(DispatchOperator.this.node, DispatchOperator.this.call.getCallSite())) != null && intSet.contains(cGNode.getGraphNodeId()))) {
                        mutableBoolean.b = true;
                        SSAPropagationCallGraphBuilder.this.processResolvedCall(DispatchOperator.this.node, DispatchOperator.this.call, cGNode, DispatchOperator.this.constParams, DispatchOperator.this.uniqueCatch);
                        if (!SSAPropagationCallGraphBuilder.this.haveAlreadyVisited(cGNode)) {
                            SSAPropagationCallGraphBuilder.this.markDiscovered(cGNode);
                        }
                    }
                }
            };
            try {
                mutableIntSet.foreachExcluding(this.previousReceivers, intSetAction);
            }
            catch (Error error) {
                System.err.println("error in " + this.call + " on " + pointsToSetVariable3 + " of types " + mutableIntSet + " for " + this.node);
                throw error;
            }
            catch (RuntimeException runtimeException) {
                System.err.println("error in " + this.call + " on " + pointsToSetVariable3 + " of types " + mutableIntSet + " for " + this.node);
                throw runtimeException;
            }
            this.previousReceivers.copySet(mutableIntSet);
            int n = mutableBoolean.b ? 4 : 0;
            return (byte)(0 | n);
        }

        @Override
        public String toString() {
            return "Dispatch to " + this.call + " in node " + this.node;
        }

        @Override
        public int hashCode() {
            return this.node.hashCode() + 90289 * this.call.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof DispatchOperator) {
                DispatchOperator dispatchOperator = (DispatchOperator)object;
                return this.node.equals(dispatchOperator.node) && this.call.equals(dispatchOperator.call);
            }
            return false;
        }

        @Override
        public boolean isComplex() {
            return true;
        }
    }

    private static class FieldResolutionFailure
    extends Warning {
        final FieldReference field;

        FieldResolutionFailure(FieldReference fieldReference) {
            super((byte)2);
            this.field = fieldReference;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.field;
        }

        public static FieldResolutionFailure create(FieldReference fieldReference) {
            return new FieldResolutionFailure(fieldReference);
        }
    }

    protected static class InterestingVisitor
    extends SSAInstruction.Visitor {
        protected final int vn;
        protected boolean bingo = false;

        protected InterestingVisitor(int n) {
            this.vn = n;
        }

        public void visitArrayLoad(SSAArrayLoadInstruction sSAArrayLoadInstruction) {
            if (!sSAArrayLoadInstruction.typeIsPrimitive() && sSAArrayLoadInstruction.getArrayRef() == this.vn) {
                this.bingo = true;
            }
        }

        public void visitArrayStore(SSAArrayStoreInstruction sSAArrayStoreInstruction) {
            if (!(sSAArrayStoreInstruction.typeIsPrimitive() || sSAArrayStoreInstruction.getArrayRef() != this.vn && sSAArrayStoreInstruction.getValue() != this.vn)) {
                this.bingo = true;
            }
        }

        public void visitCheckCast(SSACheckCastInstruction sSACheckCastInstruction) {
            this.bingo = true;
        }

        public void visitGet(SSAGetInstruction sSAGetInstruction) {
            FieldReference fieldReference = sSAGetInstruction.getDeclaredField();
            if (!fieldReference.getFieldType().isPrimitiveType()) {
                this.bingo = true;
            }
        }

        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction sSAGetCaughtExceptionInstruction) {
            this.bingo = true;
        }

        public void visitInvoke(SSAInvokeInstruction sSAInvokeInstruction) {
            this.bingo = true;
        }

        public void visitPhi(SSAPhiInstruction sSAPhiInstruction) {
            this.bingo = true;
        }

        public void visitPi(SSAPiInstruction sSAPiInstruction) {
            this.bingo = true;
        }

        public void visitPut(SSAPutInstruction sSAPutInstruction) {
            FieldReference fieldReference = sSAPutInstruction.getDeclaredField();
            if (!fieldReference.getFieldType().isPrimitiveType()) {
                this.bingo = true;
            }
        }

        public void visitReturn(SSAReturnInstruction sSAReturnInstruction) {
            this.bingo = true;
        }

        public void visitThrow(SSAThrowInstruction sSAThrowInstruction) {
            this.bingo = true;
        }
    }
}

