/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.rta.RTAContextInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.slicer.NormalReturnCallee;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionHandler {
    private static final boolean VERBOSE = false;
    private final PropagationCallGraphBuilder builder;

    public ReflectionHandler(PropagationCallGraphBuilder propagationCallGraphBuilder) {
        this.builder = propagationCallGraphBuilder;
    }

    protected boolean updateForReflection() throws IllegalArgumentException, CancelException {
        Collection<Statement> collection = this.computeFactoryReturnStatements();
        HashSet hashSet = HashSetFactory.make();
        for (Statement object2 : collection) {
            Collection<Statement> collection2 = Slicer.computeForwardSlice(object2, this.builder.callGraph, null, Slicer.DataDependenceOptions.REFLECTION, Slicer.ControlDependenceOptions.NONE);
            Predicate<Statement> predicate = new Predicate<Statement>(){

                @Override
                public boolean test(Statement statement) {
                    if (statement.getKind() == Statement.Kind.NORMAL) {
                        return ((NormalStatement)statement).getInstruction() instanceof SSACheckCastInstruction;
                    }
                    return false;
                }
            };
            List<Statement> list = Predicate.filter(collection2.iterator(), predicate);
            hashSet.addAll(this.modifyFactoryInterpreter(object2, list, this.builder.getContextInterpreter(), this.builder.getClassHierarchy()));
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.builder.addConstraintsFromChangedNode((CGNode)iterator.next());
        }
        return hashSet.size() > 0;
    }

    private Collection<Statement> computeFactoryReturnStatements() {
        HashSet<Statement> hashSet = HashSetFactory.make();
        for (CGNode cGNode : this.builder.getCallGraph()) {
            SyntheticMethod syntheticMethod;
            if (!(cGNode.getMethod() instanceof SyntheticMethod) || !(syntheticMethod = (SyntheticMethod)cGNode.getMethod()).isFactoryMethod()) continue;
            hashSet.add(new NormalReturnCallee(cGNode));
        }
        return hashSet;
    }

    private Set<CGNode> modifyFactoryInterpreter(Statement statement, Collection<Statement> collection, RTAContextInterpreter rTAContextInterpreter, IClassHierarchy iClassHierarchy) {
        HashSet<CGNode> hashSet = HashSetFactory.make();
        for (Statement statement2 : collection) {
            SSACheckCastInstruction sSACheckCastInstruction = (SSACheckCastInstruction)((NormalStatement)statement2).getInstruction();
            TypeReference[] typeReferenceArray = sSACheckCastInstruction.getDeclaredResultTypes();
            int n = typeReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                TypeReference typeReference = typeReferenceArray[n2];
                IClass iClass = iClassHierarchy.lookupClass(typeReference);
                if (iClass != null && rTAContextInterpreter.recordFactoryType(statement.getNode(), iClass)) {
                    hashSet.add(statement.getNode());
                }
                ++n2;
            }
        }
        return hashSet;
    }
}

