/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.util.debug.Assertions;

public class ReceiverInstanceContext
implements Context {
    private final InstanceKey ik;

    public ReceiverInstanceContext(InstanceKey instanceKey) {
        if (instanceKey == null) {
            throw new IllegalArgumentException("null I");
        }
        this.ik = instanceKey;
    }

    public ContextItem get(ContextKey contextKey) {
        if (contextKey == ContextKey.RECEIVER) {
            return this.ik;
        }
        if (contextKey == ContextKey.FILTER) {
            return new FilteredPointerKey.SingleInstanceFilter(this.ik);
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public String toString() {
        return "ReceiverInstanceContext<" + this.ik + ">";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.ik == null ? 0 : this.ik.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReceiverInstanceContext receiverInstanceContext = (ReceiverInstanceContext)object;
        return !(this.ik == null ? receiverInstanceContext.ik != null : !this.ik.equals(receiverInstanceContext.ik));
    }

    public InstanceKey getReceiver() {
        return this.ik;
    }
}

