/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.fixedpoint.impl.AbstractOperator;
import com.ibm.wala.fixedpoint.impl.AbstractStatement;
import com.ibm.wala.fixedpoint.impl.DefaultFixedPointSolver;
import com.ibm.wala.fixedpoint.impl.UnaryOperator;
import com.ibm.wala.fixedpoint.impl.UnaryStatement;
import com.ibm.wala.fixedpoint.impl.Worklist;
import com.ibm.wala.fixpoint.IFixedPointStatement;
import com.ibm.wala.fixpoint.IFixedPointSystem;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AssignEquation;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysisImpl;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.PointsToMap;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.PropagationGraph;
import com.ibm.wala.ipa.callgraph.propagation.UnarySideEffect;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.ClassHierarchyWarning;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.VerboseAction;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.ref.ReferenceCleanser;
import com.ibm.wala.util.warnings.Warnings;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropagationSystem
extends DefaultFixedPointSolver<PointsToSetVariable> {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_MEMORY = false;
    private static int DEBUG_MEM_COUNTER = 0;
    private static final int DEBUG_MEM_INTERVAL = 5;
    protected final PointsToMap pointsToMap = new PointsToMap();
    private final PropagationGraph flowGraph = new PropagationGraph();
    protected final MutableMapping<InstanceKey> instanceKeys = MutableMapping.make();
    private final Map<IClass, MutableIntSet> class2InstanceKey = HashMapFactory.make();
    private PointerAnalysis pointerAnalysis;
    private final PointerKeyFactory pointerKeyFactory;
    private final InstanceKeyFactory instanceKeyFactory;
    private final Map<PointsToSetVariable, Set<UnarySideEffect>> fixedSetMap = HashMapFactory.make();
    protected final CallGraph cg;
    private int verboseInterval = 100000;
    private int periodicMaintainInterval = 100000;

    public PropagationSystem(CallGraph callGraph, PointerKeyFactory pointerKeyFactory, InstanceKeyFactory instanceKeyFactory) {
        if (callGraph == null) {
            throw new IllegalArgumentException("null cg");
        }
        this.cg = callGraph;
        this.pointerKeyFactory = pointerKeyFactory;
        this.instanceKeyFactory = instanceKeyFactory;
    }

    public PointerAnalysis makePointerAnalysis(PropagationCallGraphBuilder propagationCallGraphBuilder) {
        return new PointerAnalysisImpl(propagationCallGraphBuilder, this.cg, this.pointsToMap, this.instanceKeys, this.pointerKeyFactory, this.instanceKeyFactory);
    }

    protected void registerFixedSet(PointsToSetVariable pointsToSetVariable, UnarySideEffect unarySideEffect) {
        Set<UnarySideEffect> set = MapUtil.findOrCreateSet(this.fixedSetMap, pointsToSetVariable);
        set.add(unarySideEffect);
    }

    protected void updateSideEffects(PointsToSetVariable pointsToSetVariable, PointsToSetVariable pointsToSetVariable2) {
        Set<UnarySideEffect> set = this.fixedSetMap.get(pointsToSetVariable);
        if (set != null) {
            for (UnarySideEffect unarySideEffect : set) {
                unarySideEffect.replaceFixedSet(pointsToSetVariable2);
            }
            Set<UnarySideEffect> set2 = MapUtil.findOrCreateSet(this.fixedSetMap, pointsToSetVariable2);
            set2.addAll(set);
            this.fixedSetMap.remove(pointsToSetVariable);
        }
    }

    private MutableIntSet findOrCreateSparseSetForClass(IClass iClass) {
        assert (iClass.getReference() != TypeReference.JavaLangObject);
        MutableIntSet mutableIntSet = this.class2InstanceKey.get(iClass);
        if (mutableIntSet == null) {
            mutableIntSet = IntSetUtil.getDefaultIntSetFactory().make();
            this.class2InstanceKey.put(iClass, mutableIntSet);
        }
        return mutableIntSet;
    }

    MutableIntSet cloneInstanceKeysForClass(IClass iClass) {
        assert (iClass.getReference() != TypeReference.JavaLangObject);
        MutableIntSet mutableIntSet = this.class2InstanceKey.get(iClass);
        if (mutableIntSet == null) {
            return IntSetUtil.getDefaultIntSetFactory().make();
        }
        return IntSetUtil.getDefaultIntSetFactory().makeCopy(mutableIntSet);
    }

    public IntSet getInstanceKeysForClass(IClass iClass) {
        if (iClass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        assert (iClass.getReference() != TypeReference.JavaLangObject);
        return this.class2InstanceKey.get(iClass);
    }

    public InstanceKey getInstanceKey(int n) {
        return this.instanceKeys.getMappedObject(n);
    }

    List<InstanceKey> getInstances(IntSet intSet) {
        LinkedList<InstanceKey> linkedList = new LinkedList<InstanceKey>();
        int n = 0;
        IntIterator intIterator = intSet.intIterator();
        while (intIterator.hasNext()) {
            int n2 = intIterator.next();
            linkedList.add(this.getInstanceKey(n2));
            ++n;
        }
        return linkedList;
    }

    @Override
    protected void initializeVariables() {
    }

    public void recordImplicitPointsToSet(PointerKey pointerKey) {
        LocalPointerKey localPointerKey;
        if (pointerKey == null) {
            throw new IllegalArgumentException("null key");
        }
        if (pointerKey instanceof LocalPointerKey && (localPointerKey = (LocalPointerKey)pointerKey).isParameter()) {
            System.err.println(localPointerKey);
            System.err.println("Constant? " + localPointerKey.getNode().getIR().getSymbolTable().isConstant(localPointerKey.getValueNumber()));
            System.err.println(localPointerKey.getNode().getIR());
            Assertions.UNREACHABLE("How can parameter be implicit?");
        }
        this.pointsToMap.recordImplicit(pointerKey);
    }

    public PointsToSetVariable findOrCreatePointsToSet(PointerKey pointerKey) {
        PointsToSetVariable pointsToSetVariable;
        if (pointerKey == null) {
            throw new IllegalArgumentException("null key");
        }
        if (this.pointsToMap.isImplicit(pointerKey)) {
            System.err.println("Did not expect to findOrCreatePointsToSet for implicitly represented PointerKey");
            System.err.println(pointerKey);
            Assertions.UNREACHABLE();
        }
        if ((pointsToSetVariable = this.pointsToMap.getPointsToSet(pointerKey)) == null) {
            pointsToSetVariable = new PointsToSetVariable(pointerKey);
            this.pointsToMap.put(pointerKey, pointsToSetVariable);
        } else if (!this.pointsToMap.isUnified(pointerKey) && pointerKey instanceof FilteredPointerKey) {
            FilteredPointerKey filteredPointerKey;
            PointerKey pointerKey2 = pointsToSetVariable.getPointerKey();
            if (!(pointerKey2 instanceof FilteredPointerKey)) {
                pointsToSetVariable.setPointerKey(pointerKey);
                pointerKey2 = pointerKey;
            }
            if ((filteredPointerKey = (FilteredPointerKey)pointerKey2) == null) {
                // empty if block
            }
            if (pointerKey == null) {
                // empty if block
            }
            if (filteredPointerKey.getTypeFilter() == null) {
                Assertions.UNREACHABLE("fpk.getTypeFilter() is null");
            }
            if (!filteredPointerKey.getTypeFilter().equals(((FilteredPointerKey)pointerKey).getTypeFilter())) {
                Assertions.UNREACHABLE("Cannot use filter " + ((FilteredPointerKey)pointerKey).getTypeFilter() + " for " + pointerKey + ": previously created different filter " + filteredPointerKey.getTypeFilter());
            }
        }
        return pointsToSetVariable;
    }

    public int findOrCreateIndexForInstanceKey(InstanceKey instanceKey) {
        int n = this.instanceKeys.getMappedIndex(instanceKey);
        if (n == -1) {
            n = this.instanceKeys.add(instanceKey);
        }
        return n;
    }

    public boolean newConstraint(PointerKey pointerKey, UnaryOperator<PointsToSetVariable> unaryOperator, PointerKey pointerKey2) {
        if (pointerKey == null) {
            throw new IllegalArgumentException("null lhs");
        }
        if (unaryOperator == null) {
            throw new IllegalArgumentException("op null");
        }
        if (pointerKey2 == null) {
            throw new IllegalArgumentException("rhs null");
        }
        PointsToSetVariable pointsToSetVariable = this.findOrCreatePointsToSet(pointerKey);
        PointsToSetVariable pointsToSetVariable2 = this.findOrCreatePointsToSet(pointerKey2);
        if (unaryOperator instanceof PropagationCallGraphBuilder.FilterOperator) {
            this.pointsToMap.recordTransitiveRoot(pointsToSetVariable.getPointerKey());
            if (!(pointsToSetVariable.getPointerKey() instanceof FilteredPointerKey)) {
                Assertions.UNREACHABLE("expected filtered lhs " + pointsToSetVariable.getPointerKey() + " " + pointsToSetVariable.getPointerKey().getClass() + " " + pointerKey + " " + pointerKey.getClass());
            }
        }
        return this.newStatement(pointsToSetVariable, unaryOperator, pointsToSetVariable2, true, true);
    }

    public void newConstraint(PointerKey pointerKey, AbstractOperator<PointsToSetVariable> abstractOperator, PointerKey pointerKey2) {
        if (pointerKey == null) {
            throw new IllegalArgumentException("lhs null");
        }
        if (abstractOperator == null) {
            throw new IllegalArgumentException("op null");
        }
        if (pointerKey2 == null) {
            throw new IllegalArgumentException("rhs null");
        }
        assert (!this.pointsToMap.isUnified(pointerKey));
        assert (!this.pointsToMap.isUnified(pointerKey2));
        PointsToSetVariable pointsToSetVariable = this.findOrCreatePointsToSet(pointerKey);
        PointsToSetVariable pointsToSetVariable2 = this.findOrCreatePointsToSet(pointerKey2);
        this.newStatement(pointsToSetVariable, abstractOperator, new PointsToSetVariable[]{pointsToSetVariable2}, true, true);
    }

    public void newConstraint(PointerKey pointerKey, AbstractOperator<PointsToSetVariable> abstractOperator, PointerKey pointerKey2, PointerKey pointerKey3) {
        if (pointerKey == null) {
            throw new IllegalArgumentException("null lhs");
        }
        if (abstractOperator == null) {
            throw new IllegalArgumentException("null op");
        }
        if (pointerKey2 == null) {
            throw new IllegalArgumentException("null rhs1");
        }
        if (pointerKey3 == null) {
            throw new IllegalArgumentException("null rhs2");
        }
        assert (!this.pointsToMap.isUnified(pointerKey));
        assert (!this.pointsToMap.isUnified(pointerKey2));
        assert (!this.pointsToMap.isUnified(pointerKey3));
        PointsToSetVariable pointsToSetVariable = this.findOrCreatePointsToSet(pointerKey);
        PointsToSetVariable pointsToSetVariable2 = this.findOrCreatePointsToSet(pointerKey2);
        PointsToSetVariable pointsToSetVariable3 = this.findOrCreatePointsToSet(pointerKey3);
        this.newStatement(pointsToSetVariable, abstractOperator, pointsToSetVariable2, pointsToSetVariable3, true, true);
    }

    public boolean newFieldWrite(PointerKey pointerKey, UnaryOperator<PointsToSetVariable> unaryOperator, PointerKey pointerKey2, PointerKey pointerKey3) {
        return this.newConstraint(pointerKey, unaryOperator, pointerKey2);
    }

    public boolean newFieldRead(PointerKey pointerKey, UnaryOperator<PointsToSetVariable> unaryOperator, PointerKey pointerKey2, PointerKey pointerKey3) {
        return this.newConstraint(pointerKey, unaryOperator, pointerKey2);
    }

    public boolean newConstraint(PointerKey pointerKey, InstanceKey instanceKey) {
        this.pointsToMap.recordTransitiveRoot(pointerKey);
        PointsToSetVariable pointsToSetVariable = this.findOrCreatePointsToSet(pointerKey);
        int n = this.findOrCreateIndexForInstanceKey(instanceKey);
        if (pointsToSetVariable.contains(n)) {
            return false;
        }
        pointsToSetVariable.add(n);
        assert (instanceKey.getConcreteType() != null);
        if (!instanceKey.getConcreteType().getReference().equals(TypeReference.JavaLangObject)) {
            this.registerInstanceOfClass(instanceKey.getConcreteType(), n);
        }
        if (pointsToSetVariable.getGraphNodeId() > -1) {
            this.changedVariable(pointsToSetVariable);
        }
        return true;
    }

    private void registerInstanceOfClass(IClass iClass, int n) {
        assert (!iClass.getReference().equals(TypeReference.JavaLangObject));
        try {
            IClass iClass2 = iClass;
            this.registerInstanceWithAllSuperclasses(n, iClass2);
            this.registerInstanceWithAllInterfaces(iClass, n);
            if (iClass.isArrayClass()) {
                ArrayClass arrayClass = (ArrayClass)iClass;
                int n2 = arrayClass.getDimensionality();
                this.registerMultiDimArraysForArrayOfObjectTypes(n2, n, arrayClass);
                IClass iClass3 = arrayClass.getInnermostElementClass();
                if (iClass3 != null) {
                    this.registerArrayInstanceWithAllSuperclassesOfElement(n, iClass3, n2);
                    this.registerArrayInstanceWithAllInterfacesOfElement(n, iClass3, n2);
                }
            }
        }
        catch (ClassHierarchyException classHierarchyException) {
            Warnings.add(ClassHierarchyWarning.create(classHierarchyException.getMessage()));
        }
    }

    private int registerMultiDimArraysForArrayOfObjectTypes(int n, int n2, ArrayClass arrayClass) {
        int n3 = 1;
        while (n3 < n) {
            TypeReference typeReference = this.makeArray(TypeReference.JavaLangObject, n3);
            IClass iClass = null;
            iClass = arrayClass.getClassLoader().lookupClass(typeReference.getName());
            MutableIntSet mutableIntSet = this.findOrCreateSparseSetForClass(iClass);
            mutableIntSet.add(n2);
            ++n3;
        }
        return n;
    }

    private void registerArrayInstanceWithAllInterfacesOfElement(int n, IClass iClass, int n2) {
        Collection<IClass> collection = null;
        collection = iClass.getAllImplementedInterfaces();
        for (IClass iClass2 : collection) {
            TypeReference typeReference = this.makeArray(iClass2.getReference(), n2);
            IClass iClass3 = null;
            iClass3 = iClass2.getClassLoader().lookupClass(typeReference.getName());
            MutableIntSet mutableIntSet = this.findOrCreateSparseSetForClass(iClass3);
            mutableIntSet.add(n);
        }
    }

    private TypeReference makeArray(TypeReference typeReference, int n) {
        TypeReference typeReference2 = typeReference;
        int n2 = 0;
        while (n2 < n) {
            typeReference2 = TypeReference.findOrCreateArrayOf(typeReference2);
            ++n2;
        }
        return typeReference2;
    }

    private void registerArrayInstanceWithAllSuperclassesOfElement(int n, IClass iClass, int n2) throws ClassHierarchyException {
        IClass iClass2 = iClass.getSuperclass();
        while (iClass2 != null) {
            TypeReference typeReference = this.makeArray(iClass2.getReference(), n2);
            IClass iClass3 = null;
            iClass3 = iClass2.getClassLoader().lookupClass(typeReference.getName());
            MutableIntSet mutableIntSet = this.findOrCreateSparseSetForClass(iClass3);
            mutableIntSet.add(n);
            iClass2 = iClass2.getSuperclass();
        }
    }

    private void registerInstanceWithAllInterfaces(IClass iClass, int n) throws ClassHierarchyException {
        Collection<IClass> collection = iClass.getAllImplementedInterfaces();
        for (IClass iClass2 : collection) {
            MutableIntSet mutableIntSet = this.findOrCreateSparseSetForClass(iClass2);
            mutableIntSet.add(n);
        }
    }

    private void registerInstanceWithAllSuperclasses(int n, IClass iClass) throws ClassHierarchyException {
        while (iClass != null && !iClass.getReference().equals(TypeReference.JavaLangObject)) {
            MutableIntSet mutableIntSet = this.findOrCreateSparseSetForClass(iClass);
            mutableIntSet.add(n);
            iClass = iClass.getSuperclass();
        }
    }

    public void newSideEffect(UnaryOperator<PointsToSetVariable> unaryOperator, PointerKey pointerKey) {
        if (pointerKey == null) {
            throw new IllegalArgumentException("null arg0");
        }
        assert (!this.pointsToMap.isUnified(pointerKey));
        PointsToSetVariable pointsToSetVariable = this.findOrCreatePointsToSet(pointerKey);
        this.newStatement(null, unaryOperator, pointsToSetVariable, true, true);
    }

    public void newSideEffect(AbstractOperator<PointsToSetVariable> abstractOperator, PointerKey pointerKey, PointerKey pointerKey2) {
        assert (!this.pointsToMap.isUnified(pointerKey));
        assert (!this.pointsToMap.isUnified(pointerKey2));
        PointsToSetVariable pointsToSetVariable = this.findOrCreatePointsToSet(pointerKey);
        PointsToSetVariable pointsToSetVariable2 = this.findOrCreatePointsToSet(pointerKey2);
        this.newStatement(null, abstractOperator, pointsToSetVariable, pointsToSetVariable2, true, true);
    }

    @Override
    protected void initializeWorkList() {
        this.addAllStatementsToWorkList();
    }

    public PointerAnalysis extractPointerAnalysis(PropagationCallGraphBuilder propagationCallGraphBuilder) {
        if (this.pointerAnalysis == null) {
            this.pointerAnalysis = this.makePointerAnalysis(propagationCallGraphBuilder);
        }
        return this.pointerAnalysis;
    }

    @Override
    public void performVerboseAction() {
        super.performVerboseAction();
        if (this.getFixedPointSystem() instanceof VerboseAction) {
            ((VerboseAction)((Object)this.getFixedPointSystem())).performVerboseAction();
        }
        AbstractStatement abstractStatement = this.workList.takeStatement();
        System.err.println(this.printRHSInstances(abstractStatement));
        this.workList.insertStatement(abstractStatement);
        System.err.println("CGNodes: " + this.cg.getNumberOfNodes());
    }

    private String printRHSInstances(AbstractStatement abstractStatement) {
        if (abstractStatement instanceof UnaryStatement) {
            UnaryStatement unaryStatement = (UnaryStatement)abstractStatement;
            PointsToSetVariable pointsToSetVariable = (PointsToSetVariable)unaryStatement.getRightHandSide();
            MutableIntSet mutableIntSet = pointsToSetVariable.getValue();
            final int[] nArray = new int[5];
            mutableIntSet.foreach(new IntSetAction(){

                public void act(int n) {
                    int n2 = 0;
                    while (n2 < 4) {
                        nArray[n2] = nArray[n2 + 1];
                        ++n2;
                    }
                    nArray[4] = n;
                }
            });
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < 5) {
                int n2 = nArray[n];
                if (n2 != 0) {
                    InstanceKey instanceKey = this.getInstanceKey(n2);
                    stringBuffer.append(n2).append("  ").append(instanceKey).append("\n");
                }
                ++n;
            }
            return stringBuffer.toString();
        }
        return abstractStatement.getClass().toString();
    }

    @Override
    public IFixedPointSystem<PointsToSetVariable> getFixedPointSystem() {
        return this.flowGraph;
    }

    public Iterator<PointerKey> iteratePointerKeys() {
        return this.pointsToMap.iterateKeys();
    }

    public int getNumberOfPointerKeys() {
        return this.pointsToMap.getNumberOfPointerKeys();
    }

    Worklist getWorklist() {
        return this.workList;
    }

    public Iterator<AbstractStatement> getStatementsThatUse(PointsToSetVariable pointsToSetVariable) {
        return this.flowGraph.getStatementsThatUse(pointsToSetVariable);
    }

    public Iterator<AbstractStatement> getStatementsThatDef(PointsToSetVariable pointsToSetVariable) {
        return this.flowGraph.getStatementsThatDef(pointsToSetVariable);
    }

    public NumberedGraph<PointsToSetVariable> getAssignmentGraph() {
        return this.flowGraph.getAssignmentGraph();
    }

    public Graph<PointsToSetVariable> getFilterAsssignmentGraph() {
        return this.flowGraph.getFilterAssignmentGraph();
    }

    public Graph<PointsToSetVariable> getFlowGraphIncludingImplicitConstraints() {
        return this.flowGraph.getFlowGraphIncludingImplicitConstraints();
    }

    public void revertToPreTransitive() {
        this.pointsToMap.revertToPreTransitive();
    }

    public Iterator getTransitiveRoots() {
        return this.pointsToMap.getTransitiveRoots();
    }

    public boolean isTransitiveRoot(PointerKey pointerKey) {
        return this.pointsToMap.isTransitiveRoot(pointerKey);
    }

    @Override
    protected void periodicMaintenance() {
        super.periodicMaintenance();
        ReferenceCleanser.clearSoftCaches();
    }

    @Override
    public int getVerboseInterval() {
        return this.verboseInterval;
    }

    public void setVerboseInterval(int n) {
        this.verboseInterval = n;
    }

    @Override
    public int getPeriodicMaintainInterval() {
        return this.periodicMaintainInterval;
    }

    public void setPeriodicMaintainInterval(int n) {
        this.periodicMaintainInterval = n;
    }

    public void unify(IntSet intSet) {
        if (intSet == null) {
            throw new IllegalArgumentException("s is null");
        }
        HashSet<PointsToSetVariable> hashSet = HashSetFactory.make(intSet.size());
        IntIterator intIterator = intSet.intIterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            hashSet.add(this.pointsToMap.getPointsToSet(n));
        }
        this.pointsToMap.unify(intSet);
        int n = this.pointsToMap.getRepresentative(intSet.intIterator().next());
        this.updateEquationsForUnification(hashSet, n);
        this.updateSideEffectsForUnification(hashSet, n);
    }

    private void updateSideEffectsForUnification(HashSet<PointsToSetVariable> hashSet, int n) {
        PointsToSetVariable pointsToSetVariable = this.pointsToMap.getPointsToSet(n);
        for (PointsToSetVariable pointsToSetVariable2 : hashSet) {
            this.updateSideEffects(pointsToSetVariable2, pointsToSetVariable);
        }
    }

    private void updateEquationsForUnification(HashSet<PointsToSetVariable> hashSet, int n) {
        PointsToSetVariable pointsToSetVariable = this.pointsToMap.getPointsToSet(n);
        for (PointsToSetVariable pointsToSetVariable2 : hashSet) {
            int n2;
            PointsToSetVariable pointsToSetVariable3;
            AssignEquation assignEquation;
            if (pointsToSetVariable2 == pointsToSetVariable) continue;
            for (AbstractStatement abstractStatement : Iterator2Collection.toSet(this.getStatementsThatDef(pointsToSetVariable2))) {
                if (abstractStatement instanceof AssignEquation) {
                    assignEquation = (AssignEquation)abstractStatement;
                    pointsToSetVariable3 = (PointsToSetVariable)assignEquation.getRightHandSide();
                    n2 = this.pointsToMap.getRepresentative(this.pointsToMap.getIndex(pointsToSetVariable3.getPointerKey()));
                    if (n2 == n) {
                        this.flowGraph.removeStatement(abstractStatement);
                        continue;
                    }
                    this.replaceLHS(pointsToSetVariable, pointsToSetVariable2, abstractStatement);
                    continue;
                }
                this.replaceLHS(pointsToSetVariable, pointsToSetVariable2, abstractStatement);
            }
            for (AbstractStatement abstractStatement : Iterator2Collection.toSet(this.getStatementsThatUse(pointsToSetVariable2))) {
                if (abstractStatement instanceof AssignEquation) {
                    assignEquation = (AssignEquation)abstractStatement;
                    pointsToSetVariable3 = (PointsToSetVariable)assignEquation.getLHS();
                    n2 = this.pointsToMap.getRepresentative(this.pointsToMap.getIndex(pointsToSetVariable3.getPointerKey()));
                    if (n2 == n) {
                        this.flowGraph.removeStatement(abstractStatement);
                        continue;
                    }
                    this.replaceRHS(pointsToSetVariable, pointsToSetVariable2, abstractStatement);
                    continue;
                }
                this.replaceRHS(pointsToSetVariable, pointsToSetVariable2, abstractStatement);
            }
            if (this.flowGraph.getNumberOfStatementsThatDef(pointsToSetVariable2) != 0 || this.flowGraph.getNumberOfStatementsThatUse(pointsToSetVariable2) != 0) continue;
            this.flowGraph.removeVariable(pointsToSetVariable2);
        }
    }

    private void replaceRHS(PointsToSetVariable pointsToSetVariable, PointsToSetVariable pointsToSetVariable2, AbstractStatement<PointsToSetVariable, AbstractOperator<PointsToSetVariable>> abstractStatement) {
        if (abstractStatement instanceof UnaryStatement) {
            assert (((UnaryStatement)abstractStatement).getRightHandSide() == pointsToSetVariable2);
            this.newStatement((PointsToSetVariable)abstractStatement.getLHS(), (UnaryOperator)abstractStatement.getOperator(), pointsToSetVariable, false, false);
        } else {
            IVariable[] iVariableArray = abstractStatement.getRHS();
            IVariable[] iVariableArray2 = new PointsToSetVariable[iVariableArray.length];
            int n = 0;
            while (n < iVariableArray.length) {
                iVariableArray2[n] = iVariableArray[n].equals(pointsToSetVariable2) ? pointsToSetVariable : (PointsToSetVariable)iVariableArray[n];
                ++n;
            }
            this.newStatement((PointsToSetVariable)abstractStatement.getLHS(), abstractStatement.getOperator(), iVariableArray2, false, false);
        }
        this.flowGraph.removeStatement((IFixedPointStatement<PointsToSetVariable>)abstractStatement);
    }

    private void replaceLHS(PointsToSetVariable pointsToSetVariable, PointsToSetVariable pointsToSetVariable2, AbstractStatement<PointsToSetVariable, AbstractOperator<PointsToSetVariable>> abstractStatement) {
        assert (abstractStatement.getLHS() == pointsToSetVariable2);
        if (abstractStatement instanceof UnaryStatement) {
            this.newStatement(pointsToSetVariable, (UnaryOperator)abstractStatement.getOperator(), (PointsToSetVariable)((UnaryStatement)abstractStatement).getRightHandSide(), false, false);
        } else {
            this.newStatement(pointsToSetVariable, abstractStatement.getOperator(), abstractStatement.getRHS(), false, false);
        }
        this.flowGraph.removeStatement((IFixedPointStatement<PointsToSetVariable>)abstractStatement);
    }

    public boolean isUnified(PointerKey pointerKey) {
        return this.pointsToMap.isUnified(pointerKey);
    }

    public int getNumber(PointerKey pointerKey) {
        return this.pointsToMap.getIndex(pointerKey);
    }
}

