/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.fixedpoint.impl.AbstractOperator;
import com.ibm.wala.fixedpoint.impl.AbstractStatement;
import com.ibm.wala.fixedpoint.impl.GeneralStatement;
import com.ibm.wala.fixedpoint.impl.UnaryOperator;
import com.ibm.wala.fixedpoint.impl.UnaryStatement;
import com.ibm.wala.fixpoint.IFixedPointStatement;
import com.ibm.wala.fixpoint.IFixedPointSystem;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.ipa.callgraph.propagation.AssignEquation;
import com.ibm.wala.ipa.callgraph.propagation.AssignOperator;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.util.collections.CompoundIterator;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.SmallMap;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.INodeWithNumber;
import com.ibm.wala.util.graph.NodeManager;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.DelegatingNumberedNodeManager;
import com.ibm.wala.util.graph.impl.SparseNumberedEdgeManager;
import com.ibm.wala.util.graph.traverse.Topological;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntPair;
import com.ibm.wala.util.intset.IntSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropagationGraph
implements IFixedPointSystem<PointsToSetVariable> {
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE = false;
    private final NumberedNodeManager<INodeWithNumber> nodeManager = new DelegatingNumberedNodeManager<INodeWithNumber>();
    private final EdgeManager<INodeWithNumber> edgeManager = new SparseNumberedEdgeManager<INodeWithNumber>(this.nodeManager, 2, 0);
    private final DelegateGraph delegateGraph = new DelegateGraph();
    private final HashSet<AbstractStatement> delegateStatements = HashSetFactory.make();
    private final SmallMap<UnaryOperator<PointsToSetVariable>, IBinaryNaturalRelation> implicitUnaryMap = new SmallMap();
    private final SmallMap<UnaryOperator<PointsToSetVariable>, IBinaryNaturalRelation> invImplicitUnaryMap = new SmallMap();
    private int implicitUnaryCount = 0;

    private IBinaryNaturalRelation findOrCreateRelation(Map<UnaryOperator<PointsToSetVariable>, IBinaryNaturalRelation> map, UnaryOperator<PointsToSetVariable> unaryOperator) {
        IBinaryNaturalRelation iBinaryNaturalRelation = map.get(unaryOperator);
        if (iBinaryNaturalRelation == null) {
            iBinaryNaturalRelation = this.makeRelation(unaryOperator);
            map.put(unaryOperator, iBinaryNaturalRelation);
        }
        return iBinaryNaturalRelation;
    }

    private IBinaryNaturalRelation makeRelation(AbstractOperator abstractOperator) {
        byte[] byArray = null;
        byArray = abstractOperator instanceof AssignOperator ? new byte[]{2, 2} : new byte[]{2};
        return new BasicNaturalRelation(byArray, 0);
    }

    @Override
    public void addStatement(GeneralStatement<PointsToSetVariable> generalStatement) {
        if (generalStatement == null) {
            throw new IllegalArgumentException("eq is null");
        }
        PointsToSetVariable pointsToSetVariable = generalStatement.getLHS();
        this.delegateGraph.addEquation(generalStatement);
        this.delegateStatements.add(generalStatement);
        if (pointsToSetVariable != null) {
            this.delegateGraph.addVariable(pointsToSetVariable);
            this.delegateGraph.addEdge(generalStatement, pointsToSetVariable);
        }
        int n = 0;
        while (n < generalStatement.getRHS().length) {
            PointsToSetVariable pointsToSetVariable2 = (PointsToSetVariable)generalStatement.getRHS()[n];
            if (pointsToSetVariable2 != null) {
                this.delegateGraph.addVariable(pointsToSetVariable2);
                this.delegateGraph.addEdge(pointsToSetVariable2, generalStatement);
            }
            ++n;
        }
    }

    @Override
    public void addStatement(UnaryStatement<PointsToSetVariable> unaryStatement) throws IllegalArgumentException {
        if (unaryStatement == null) {
            throw new IllegalArgumentException("eq == null");
        }
        if (this.useImplicitRepresentation(unaryStatement)) {
            this.addImplicitStatement(unaryStatement);
        } else {
            PointsToSetVariable pointsToSetVariable = unaryStatement.getLHS();
            PointsToSetVariable pointsToSetVariable2 = unaryStatement.getRightHandSide();
            this.delegateGraph.addEquation(unaryStatement);
            this.delegateStatements.add(unaryStatement);
            if (pointsToSetVariable != null) {
                this.delegateGraph.addVariable(pointsToSetVariable);
                this.delegateGraph.addEdge(unaryStatement, pointsToSetVariable);
            }
            this.delegateGraph.addVariable(pointsToSetVariable2);
            this.delegateGraph.addEdge(pointsToSetVariable2, unaryStatement);
        }
    }

    private boolean useImplicitRepresentation(IFixedPointStatement iFixedPointStatement) {
        AbstractStatement abstractStatement = (AbstractStatement)iFixedPointStatement;
        Object o = abstractStatement.getOperator();
        return o instanceof AssignOperator || o instanceof PropagationCallGraphBuilder.FilterOperator;
    }

    public void removeVariable(PointsToSetVariable pointsToSetVariable) {
        assert (this.getNumberOfStatementsThatDef(pointsToSetVariable) == 0);
        assert (this.getNumberOfStatementsThatUse(pointsToSetVariable) == 0);
        this.delegateGraph.removeNode(pointsToSetVariable);
    }

    private void addImplicitStatement(UnaryStatement<PointsToSetVariable> unaryStatement) {
        this.delegateGraph.addVariable(unaryStatement.getLHS());
        this.delegateGraph.addVariable(unaryStatement.getRightHandSide());
        int n = unaryStatement.getLHS().getGraphNodeId();
        int n2 = unaryStatement.getRightHandSide().getGraphNodeId();
        IBinaryNaturalRelation iBinaryNaturalRelation = this.findOrCreateRelation(this.implicitUnaryMap, (UnaryOperator)unaryStatement.getOperator());
        boolean bl = iBinaryNaturalRelation.add(n, n2);
        if (bl) {
            ++this.implicitUnaryCount;
            IBinaryNaturalRelation iBinaryNaturalRelation2 = this.findOrCreateRelation(this.invImplicitUnaryMap, (UnaryOperator)unaryStatement.getOperator());
            iBinaryNaturalRelation2.add(n2, n);
        }
    }

    private void removeImplicitStatement(UnaryStatement<PointsToSetVariable> unaryStatement) {
        int n = unaryStatement.getLHS().getGraphNodeId();
        int n2 = unaryStatement.getRightHandSide().getGraphNodeId();
        IBinaryNaturalRelation iBinaryNaturalRelation = this.findOrCreateRelation(this.implicitUnaryMap, (UnaryOperator)unaryStatement.getOperator());
        iBinaryNaturalRelation.remove(n, n2);
        IBinaryNaturalRelation iBinaryNaturalRelation2 = this.findOrCreateRelation(this.invImplicitUnaryMap, (UnaryOperator)unaryStatement.getOperator());
        iBinaryNaturalRelation2.remove(n2, n);
        --this.implicitUnaryCount;
    }

    @Override
    public Iterator<AbstractStatement> getStatements() {
        FilterIterator filterIterator = new FilterIterator(this.delegateGraph.iterator(), new Filter(){

            public boolean accepts(Object object) {
                return object instanceof AbstractStatement;
            }
        });
        return new CompoundIterator<AbstractStatement>(filterIterator, new GlobalImplicitIterator());
    }

    @Override
    public void removeStatement(IFixedPointStatement<PointsToSetVariable> iFixedPointStatement) throws IllegalArgumentException {
        if (iFixedPointStatement == null) {
            throw new IllegalArgumentException("eq == null");
        }
        if (this.useImplicitRepresentation(iFixedPointStatement)) {
            this.removeImplicitStatement((UnaryStatement)iFixedPointStatement);
        } else {
            this.delegateStatements.remove(iFixedPointStatement);
            this.delegateGraph.removeNodeAndEdges(iFixedPointStatement);
        }
    }

    @Override
    public void reorder() {
        VariableGraphView variableGraphView = new VariableGraphView();
        Iterator<PointsToSetVariable> iterator = Topological.makeTopologicalIter(variableGraphView);
        int n = 0;
        while (iterator.hasNext()) {
            PointsToSetVariable pointsToSetVariable = iterator.next();
            if (!(pointsToSetVariable instanceof IVariable)) continue;
            IVariable iVariable = pointsToSetVariable;
            iVariable.setOrderNumber(n++);
        }
    }

    @Override
    public Iterator<AbstractStatement> getStatementsThatUse(PointsToSetVariable pointsToSetVariable) {
        if (pointsToSetVariable == null) {
            throw new IllegalArgumentException("v is null");
        }
        int n = pointsToSetVariable.getGraphNodeId();
        if (n == -1) {
            return EmptyIterator.instance();
        }
        Iterator<PointsToSetVariable> iterator = this.delegateGraph.getSuccNodes(pointsToSetVariable);
        int n2 = 0;
        while (n2 < this.invImplicitUnaryMap.size()) {
            UnaryOperator<PointsToSetVariable> unaryOperator = this.invImplicitUnaryMap.getKey(n2);
            IBinaryNaturalRelation iBinaryNaturalRelation = (IBinaryNaturalRelation)this.invImplicitUnaryMap.getValue(n2);
            IntSet intSet = iBinaryNaturalRelation.getRelated(n);
            if (intSet != null) {
                iterator = new CompoundIterator<PointsToSetVariable>(new ImplicitUseIterator(unaryOperator, pointsToSetVariable, intSet), iterator);
            }
            ++n2;
        }
        ArrayList<AbstractStatement> arrayList = new ArrayList<AbstractStatement>();
        while (iterator.hasNext()) {
            arrayList.add((AbstractStatement)((Object)iterator.next()));
        }
        return arrayList.iterator();
    }

    @Override
    public Iterator<AbstractStatement> getStatementsThatDef(PointsToSetVariable pointsToSetVariable) {
        if (pointsToSetVariable == null) {
            throw new IllegalArgumentException("v is null");
        }
        int n = pointsToSetVariable.getGraphNodeId();
        if (n == -1) {
            return EmptyIterator.instance();
        }
        Iterator<PointsToSetVariable> iterator = this.delegateGraph.getPredNodes(pointsToSetVariable);
        int n2 = 0;
        while (n2 < this.implicitUnaryMap.size()) {
            UnaryOperator<PointsToSetVariable> unaryOperator = this.implicitUnaryMap.getKey(n2);
            IBinaryNaturalRelation iBinaryNaturalRelation = (IBinaryNaturalRelation)this.implicitUnaryMap.getValue(n2);
            IntSet intSet = iBinaryNaturalRelation.getRelated(n);
            if (intSet != null) {
                iterator = new CompoundIterator<PointsToSetVariable>(new ImplicitDefIterator(unaryOperator, intSet, pointsToSetVariable), iterator);
            }
            ++n2;
        }
        ArrayList<AbstractStatement> arrayList = new ArrayList<AbstractStatement>();
        while (iterator.hasNext()) {
            arrayList.add((AbstractStatement)((Object)iterator.next()));
        }
        return arrayList.iterator();
    }

    @Override
    public int getNumberOfStatementsThatUse(PointsToSetVariable pointsToSetVariable) {
        if (pointsToSetVariable == null) {
            throw new IllegalArgumentException("v is null");
        }
        int n = pointsToSetVariable.getGraphNodeId();
        if (n == -1) {
            return 0;
        }
        int n2 = this.delegateGraph.getSuccNodeCount(pointsToSetVariable);
        for (UnaryOperator<PointsToSetVariable> unaryOperator : this.invImplicitUnaryMap.keySet()) {
            IBinaryNaturalRelation iBinaryNaturalRelation = this.invImplicitUnaryMap.get(unaryOperator);
            IntSet intSet = iBinaryNaturalRelation.getRelated(n);
            if (intSet == null) continue;
            n2 += intSet.size();
        }
        return n2;
    }

    @Override
    public int getNumberOfStatementsThatDef(PointsToSetVariable pointsToSetVariable) {
        if (pointsToSetVariable == null) {
            throw new IllegalArgumentException("v is null");
        }
        int n = pointsToSetVariable.getGraphNodeId();
        if (n == -1) {
            return 0;
        }
        int n2 = this.delegateGraph.getPredNodeCount(pointsToSetVariable);
        for (UnaryOperator<PointsToSetVariable> unaryOperator : this.implicitUnaryMap.keySet()) {
            IBinaryNaturalRelation iBinaryNaturalRelation = this.implicitUnaryMap.get(unaryOperator);
            IntSet intSet = iBinaryNaturalRelation.getRelated(n);
            if (intSet == null) continue;
            n2 += intSet.size();
        }
        return n2;
    }

    @Override
    public Iterator<PointsToSetVariable> getVariables() {
        FilterIterator<PointsToSetVariable> filterIterator = new FilterIterator<PointsToSetVariable>(this.delegateGraph.iterator(), new Filter(){

            public boolean accepts(Object object) {
                return object instanceof IVariable;
            }
        });
        return filterIterator;
    }

    public void performVerboseAction() {
    }

    @Override
    public boolean containsStatement(IFixedPointStatement<PointsToSetVariable> iFixedPointStatement) throws IllegalArgumentException {
        if (iFixedPointStatement == null) {
            throw new IllegalArgumentException("eq == null");
        }
        if (this.useImplicitRepresentation(iFixedPointStatement)) {
            UnaryStatement unaryStatement = (UnaryStatement)iFixedPointStatement;
            return this.containsImplicitStatement(unaryStatement);
        }
        return this.delegateStatements.contains(iFixedPointStatement);
    }

    private boolean containsImplicitStatement(UnaryStatement<PointsToSetVariable> unaryStatement) {
        if (!this.containsVariable(unaryStatement.getLHS())) {
            return false;
        }
        if (!this.containsVariable(unaryStatement.getRightHandSide())) {
            return false;
        }
        int n = unaryStatement.getLHS().getGraphNodeId();
        int n2 = unaryStatement.getRightHandSide().getGraphNodeId();
        UnaryOperator unaryOperator = (UnaryOperator)unaryStatement.getOperator();
        IBinaryNaturalRelation iBinaryNaturalRelation = this.implicitUnaryMap.get(unaryOperator);
        if (iBinaryNaturalRelation != null) {
            return iBinaryNaturalRelation.contains(n, n2);
        }
        return false;
    }

    @Override
    public boolean containsVariable(PointsToSetVariable pointsToSetVariable) {
        return this.delegateGraph.containsNode(pointsToSetVariable);
    }

    @Override
    public void addStatement(IFixedPointStatement<PointsToSetVariable> iFixedPointStatement) throws IllegalArgumentException, UnimplementedError {
        if (iFixedPointStatement == null) {
            throw new IllegalArgumentException("statement == null");
        }
        if (iFixedPointStatement instanceof UnaryStatement) {
            this.addStatement((UnaryStatement)iFixedPointStatement);
        } else if (iFixedPointStatement instanceof GeneralStatement) {
            this.addStatement((GeneralStatement)iFixedPointStatement);
        } else {
            Assertions.UNREACHABLE("unexpected: " + iFixedPointStatement.getClass());
        }
    }

    public NumberedGraph<PointsToSetVariable> getAssignmentGraph() {
        return new FilteredConstraintGraphView(){

            boolean isInteresting(AbstractStatement abstractStatement) {
                return abstractStatement instanceof AssignEquation;
            }
        };
    }

    public Graph<PointsToSetVariable> getFilterAssignmentGraph() {
        return new FilteredConstraintGraphView(){

            boolean isInteresting(AbstractStatement abstractStatement) {
                return abstractStatement instanceof AssignEquation || abstractStatement.getOperator() instanceof PropagationCallGraphBuilder.FilterOperator;
            }
        };
    }

    public Graph<PointsToSetVariable> getFlowGraphIncludingImplicitConstraints() {
        return new VariableGraphView();
    }

    public String spaceReport() {
        StringBuffer stringBuffer = new StringBuffer("PropagationGraph\n");
        stringBuffer.append("ImplicitEdges:" + this.countImplicitEdges() + "\n");
        return stringBuffer.toString();
    }

    private int countImplicitEdges() {
        int n = 0;
        GlobalImplicitIterator globalImplicitIterator = new GlobalImplicitIterator();
        while (globalImplicitIterator.hasNext()) {
            globalImplicitIterator.next();
            ++n;
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DelegateGraph
    extends AbstractNumberedGraph<INodeWithNumber> {
        private int equationCount = 0;
        private int varCount = 0;

        private DelegateGraph() {
        }

        @Override
        public void addNode(INodeWithNumber iNodeWithNumber) {
            Assertions.UNREACHABLE("Don't call me");
        }

        public void addEquation(AbstractStatement<PointsToSetVariable, ?> abstractStatement) {
            assert (!PropagationGraph.this.containsStatement((IFixedPointStatement<PointsToSetVariable>)abstractStatement));
            ++this.equationCount;
            super.addNode(abstractStatement);
        }

        public void addVariable(PointsToSetVariable pointsToSetVariable) {
            if (!PropagationGraph.this.containsVariable(pointsToSetVariable)) {
                ++this.varCount;
                super.addNode(pointsToSetVariable);
            }
        }

        @Override
        protected NodeManager<INodeWithNumber> getNodeManager() {
            return PropagationGraph.this.nodeManager;
        }

        @Override
        protected EdgeManager<INodeWithNumber> getEdgeManager() {
            return PropagationGraph.this.edgeManager;
        }

        protected int getEquationCount() {
            return this.equationCount;
        }

        protected int getVarCount() {
            return this.varCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class FilteredConstraintGraphView
    extends AbstractNumberedGraph<PointsToSetVariable> {
        private FilteredConstraintGraphView() {
        }

        abstract boolean isInteresting(AbstractStatement var1);

        @Override
        public void removeNodeAndEdges(PointsToSetVariable pointsToSetVariable) {
            Assertions.UNREACHABLE();
        }

        @Override
        public Iterator<PointsToSetVariable> iterator() {
            return PropagationGraph.this.getVariables();
        }

        @Override
        public int getNumberOfNodes() {
            return PropagationGraph.this.delegateGraph.getVarCount();
        }

        @Override
        public void addNode(PointsToSetVariable pointsToSetVariable) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeNode(PointsToSetVariable pointsToSetVariable) {
            Assertions.UNREACHABLE();
        }

        @Override
        public boolean containsNode(PointsToSetVariable pointsToSetVariable) {
            Assertions.UNREACHABLE();
            return false;
        }

        @Override
        public Iterator<PointsToSetVariable> getPredNodes(PointsToSetVariable pointsToSetVariable) {
            final Iterator<AbstractStatement> iterator = PropagationGraph.this.getStatementsThatDef(pointsToSetVariable);
            return new Iterator<PointsToSetVariable>(){
                PointsToSetVariable nextResult;
                {
                    this.advance();
                }

                @Override
                public boolean hasNext() {
                    return this.nextResult != null;
                }

                @Override
                public PointsToSetVariable next() {
                    PointsToSetVariable pointsToSetVariable = this.nextResult;
                    this.advance();
                    return pointsToSetVariable;
                }

                private void advance() {
                    this.nextResult = null;
                    while (iterator.hasNext() && this.nextResult == null) {
                        AbstractStatement abstractStatement = (AbstractStatement)iterator.next();
                        if (!FilteredConstraintGraphView.this.isInteresting(abstractStatement)) continue;
                        this.nextResult = (PointsToSetVariable)((UnaryStatement)abstractStatement).getRightHandSide();
                    }
                }

                @Override
                public void remove() {
                    Assertions.UNREACHABLE();
                }
            };
        }

        @Override
        public int getPredNodeCount(PointsToSetVariable pointsToSetVariable) {
            int n = 0;
            Iterator<AbstractStatement> iterator = PropagationGraph.this.getStatementsThatDef(pointsToSetVariable);
            while (iterator.hasNext()) {
                AbstractStatement abstractStatement = iterator.next();
                if (!this.isInteresting(abstractStatement)) continue;
                ++n;
            }
            return n;
        }

        @Override
        public Iterator<PointsToSetVariable> getSuccNodes(PointsToSetVariable pointsToSetVariable) {
            final Iterator<AbstractStatement> iterator = PropagationGraph.this.getStatementsThatUse(pointsToSetVariable);
            return new Iterator<PointsToSetVariable>(){
                PointsToSetVariable nextResult;
                {
                    this.advance();
                }

                @Override
                public boolean hasNext() {
                    return this.nextResult != null;
                }

                @Override
                public PointsToSetVariable next() {
                    PointsToSetVariable pointsToSetVariable = this.nextResult;
                    this.advance();
                    return pointsToSetVariable;
                }

                private void advance() {
                    this.nextResult = null;
                    while (iterator.hasNext() && this.nextResult == null) {
                        AbstractStatement abstractStatement = (AbstractStatement)iterator.next();
                        if (!FilteredConstraintGraphView.this.isInteresting(abstractStatement)) continue;
                        this.nextResult = (PointsToSetVariable)((UnaryStatement)abstractStatement).getLHS();
                    }
                }

                @Override
                public void remove() {
                    Assertions.UNREACHABLE();
                }
            };
        }

        @Override
        public int getSuccNodeCount(PointsToSetVariable pointsToSetVariable) {
            int n = 0;
            Iterator<AbstractStatement> iterator = PropagationGraph.this.getStatementsThatUse(pointsToSetVariable);
            while (iterator.hasNext()) {
                AbstractStatement abstractStatement = iterator.next();
                if (!this.isInteresting(abstractStatement)) continue;
                ++n;
            }
            return n;
        }

        @Override
        public void addEdge(PointsToSetVariable pointsToSetVariable, PointsToSetVariable pointsToSetVariable2) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeAllIncidentEdges(PointsToSetVariable pointsToSetVariable) {
            Assertions.UNREACHABLE();
        }

        @Override
        protected NodeManager getNodeManager() {
            return PropagationGraph.this.nodeManager;
        }

        @Override
        protected EdgeManager<PointsToSetVariable> getEdgeManager() {
            Assertions.UNREACHABLE();
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GlobalImplicitIterator
    implements Iterator<AbstractStatement> {
        private final Iterator<UnaryOperator<PointsToSetVariable>> outerKeyDelegate;
        private Iterator innerDelegate;
        private UnaryOperator<PointsToSetVariable> currentOperator;

        GlobalImplicitIterator() {
            this.outerKeyDelegate = PropagationGraph.this.implicitUnaryMap.keySet().iterator();
            this.advanceOuter();
        }

        private void advanceOuter() {
            this.innerDelegate = null;
            while (this.outerKeyDelegate.hasNext()) {
                this.currentOperator = this.outerKeyDelegate.next();
                IBinaryNaturalRelation iBinaryNaturalRelation = (IBinaryNaturalRelation)PropagationGraph.this.implicitUnaryMap.get(this.currentOperator);
                Iterator iterator = iBinaryNaturalRelation.iterator();
                if (!iterator.hasNext()) continue;
                this.innerDelegate = iterator;
                return;
            }
        }

        @Override
        public boolean hasNext() {
            return this.innerDelegate != null;
        }

        @Override
        public AbstractStatement next() {
            IntPair intPair = (IntPair)this.innerDelegate.next();
            int n = intPair.getX();
            int n2 = intPair.getY();
            UnaryStatement<PointsToSetVariable> unaryStatement = this.currentOperator.makeEquation((PointsToSetVariable)PropagationGraph.this.delegateGraph.getNode(n), (PointsToSetVariable)PropagationGraph.this.delegateGraph.getNode(n2));
            if (!this.innerDelegate.hasNext()) {
                this.advanceOuter();
            }
            return unaryStatement;
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ImplicitDefIterator
    implements Iterator<AbstractStatement> {
        final PointsToSetVariable def;
        final IntIterator uses;
        final UnaryOperator<PointsToSetVariable> op;

        ImplicitDefIterator(UnaryOperator<PointsToSetVariable> unaryOperator, IntSet intSet, PointsToSetVariable pointsToSetVariable) {
            this.op = unaryOperator;
            this.def = pointsToSetVariable;
            this.uses = intSet.intIterator();
        }

        @Override
        public boolean hasNext() {
            return this.uses.hasNext();
        }

        @Override
        public AbstractStatement next() {
            int n = this.uses.next();
            PointsToSetVariable pointsToSetVariable = (PointsToSetVariable)PropagationGraph.this.delegateGraph.getNode(n);
            UnaryStatement<PointsToSetVariable> unaryStatement = this.op.makeEquation(this.def, pointsToSetVariable);
            return unaryStatement;
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ImplicitUseIterator
    implements Iterator<AbstractStatement> {
        final PointsToSetVariable use;
        final IntIterator defs;
        final UnaryOperator<PointsToSetVariable> op;

        ImplicitUseIterator(UnaryOperator<PointsToSetVariable> unaryOperator, PointsToSetVariable pointsToSetVariable, IntSet intSet) {
            this.op = unaryOperator;
            this.use = pointsToSetVariable;
            this.defs = intSet.intIterator();
        }

        @Override
        public boolean hasNext() {
            return this.defs.hasNext();
        }

        @Override
        public AbstractStatement next() {
            int n = this.defs.next();
            PointsToSetVariable pointsToSetVariable = (PointsToSetVariable)PropagationGraph.this.delegateGraph.getNode(n);
            UnaryStatement<PointsToSetVariable> unaryStatement = this.op.makeEquation(pointsToSetVariable, this.use);
            return unaryStatement;
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VariableGraphView
    extends AbstractNumberedGraph<PointsToSetVariable> {
        private VariableGraphView() {
        }

        @Override
        public void removeNodeAndEdges(PointsToSetVariable pointsToSetVariable) {
            Assertions.UNREACHABLE();
        }

        @Override
        public Iterator<PointsToSetVariable> iterator() {
            return PropagationGraph.this.getVariables();
        }

        @Override
        public int getNumberOfNodes() {
            return PropagationGraph.this.delegateGraph.getVarCount();
        }

        @Override
        public void addNode(PointsToSetVariable pointsToSetVariable) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeNode(PointsToSetVariable pointsToSetVariable) {
            Assertions.UNREACHABLE();
        }

        @Override
        public boolean containsNode(PointsToSetVariable pointsToSetVariable) {
            Assertions.UNREACHABLE();
            return false;
        }

        @Override
        public Iterator<PointsToSetVariable> getPredNodes(PointsToSetVariable pointsToSetVariable) {
            final Iterator<AbstractStatement> iterator = PropagationGraph.this.getStatementsThatDef(pointsToSetVariable);
            return new Iterator<PointsToSetVariable>(){
                Iterator<INodeWithNumber> inner;

                @Override
                public boolean hasNext() {
                    return iterator.hasNext() || this.inner != null;
                }

                @Override
                public PointsToSetVariable next() {
                    if (this.inner != null) {
                        PointsToSetVariable pointsToSetVariable = (PointsToSetVariable)this.inner.next();
                        if (!this.inner.hasNext()) {
                            this.inner = null;
                        }
                        return pointsToSetVariable;
                    }
                    AbstractStatement abstractStatement = (AbstractStatement)iterator.next();
                    if (PropagationGraph.this.useImplicitRepresentation(abstractStatement)) {
                        return (PointsToSetVariable)((UnaryStatement)abstractStatement).getRightHandSide();
                    }
                    this.inner = PropagationGraph.this.delegateGraph.getPredNodes(abstractStatement);
                    return this.next();
                }

                @Override
                public void remove() {
                    Assertions.UNREACHABLE();
                }
            };
        }

        @Override
        public int getPredNodeCount(INodeWithNumber iNodeWithNumber) {
            PointsToSetVariable pointsToSetVariable = (PointsToSetVariable)iNodeWithNumber;
            int n = 0;
            Iterator<AbstractStatement> iterator = PropagationGraph.this.getStatementsThatDef(pointsToSetVariable);
            while (iterator.hasNext()) {
                AbstractStatement abstractStatement = iterator.next();
                if (PropagationGraph.this.useImplicitRepresentation(abstractStatement)) {
                    ++n;
                    continue;
                }
                n += PropagationGraph.this.delegateGraph.getPredNodeCount(iNodeWithNumber);
            }
            return n;
        }

        @Override
        public Iterator<PointsToSetVariable> getSuccNodes(PointsToSetVariable pointsToSetVariable) {
            final Iterator<AbstractStatement> iterator = PropagationGraph.this.getStatementsThatUse(pointsToSetVariable);
            return new Iterator<PointsToSetVariable>(){
                PointsToSetVariable nextResult;
                {
                    this.advance();
                }

                @Override
                public boolean hasNext() {
                    return this.nextResult != null;
                }

                @Override
                public PointsToSetVariable next() {
                    PointsToSetVariable pointsToSetVariable = this.nextResult;
                    this.advance();
                    return pointsToSetVariable;
                }

                private void advance() {
                    this.nextResult = null;
                    while (iterator.hasNext() && this.nextResult == null) {
                        AbstractStatement abstractStatement = (AbstractStatement)iterator.next();
                        this.nextResult = (PointsToSetVariable)abstractStatement.getLHS();
                    }
                }

                @Override
                public void remove() {
                    Assertions.UNREACHABLE();
                }
            };
        }

        @Override
        public int getSuccNodeCount(PointsToSetVariable pointsToSetVariable) {
            int n = 0;
            Iterator<AbstractStatement> iterator = PropagationGraph.this.getStatementsThatUse(pointsToSetVariable);
            while (iterator.hasNext()) {
                AbstractStatement abstractStatement = iterator.next();
                Object t = abstractStatement.getLHS();
                if (t == null) continue;
                ++n;
            }
            return n;
        }

        @Override
        public void addEdge(PointsToSetVariable pointsToSetVariable, PointsToSetVariable pointsToSetVariable2) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeAllIncidentEdges(PointsToSetVariable pointsToSetVariable) {
            Assertions.UNREACHABLE();
        }

        @Override
        protected NodeManager getNodeManager() {
            return PropagationGraph.this.nodeManager;
        }

        @Override
        protected EdgeManager getEdgeManager() {
            Assertions.UNREACHABLE();
            return null;
        }
    }
}

