/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKeyWithFilter;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKeyWithFilter;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.IVector;
import com.ibm.wala.util.collections.SimpleVector;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntegerUnionFind;
import com.ibm.wala.util.intset.MutableMapping;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointsToMap {
    private final MutableMapping<PointerKey> pointerKeys = MutableMapping.make();
    private final IVector<Object> pointsToSets = new SimpleVector<Object>();
    private final IntegerUnionFind uf = new IntegerUnionFind();
    static final Object IMPLICIT = new Object(){

        public String toString() {
            return "IMPLICIT points-to set";
        }
    };
    static final Object UNIFIED = new Object(){

        public String toString() {
            return "UNIFIED points-to set";
        }
    };
    private final BitVector transitiveRoots = new BitVector();

    public Iterator<PointerKey> iterateKeys() {
        return this.pointerKeys.iterator();
    }

    public PointsToSetVariable getPointsToSet(PointerKey pointerKey) {
        if (pointerKey == null) {
            throw new IllegalArgumentException("null p");
        }
        if (this.isImplicit(pointerKey)) {
            throw new IllegalArgumentException("unexpected: shouldn't ask a PointsToMap for an implicit points-to-set: " + pointerKey);
        }
        int n = this.pointerKeys.getMappedIndex(pointerKey);
        if (n == -1) {
            return null;
        }
        int n2 = this.uf.find(n);
        PointsToSetVariable pointsToSetVariable = (PointsToSetVariable)this.pointsToSets.get(n2);
        if (pointsToSetVariable != null && pointerKey instanceof FilteredPointerKey && !(pointsToSetVariable.getPointerKey() instanceof FilteredPointerKey)) {
            this.upgradeToFilter(pointsToSetVariable, ((FilteredPointerKey)pointerKey).getTypeFilter());
        }
        return pointsToSetVariable;
    }

    public PointsToSetVariable getPointsToSet(int n) {
        int n2 = this.uf.find(n);
        return (PointsToSetVariable)this.pointsToSets.get(n2);
    }

    public void recordImplicit(PointerKey pointerKey) {
        if (pointerKey == null) {
            throw new IllegalArgumentException("null key");
        }
        int n = this.findOrCreateIndex(pointerKey);
        this.pointsToSets.set(n, IMPLICIT);
    }

    public void put(PointerKey pointerKey, PointsToSetVariable pointsToSetVariable) {
        int n = this.findOrCreateIndex(pointerKey);
        this.pointsToSets.set(n, pointsToSetVariable);
    }

    private int findOrCreateIndex(PointerKey pointerKey) {
        int n = this.pointerKeys.getMappedIndex(pointerKey);
        if (n == -1) {
            n = this.pointerKeys.add(pointerKey);
        }
        return n;
    }

    public void recordUnified(PointerKey pointerKey) {
        if (pointerKey == null) {
            throw new IllegalArgumentException("null key");
        }
        int n = this.findOrCreateIndex(pointerKey);
        this.pointsToSets.set(n, UNIFIED);
    }

    public void recordTransitiveRoot(PointerKey pointerKey) {
        if (pointerKey == null) {
            throw new IllegalArgumentException("null key");
        }
        int n = this.findOrCreateIndex(pointerKey);
        this.transitiveRoots.set(n);
    }

    boolean isTransitiveRoot(PointerKey pointerKey) {
        int n = this.findOrCreateIndex(pointerKey);
        return this.transitiveRoots.get(n);
    }

    public boolean isUnified(PointerKey pointerKey) {
        if (pointerKey == null) {
            throw new IllegalArgumentException("null p");
        }
        int n = this.findOrCreateIndex(pointerKey);
        return this.pointsToSets.get(n) == UNIFIED;
    }

    public boolean isImplicit(PointerKey pointerKey) {
        int n = this.getIndex(pointerKey);
        return n != -1 && this.pointsToSets.get(n) == IMPLICIT;
    }

    protected int getNumberOfPointerKeys() {
        return this.pointerKeys.getSize();
    }

    public void revertToPreTransitive() {
        Iterator<PointerKey> iterator = this.iterateKeys();
        while (iterator.hasNext()) {
            PointerKey pointerKey = iterator.next();
            if (this.isTransitiveRoot(pointerKey) || this.isImplicit(pointerKey) || this.isUnified(pointerKey)) continue;
            PointsToSetVariable pointsToSetVariable = this.getPointsToSet(pointerKey);
            pointsToSetVariable.removeAll();
        }
    }

    public Iterator<PointerKey> getTransitiveRoots() {
        return new FilterIterator<PointerKey>(this.iterateKeys(), new Filter(){

            public boolean accepts(Object object) {
                return PointsToMap.this.isTransitiveRoot((PointerKey)object);
            }
        });
    }

    public void unify(IntSet intSet) throws IllegalArgumentException {
        if (intSet == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (intSet.size() <= 1) {
            throw new IllegalArgumentException("Can't unify set of size " + intSet.size());
        }
        IntIterator intIterator = intSet.intIterator();
        int n = intIterator.next();
        while (intIterator.hasNext()) {
            this.unify(n, intIterator.next());
        }
    }

    public void unify(int n, int n2) {
        int n3;
        int n4 = this.uf.find(n);
        if (n4 != (n3 = this.uf.find(n2))) {
            PointsToSetVariable pointsToSetVariable = (PointsToSetVariable)this.pointsToSets.get(n4);
            PointsToSetVariable pointsToSetVariable2 = (PointsToSetVariable)this.pointsToSets.get(n3);
            if (pointsToSetVariable == null) {
                throw new IllegalArgumentException("No PointsToSetVariable for i: " + n);
            }
            if (pointsToSetVariable2 == null) {
                throw new IllegalArgumentException("No PointsToSetVariable for j: " + n2);
            }
            this.uf.union(n4, n3);
            int n5 = this.uf.find(n4);
            PointsToSetVariable pointsToSetVariable3 = (PointsToSetVariable)this.pointsToSets.get(n5);
            if (pointsToSetVariable.getValue() != null) {
                pointsToSetVariable3.addAll(pointsToSetVariable.getValue());
            }
            if (pointsToSetVariable2.getValue() != null) {
                pointsToSetVariable3.addAll(pointsToSetVariable2.getValue());
            }
            if (pointsToSetVariable3 != pointsToSetVariable) {
                this.recordUnified(pointsToSetVariable.getPointerKey());
                this.upgradeTypeFilter(pointsToSetVariable, pointsToSetVariable3);
            }
            if (pointsToSetVariable3 != pointsToSetVariable2) {
                this.recordUnified(pointsToSetVariable2.getPointerKey());
                this.upgradeTypeFilter(pointsToSetVariable2, pointsToSetVariable3);
            }
            if (this.isTransitiveRoot(pointsToSetVariable.getPointerKey()) || this.isTransitiveRoot(pointsToSetVariable2.getPointerKey())) {
                this.recordTransitiveRoot(pointsToSetVariable3.getPointerKey());
            }
        }
    }

    private void upgradeTypeFilter(PointsToSetVariable pointsToSetVariable, PointsToSetVariable pointsToSetVariable2) {
        if (pointsToSetVariable.getPointerKey() instanceof FilteredPointerKey) {
            FilteredPointerKey filteredPointerKey = (FilteredPointerKey)pointsToSetVariable.getPointerKey();
            if (pointsToSetVariable2.getPointerKey() instanceof FilteredPointerKey) {
                FilteredPointerKey filteredPointerKey2 = (FilteredPointerKey)pointsToSetVariable2.getPointerKey();
                if (!filteredPointerKey2.getTypeFilter().equals(filteredPointerKey.getTypeFilter())) {
                    Assertions.UNREACHABLE("src " + filteredPointerKey.getTypeFilter() + " dest " + filteredPointerKey2.getTypeFilter());
                }
            } else {
                this.upgradeToFilter(pointsToSetVariable2, filteredPointerKey.getTypeFilter());
            }
        }
    }

    private void upgradeToFilter(PointsToSetVariable pointsToSetVariable, FilteredPointerKey.TypeFilter typeFilter) {
        if (pointsToSetVariable.getPointerKey() instanceof LocalPointerKey) {
            LocalPointerKey localPointerKey = (LocalPointerKey)pointsToSetVariable.getPointerKey();
            LocalPointerKeyWithFilter localPointerKeyWithFilter = new LocalPointerKeyWithFilter(localPointerKey.getNode(), localPointerKey.getValueNumber(), typeFilter);
            pointsToSetVariable.setPointerKey(localPointerKeyWithFilter);
            this.pointerKeys.replace(localPointerKey, localPointerKeyWithFilter);
        } else if (pointsToSetVariable.getPointerKey() instanceof ReturnValueKey) {
            ReturnValueKey returnValueKey = (ReturnValueKey)pointsToSetVariable.getPointerKey();
            ReturnValueKeyWithFilter returnValueKeyWithFilter = new ReturnValueKeyWithFilter(returnValueKey.getNode(), typeFilter);
            pointsToSetVariable.setPointerKey(returnValueKeyWithFilter);
            this.pointerKeys.replace(returnValueKey, returnValueKeyWithFilter);
        } else {
            Assertions.UNREACHABLE(pointsToSetVariable.getPointerKey().getClass().toString());
        }
    }

    public int getIndex(PointerKey pointerKey) {
        return this.pointerKeys.getMappedIndex(pointerKey);
    }

    public int getRepresentative(int n) {
        return this.uf.find(n);
    }
}

