/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.AbstractLocalPointerKey;

public class LocalPointerKey
extends AbstractLocalPointerKey {
    private final CGNode node;
    private final int valueNumber;

    public LocalPointerKey(CGNode cGNode, int n) {
        this.node = cGNode;
        this.valueNumber = n;
        if (n <= 0) {
            throw new IllegalArgumentException("illegal valueNumber: " + n);
        }
        if (cGNode == null) {
            throw new IllegalArgumentException("null node");
        }
    }

    public final boolean equals(Object object) {
        if (object instanceof LocalPointerKey) {
            LocalPointerKey localPointerKey = (LocalPointerKey)object;
            return this.node.equals(localPointerKey.node) && this.valueNumber == localPointerKey.valueNumber;
        }
        return false;
    }

    public final int hashCode() {
        return this.node.hashCode() * 23 + this.valueNumber;
    }

    public String toString() {
        return "[" + this.node + ", v" + this.valueNumber + "]";
    }

    public final CGNode getNode() {
        return this.node;
    }

    public final int getValueNumber() {
        return this.valueNumber;
    }

    public final boolean isParameter() {
        return this.valueNumber <= this.node.getMethod().getNumberOfParameters();
    }
}

