/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.PropagationSystem;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;

public interface FilteredPointerKey
extends PointerKey {
    public TypeFilter getTypeFilter();

    public static class MultipleClassesFilter
    implements TypeFilter {
        private final IClass[] concreteType;

        public MultipleClassesFilter(IClass[] iClassArray) {
            this.concreteType = iClassArray;
        }

        public String toString() {
            return "SingleClassFilter: " + this.concreteType;
        }

        public IClass[] getConcreteTypes() {
            return this.concreteType;
        }

        public int hashCode() {
            return this.concreteType[0].hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof MultipleClassesFilter)) {
                return false;
            }
            MultipleClassesFilter multipleClassesFilter = (MultipleClassesFilter)object;
            if (this.concreteType.length != multipleClassesFilter.concreteType.length) {
                return false;
            }
            int n = 0;
            while (n < this.concreteType.length) {
                if (!this.concreteType[n].equals(multipleClassesFilter.concreteType[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private IntSet bits(PropagationSystem propagationSystem) {
            IntSet intSet = null;
            IClass[] iClassArray = this.concreteType;
            int n = this.concreteType.length;
            int n2 = 0;
            while (n2 < n) {
                IClass iClass = iClassArray[n2];
                intSet = intSet == null ? propagationSystem.getInstanceKeysForClass(iClass) : intSet.union(propagationSystem.getInstanceKeysForClass(iClass));
                ++n2;
            }
            return intSet;
        }

        public boolean addFiltered(PropagationSystem propagationSystem, PointsToSetVariable pointsToSetVariable, PointsToSetVariable pointsToSetVariable2) {
            IntSet intSet = this.bits(propagationSystem);
            return intSet == null ? false : pointsToSetVariable.addAllInIntersection(pointsToSetVariable2, intSet);
        }

        public boolean addInverseFiltered(PropagationSystem propagationSystem, PointsToSetVariable pointsToSetVariable, PointsToSetVariable pointsToSetVariable2) {
            IntSet intSet = this.bits(propagationSystem);
            return intSet == null ? pointsToSetVariable.addAll(pointsToSetVariable2) : pointsToSetVariable.addAll(IntSetUtil.diff(pointsToSetVariable2.getValue(), intSet));
        }
    }

    public static class SingleClassFilter
    implements TypeFilter {
        private final IClass concreteType;

        public SingleClassFilter(IClass iClass) {
            this.concreteType = iClass;
        }

        public String toString() {
            return "SingleClassFilter: " + this.concreteType;
        }

        public IClass getConcreteType() {
            return this.concreteType;
        }

        public int hashCode() {
            return this.concreteType.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof SingleClassFilter && ((SingleClassFilter)object).getConcreteType().equals(this.concreteType);
        }

        public boolean addFiltered(PropagationSystem propagationSystem, PointsToSetVariable pointsToSetVariable, PointsToSetVariable pointsToSetVariable2) {
            IntSet intSet = propagationSystem.getInstanceKeysForClass(this.concreteType);
            return intSet == null ? false : pointsToSetVariable.addAllInIntersection(pointsToSetVariable2, intSet);
        }

        public boolean addInverseFiltered(PropagationSystem propagationSystem, PointsToSetVariable pointsToSetVariable, PointsToSetVariable pointsToSetVariable2) {
            IntSet intSet = propagationSystem.getInstanceKeysForClass(this.concreteType);
            return intSet == null ? pointsToSetVariable.addAll(pointsToSetVariable2) : pointsToSetVariable.addAll(IntSetUtil.diff(pointsToSetVariable2.getValue(), intSet));
        }
    }

    public static class SingleInstanceFilter
    implements TypeFilter {
        private final InstanceKey concreteType;

        public SingleInstanceFilter(InstanceKey instanceKey) {
            this.concreteType = instanceKey;
        }

        public String toString() {
            return "SingleInstanceFilter: " + this.concreteType + " (" + this.concreteType.getClass() + ")";
        }

        public InstanceKey getInstance() {
            return this.concreteType;
        }

        public int hashCode() {
            return this.concreteType.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof SingleInstanceFilter && ((SingleInstanceFilter)object).getInstance().equals(this.concreteType);
        }

        public boolean addFiltered(PropagationSystem propagationSystem, PointsToSetVariable pointsToSetVariable, PointsToSetVariable pointsToSetVariable2) {
            int n = propagationSystem.findOrCreateIndexForInstanceKey(this.concreteType);
            if (pointsToSetVariable2.contains(n) && !pointsToSetVariable.contains(n)) {
                pointsToSetVariable.add(n);
                return true;
            }
            return false;
        }

        public boolean addInverseFiltered(PropagationSystem propagationSystem, PointsToSetVariable pointsToSetVariable, PointsToSetVariable pointsToSetVariable2) {
            int n = propagationSystem.findOrCreateIndexForInstanceKey(this.concreteType);
            if (!pointsToSetVariable2.contains(n) || pointsToSetVariable.contains(n)) {
                return pointsToSetVariable.addAll(pointsToSetVariable2);
            }
            MutableIntSet mutableIntSet = IntSetUtil.makeMutableCopy(pointsToSetVariable2.getValue());
            mutableIntSet.remove(n);
            return pointsToSetVariable.addAll(mutableIntSet);
        }
    }

    public static class TargetMethodFilter
    implements TypeFilter {
        private final IMethod targetMethod;

        public TargetMethodFilter(IMethod iMethod) {
            this.targetMethod = iMethod;
        }

        public String toString() {
            return "TargetMethodFilter: " + this.targetMethod;
        }

        public IMethod getMethod() {
            return this.targetMethod;
        }

        public int hashCode() {
            return this.targetMethod.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof TargetMethodFilter && ((TargetMethodFilter)object).getMethod().equals(this.targetMethod);
        }

        public boolean addFiltered(PropagationSystem propagationSystem, PointsToSetVariable pointsToSetVariable, PointsToSetVariable pointsToSetVariable2) {
            if (pointsToSetVariable2.getValue() == null) {
                return false;
            }
            UpdateAction updateAction = new UpdateAction(propagationSystem, pointsToSetVariable, true);
            pointsToSetVariable2.getValue().foreach(updateAction);
            return updateAction.result;
        }

        public boolean addInverseFiltered(PropagationSystem propagationSystem, PointsToSetVariable pointsToSetVariable, PointsToSetVariable pointsToSetVariable2) {
            if (pointsToSetVariable2.getValue() == null) {
                return false;
            }
            UpdateAction updateAction = new UpdateAction(propagationSystem, pointsToSetVariable, false);
            pointsToSetVariable2.getValue().foreach(updateAction);
            return updateAction.result;
        }

        private class UpdateAction
        implements IntSetAction {
            private boolean result = false;
            private final PointsToSetVariable L;
            private final PropagationSystem system;
            private final boolean sense;

            private UpdateAction(PropagationSystem propagationSystem, PointsToSetVariable pointsToSetVariable, boolean bl) {
                this.L = pointsToSetVariable;
                this.sense = bl;
                this.system = propagationSystem;
            }

            public void act(int n) {
                InstanceKey instanceKey = this.system.getInstanceKey(n);
                IClass iClass = instanceKey.getConcreteType();
                if (iClass.getMethod(TargetMethodFilter.this.targetMethod.getSelector()) == TargetMethodFilter.this.targetMethod == this.sense && !this.L.contains(n)) {
                    this.result = true;
                    this.L.add(n);
                }
            }
        }
    }

    public static interface TypeFilter
    extends ContextItem {
        public boolean addFiltered(PropagationSystem var1, PointsToSetVariable var2, PointsToSetVariable var3);

        public boolean addInverseFiltered(PropagationSystem var1, PointsToSetVariable var2, PointsToSetVariable var3);
    }
}

