/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.ClassHierarchyClassTargetSelector;
import com.ibm.wala.ipa.callgraph.impl.ClassHierarchyMethodTargetSelector;
import com.ibm.wala.ipa.callgraph.impl.DefaultEntrypoint;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ZeroXCFABuilder;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ZeroXContainerCFABuilder;
import com.ibm.wala.ipa.callgraph.propagation.rta.BasicRTABuilder;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.BypassClassTargetSelector;
import com.ibm.wala.ipa.summaries.BypassMethodTargetSelector;
import com.ibm.wala.ipa.summaries.XMLMethodSummaryReader;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.strings.Atom;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final String nativeSpec = "natives.xml";

    public static void addDefaultSelectors(AnalysisOptions analysisOptions, IClassHierarchy iClassHierarchy) {
        if (analysisOptions == null) {
            throw new IllegalArgumentException("options is null");
        }
        analysisOptions.setSelector(new ClassHierarchyMethodTargetSelector(iClassHierarchy));
        analysisOptions.setSelector(new ClassHierarchyClassTargetSelector(iClassHierarchy));
    }

    public static void addBypassLogic(AnalysisOptions analysisOptions, AnalysisScope analysisScope, ClassLoader classLoader, String string, IClassHierarchy iClassHierarchy) throws IllegalArgumentException {
        if (analysisScope == null) {
            throw new IllegalArgumentException("scope is null");
        }
        if (analysisOptions == null) {
            throw new IllegalArgumentException("options is null");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("cl is null");
        }
        if (iClassHierarchy == null) {
            throw new IllegalArgumentException("cha cannot be null");
        }
        InputStream inputStream = classLoader.getResourceAsStream(string);
        XMLMethodSummaryReader xMLMethodSummaryReader = new XMLMethodSummaryReader(inputStream, analysisScope);
        BypassMethodTargetSelector bypassMethodTargetSelector = new BypassMethodTargetSelector(analysisOptions.getMethodTargetSelector(), xMLMethodSummaryReader.getSummaries(), xMLMethodSummaryReader.getIgnoredPackages(), iClassHierarchy);
        analysisOptions.setSelector(bypassMethodTargetSelector);
        BypassClassTargetSelector bypassClassTargetSelector = new BypassClassTargetSelector(analysisOptions.getClassTargetSelector(), xMLMethodSummaryReader.getAllocatableClasses(), iClassHierarchy, iClassHierarchy.getLoader(analysisScope.getLoader(Atom.findOrCreateUnicodeAtom("Synthetic"))));
        analysisOptions.setSelector(bypassClassTargetSelector);
    }

    public static Iterable<Entrypoint> makeMainEntrypoints(AnalysisScope analysisScope, IClassHierarchy iClassHierarchy) {
        if (analysisScope == null) {
            throw new IllegalArgumentException("scope is null");
        }
        return Util.makeMainEntrypoints(analysisScope.getApplicationLoader(), iClassHierarchy);
    }

    public static Iterable<Entrypoint> makeMainEntrypoints(ClassLoaderReference classLoaderReference, IClassHierarchy iClassHierarchy) {
        if (iClassHierarchy == null) {
            throw new IllegalArgumentException("cha is null");
        }
        Atom atom = Atom.findOrCreateAsciiAtom("main");
        final HashSet hashSet = HashSetFactory.make();
        for (IClass iClass : iClassHierarchy) {
            MethodReference methodReference;
            IMethod iMethod;
            if (!iClass.getClassLoader().getReference().equals(classLoaderReference) || (iMethod = iClass.getMethod((methodReference = MethodReference.findOrCreate(iClass.getReference(), atom, Descriptor.findOrCreateUTF8("([Ljava/lang/String;)V"))).getSelector())) == null) continue;
            hashSet.add(new DefaultEntrypoint(iMethod, iClassHierarchy));
        }
        return new Iterable<Entrypoint>(){

            @Override
            public Iterator<Entrypoint> iterator() {
                return hashSet.iterator();
            }
        };
    }

    public static Iterable<Entrypoint> makeMainEntrypoints(AnalysisScope analysisScope, IClassHierarchy iClassHierarchy, String string) {
        return Util.makeMainEntrypoints(analysisScope, iClassHierarchy, new String[]{string});
    }

    public static Iterable<Entrypoint> makeMainEntrypoints(AnalysisScope analysisScope, IClassHierarchy iClassHierarchy, String[] stringArray) {
        if (analysisScope == null) {
            throw new IllegalArgumentException("scope is null");
        }
        return Util.makeMainEntrypoints(analysisScope.getApplicationLoader(), iClassHierarchy, stringArray);
    }

    public static Iterable<Entrypoint> makeMainEntrypoints(final ClassLoaderReference classLoaderReference, final IClassHierarchy iClassHierarchy, final String[] stringArray) throws IllegalArgumentException, IllegalArgumentException, IllegalArgumentException {
        if (stringArray == null) {
            throw new IllegalArgumentException("classNames == null");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("classNames.length == 0");
        }
        if (stringArray[0] == null && stringArray.length > 0) {
            throw new IllegalArgumentException("(0 < classNames.length) and (classNames[0] == null)");
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].indexOf("L") != 0) {
                throw new IllegalArgumentException("Expected class name to start with L " + stringArray[n]);
            }
            if (stringArray[n].indexOf(".") > 0) {
                Assertions.productionAssertion(false, "Expected class name formatted with /, not . " + stringArray[n]);
            }
            ++n;
        }
        return new Iterable<Entrypoint>(){

            @Override
            public Iterator<Entrypoint> iterator() {
                final Atom atom = Atom.findOrCreateAsciiAtom("main");
                return new Iterator<Entrypoint>(){
                    private int index = 0;

                    @Override
                    public void remove() {
                        Assertions.UNREACHABLE();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < stringArray.length;
                    }

                    @Override
                    public Entrypoint next() {
                        TypeReference typeReference = TypeReference.findOrCreate(classLoaderReference, TypeName.string2TypeName(stringArray[this.index++]));
                        MethodReference methodReference = MethodReference.findOrCreate(typeReference, atom, Descriptor.findOrCreateUTF8("([Ljava/lang/String;)V"));
                        return new DefaultEntrypoint(methodReference, iClassHierarchy);
                    }
                };
            }
        };
    }

    public static <T> Set<T> setify(Iterator<? extends T> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("Null x");
        }
        HashSet hashSet = HashSetFactory.make();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        return hashSet;
    }

    public static <T> void checkGraphSubset(Graph<T> graph, Graph<T> graph2) {
        if (graph == null) {
            throw new IllegalArgumentException("supG is null");
        }
        if (graph2 == null) {
            throw new IllegalArgumentException("subG is null");
        }
        Set set = Util.setify(graph2.iterator());
        set.removeAll(Util.setify(graph.iterator()));
        if (!set.isEmpty()) {
            System.err.println("supergraph: ");
            System.err.println(graph.toString());
            System.err.println("subgraph: ");
            System.err.println(graph2.toString());
            System.err.println("nodeDiff: ");
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                System.err.println(iterator.next().toString());
            }
            Assertions.productionAssertion(set.isEmpty(), "bad superset, see tracefile\n");
        }
        for (Object t : graph2) {
            Set set2 = Util.setify(graph2.getSuccNodes(t));
            set2.removeAll(Util.setify(graph.getSuccNodes(t)));
            if (!set2.isEmpty()) {
                Assertions.productionAssertion(set2.isEmpty(), "bad superset for successors of " + t + ":" + set2);
            }
            Set set3 = Util.setify(graph2.getPredNodes(t));
            set3.removeAll(Util.setify(graph.getPredNodes(t)));
            if (set3.isEmpty()) continue;
            System.err.println("supergraph: ");
            System.err.println(graph.toString());
            System.err.println("subgraph: ");
            System.err.println(graph2.toString());
            System.err.println("predDiff: ");
            Iterator iterator = set3.iterator();
            while (iterator.hasNext()) {
                System.err.println(iterator.next().toString());
            }
            Assertions.UNREACHABLE("bad superset for predecessors of " + t + ":" + set3);
        }
    }

    public static CallGraphBuilder makeRTABuilder(AnalysisOptions analysisOptions, AnalysisCache analysisCache, IClassHierarchy iClassHierarchy, AnalysisScope analysisScope) {
        Util.addDefaultSelectors(analysisOptions, iClassHierarchy);
        Util.addDefaultBypassLogic(analysisOptions, analysisScope, Util.class.getClassLoader(), iClassHierarchy);
        return new BasicRTABuilder(iClassHierarchy, analysisOptions, analysisCache, null, null);
    }

    public static SSAPropagationCallGraphBuilder makeZeroCFABuilder(AnalysisOptions analysisOptions, AnalysisCache analysisCache, IClassHierarchy iClassHierarchy, AnalysisScope analysisScope) {
        return Util.makeZeroCFABuilder(analysisOptions, analysisCache, iClassHierarchy, analysisScope, null, null);
    }

    public static SSAPropagationCallGraphBuilder makeZeroCFABuilder(AnalysisOptions analysisOptions, AnalysisCache analysisCache, IClassHierarchy iClassHierarchy, AnalysisScope analysisScope, ContextSelector contextSelector, SSAContextInterpreter sSAContextInterpreter) {
        if (analysisOptions == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(analysisOptions, iClassHierarchy);
        Util.addDefaultBypassLogic(analysisOptions, analysisScope, Util.class.getClassLoader(), iClassHierarchy);
        return ZeroXCFABuilder.make(iClassHierarchy, analysisOptions, analysisCache, contextSelector, sSAContextInterpreter, 0);
    }

    public static SSAPropagationCallGraphBuilder makeZeroOneCFABuilder(AnalysisOptions analysisOptions, AnalysisCache analysisCache, IClassHierarchy iClassHierarchy, AnalysisScope analysisScope) {
        return Util.makeZeroOneCFABuilder(analysisOptions, analysisCache, iClassHierarchy, analysisScope, null, null);
    }

    public static SSAPropagationCallGraphBuilder makeVanillaZeroOneCFABuilder(AnalysisOptions analysisOptions, AnalysisCache analysisCache, IClassHierarchy iClassHierarchy, AnalysisScope analysisScope, ContextSelector contextSelector, SSAContextInterpreter sSAContextInterpreter) {
        if (analysisOptions == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(analysisOptions, iClassHierarchy);
        Util.addDefaultBypassLogic(analysisOptions, analysisScope, Util.class.getClassLoader(), iClassHierarchy);
        return ZeroXCFABuilder.make(iClassHierarchy, analysisOptions, analysisCache, contextSelector, sSAContextInterpreter, 33);
    }

    public static SSAPropagationCallGraphBuilder makeVanillaZeroOneCFABuilder(AnalysisOptions analysisOptions, AnalysisCache analysisCache, IClassHierarchy iClassHierarchy, AnalysisScope analysisScope) {
        return Util.makeVanillaZeroOneCFABuilder(analysisOptions, analysisCache, iClassHierarchy, analysisScope, null, null);
    }

    public static SSAPropagationCallGraphBuilder makeZeroOneCFABuilder(AnalysisOptions analysisOptions, AnalysisCache analysisCache, IClassHierarchy iClassHierarchy, AnalysisScope analysisScope, ContextSelector contextSelector, SSAContextInterpreter sSAContextInterpreter) {
        if (analysisOptions == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(analysisOptions, iClassHierarchy);
        Util.addDefaultBypassLogic(analysisOptions, analysisScope, Util.class.getClassLoader(), iClassHierarchy);
        return ZeroXCFABuilder.make(iClassHierarchy, analysisOptions, analysisCache, contextSelector, sSAContextInterpreter, 31);
    }

    public static SSAPropagationCallGraphBuilder makeZeroContainerCFABuilder(AnalysisOptions analysisOptions, AnalysisCache analysisCache, IClassHierarchy iClassHierarchy, AnalysisScope analysisScope) {
        if (analysisOptions == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(analysisOptions, iClassHierarchy);
        Util.addDefaultBypassLogic(analysisOptions, analysisScope, Util.class.getClassLoader(), iClassHierarchy);
        ContextSelector contextSelector = null;
        SSAContextInterpreter sSAContextInterpreter = null;
        return new ZeroXContainerCFABuilder(iClassHierarchy, analysisOptions, analysisCache, contextSelector, sSAContextInterpreter, 0);
    }

    public static SSAPropagationCallGraphBuilder makeZeroOneContainerCFABuilder(AnalysisOptions analysisOptions, AnalysisCache analysisCache, IClassHierarchy iClassHierarchy, AnalysisScope analysisScope) {
        if (analysisOptions == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(analysisOptions, iClassHierarchy);
        Util.addDefaultBypassLogic(analysisOptions, analysisScope, Util.class.getClassLoader(), iClassHierarchy);
        ContextSelector contextSelector = null;
        SSAContextInterpreter sSAContextInterpreter = null;
        return new ZeroXContainerCFABuilder(iClassHierarchy, analysisOptions, analysisCache, contextSelector, sSAContextInterpreter, 31);
    }

    public static SSAPropagationCallGraphBuilder makeVanillaZeroOneContainerCFABuilder(AnalysisOptions analysisOptions, AnalysisCache analysisCache, IClassHierarchy iClassHierarchy, AnalysisScope analysisScope) {
        if (analysisOptions == null) {
            throw new IllegalArgumentException("options is null");
        }
        Util.addDefaultSelectors(analysisOptions, iClassHierarchy);
        Util.addDefaultBypassLogic(analysisOptions, analysisScope, Util.class.getClassLoader(), iClassHierarchy);
        ContextSelector contextSelector = null;
        SSAContextInterpreter sSAContextInterpreter = null;
        analysisOptions.setUseConstantSpecificKeys(true);
        return new ZeroXContainerCFABuilder(iClassHierarchy, analysisOptions, analysisCache, contextSelector, sSAContextInterpreter, 1);
    }

    public static void addDefaultBypassLogic(AnalysisOptions analysisOptions, AnalysisScope analysisScope, ClassLoader classLoader, IClassHierarchy iClassHierarchy) {
        Util.addBypassLogic(analysisOptions, analysisScope, classLoader, nativeSpec, iClassHierarchy);
    }
}

