/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.BasicCallGraph;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.FakeRootMethod;
import com.ibm.wala.ipa.callgraph.impl.FakeWorldClinitMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.BytecodeConstants;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.IntMapIterator;
import com.ibm.wala.util.collections.SparseVector;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.functions.IntFunction;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplicitCallGraph
extends BasicCallGraph
implements BytecodeConstants {
    protected final IClassHierarchy cha;
    protected final AnalysisOptions options;
    private final AnalysisCache cache;
    private final long maxNumberOfNodes;
    private final ExplicitEdgeManager edgeManager = this.makeEdgeManger();

    public ExplicitCallGraph(IClassHierarchy iClassHierarchy, AnalysisOptions analysisOptions, AnalysisCache analysisCache) {
        if (analysisOptions == null) {
            throw new IllegalArgumentException("null options");
        }
        if (analysisCache == null) {
            throw new IllegalArgumentException("null cache");
        }
        this.cha = iClassHierarchy;
        this.options = analysisOptions;
        this.cache = analysisCache;
        this.maxNumberOfNodes = analysisOptions.getMaxNumberOfNodes();
    }

    protected ExplicitNode makeNode(IMethod iMethod, Context context) {
        return new ExplicitNode(iMethod, context);
    }

    @Override
    protected CGNode makeFakeRootNode() throws CancelException {
        return this.findOrCreateNode(new FakeRootMethod(this.cha, this.options, this.cache), Everywhere.EVERYWHERE);
    }

    @Override
    protected CGNode makeFakeWorldClinitNode() throws CancelException {
        return this.findOrCreateNode(new FakeWorldClinitMethod(this.cha, this.options, this.cache), Everywhere.EVERYWHERE);
    }

    @Override
    public CGNode findOrCreateNode(IMethod iMethod, Context context) throws CancelException {
        if (iMethod == null) {
            throw new IllegalArgumentException("null method");
        }
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        BasicCallGraph.Key key = new BasicCallGraph.Key(iMethod, context);
        BasicCallGraph.NodeImpl nodeImpl = this.getNode(key);
        if (nodeImpl == null) {
            if (this.maxNumberOfNodes == -1L || (long)this.getNumberOfNodes() < this.maxNumberOfNodes) {
                nodeImpl = this.makeNode(iMethod, context);
                this.registerNode(key, nodeImpl);
            } else {
                throw CancelException.make("Too many nodes");
            }
        }
        return nodeImpl;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    @Override
    public EdgeManager<CGNode> getEdgeManager() {
        return this.edgeManager;
    }

    protected ExplicitEdgeManager makeEdgeManger() {
        return new ExplicitEdgeManager();
    }

    @Override
    public int getNumberOfTargets(CGNode cGNode, CallSiteReference callSiteReference) {
        if (!this.containsNode(cGNode)) {
            throw new IllegalArgumentException("node not in callgraph " + cGNode);
        }
        assert (cGNode instanceof ExplicitNode);
        ExplicitNode explicitNode = (ExplicitNode)cGNode;
        return explicitNode.getNumberOfTargets(callSiteReference);
    }

    @Override
    public Iterator<CallSiteReference> getPossibleSites(CGNode cGNode, CGNode cGNode2) {
        if (!this.containsNode(cGNode)) {
            throw new IllegalArgumentException("node not in callgraph " + cGNode);
        }
        if (!this.containsNode(cGNode2)) {
            throw new IllegalArgumentException("node not in callgraph " + cGNode2);
        }
        assert (cGNode instanceof ExplicitNode);
        ExplicitNode explicitNode = (ExplicitNode)cGNode;
        return explicitNode.getPossibleSites(cGNode2);
    }

    @Override
    public Set<CGNode> getPossibleTargets(CGNode cGNode, CallSiteReference callSiteReference) {
        if (!this.containsNode(cGNode)) {
            throw new IllegalArgumentException("node not in callgraph " + cGNode);
        }
        assert (cGNode instanceof ExplicitNode);
        ExplicitNode explicitNode = (ExplicitNode)cGNode;
        return explicitNode.getPossibleTargets(callSiteReference);
    }

    public IntSet getPossibleTargetNumbers(CGNode cGNode, CallSiteReference callSiteReference) {
        if (!this.containsNode(cGNode)) {
            throw new IllegalArgumentException("node not in callgraph " + cGNode);
        }
        assert (cGNode instanceof ExplicitNode);
        ExplicitNode explicitNode = (ExplicitNode)cGNode;
        return explicitNode.getPossibleTargetNumbers(callSiteReference);
    }

    public AnalysisCache getAnalysisCache() {
        return this.cache;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ExplicitEdgeManager
    implements NumberedEdgeManager<CGNode> {
        final IntFunction<CGNode> toNode = new IntFunction<CGNode>(){

            @Override
            public CGNode apply(int n) {
                CGNode cGNode = (CGNode)ExplicitCallGraph.this.getNode(n);
                return cGNode;
            }
        };
        final IBinaryNaturalRelation predecessors = new BasicNaturalRelation(new byte[]{2}, 0);

        protected ExplicitEdgeManager() {
        }

        @Override
        public IntSet getSuccNodeNumbers(CGNode cGNode) {
            ExplicitNode explicitNode = (ExplicitNode)cGNode;
            return explicitNode.getAllTargetNumbers();
        }

        @Override
        public IntSet getPredNodeNumbers(CGNode cGNode) {
            ExplicitNode explicitNode = (ExplicitNode)cGNode;
            int n = ExplicitCallGraph.this.getNumber(explicitNode);
            return this.predecessors.getRelated(n);
        }

        @Override
        public Iterator<CGNode> getPredNodes(CGNode cGNode) {
            IntSet intSet = this.getPredNodeNumbers(cGNode);
            if (intSet == null) {
                return EmptyIterator.instance();
            }
            return new IntMapIterator<CGNode>(intSet.intIterator(), this.toNode);
        }

        @Override
        public int getPredNodeCount(CGNode cGNode) {
            ExplicitNode explicitNode = (ExplicitNode)cGNode;
            int n = ExplicitCallGraph.this.getNumber(explicitNode);
            return this.predecessors.getRelatedCount(n);
        }

        @Override
        public Iterator<CGNode> getSuccNodes(CGNode cGNode) {
            ExplicitNode explicitNode = (ExplicitNode)cGNode;
            return new IntMapIterator<CGNode>(explicitNode.getAllTargetNumbers().intIterator(), this.toNode);
        }

        @Override
        public int getSuccNodeCount(CGNode cGNode) {
            ExplicitNode explicitNode = (ExplicitNode)cGNode;
            return explicitNode.getAllTargetNumbers().size();
        }

        @Override
        public void addEdge(CGNode cGNode, CGNode cGNode2) {
            int n = ExplicitCallGraph.this.getNumber(cGNode);
            int n2 = ExplicitCallGraph.this.getNumber(cGNode2);
            this.predecessors.add(n2, n);
        }

        @Override
        public void removeEdge(CGNode cGNode, CGNode cGNode2) {
            int n = ExplicitCallGraph.this.getNumber(cGNode);
            int n2 = ExplicitCallGraph.this.getNumber(cGNode2);
            this.predecessors.remove(n2, n);
        }

        @Override
        protected void addEdge(int n, int n2) {
            this.predecessors.add(n2, n);
        }

        @Override
        public void removeAllIncidentEdges(CGNode cGNode) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeIncomingEdges(CGNode cGNode) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeOutgoingEdges(CGNode cGNode) {
            Assertions.UNREACHABLE();
        }

        @Override
        public boolean hasEdge(CGNode cGNode, CGNode cGNode2) {
            int n = ExplicitCallGraph.this.getNumber(cGNode);
            int n2 = ExplicitCallGraph.this.getNumber(cGNode2);
            return this.predecessors.contains(n2, n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExplicitNode
    extends BasicCallGraph.NodeImpl {
        protected final SparseVector<Object> targets;
        private final MutableSharedBitVectorIntSet allTargets;

        protected ExplicitNode(IMethod iMethod, Context context) {
            super(iMethod, context);
            this.targets = new SparseVector();
            this.allTargets = new MutableSharedBitVectorIntSet();
        }

        protected Set<CGNode> getPossibleTargets(CallSiteReference callSiteReference) {
            Object object = this.targets.get(callSiteReference.getProgramCounter());
            if (object == null) {
                return Collections.emptySet();
            }
            if (object instanceof CGNode) {
                Set<CGNode> set = Collections.singleton((CGNode)object);
                return set;
            }
            IntSet intSet = (IntSet)object;
            HashSet<CGNode> hashSet = HashSetFactory.make(intSet.size());
            IntIterator intIterator = intSet.intIterator();
            while (intIterator.hasNext()) {
                hashSet.add((CGNode)this.getCallGraph().getNode(intIterator.next()));
            }
            return hashSet;
        }

        protected IntSet getPossibleTargetNumbers(CallSiteReference callSiteReference) {
            Object object = this.targets.get(callSiteReference.getProgramCounter());
            if (object == null) {
                return null;
            }
            if (object instanceof CGNode) {
                return SparseIntSet.singleton(this.getCallGraph().getNumber((CGNode)object));
            }
            return (IntSet)object;
        }

        protected Iterator<CallSiteReference> getPossibleSites(CGNode cGNode) {
            final int n = this.getCallGraph().getNumber(cGNode);
            return new FilterIterator<CallSiteReference>(this.iterateCallSites(), new Filter(){

                public boolean accepts(Object object) {
                    IntSet intSet = ExplicitNode.this.getPossibleTargetNumbers((CallSiteReference)object);
                    return intSet == null ? false : intSet.contains(n);
                }
            });
        }

        protected int getNumberOfTargets(CallSiteReference callSiteReference) {
            Object object = this.targets.get(callSiteReference.getProgramCounter());
            if (object == null) {
                return 0;
            }
            if (object instanceof CGNode) {
                return 1;
            }
            return ((IntSet)object).size();
        }

        @Override
        public boolean addTarget(CallSiteReference callSiteReference, CGNode cGNode) {
            return this.addTarget(callSiteReference.getProgramCounter(), cGNode);
        }

        protected boolean addTarget(int n, CGNode cGNode) {
            this.allTargets.add(this.getCallGraph().getNumber(cGNode));
            Object object = this.targets.get(n);
            if (object == null) {
                object = cGNode;
                this.targets.set(n, object);
                this.getCallGraph().addEdge(this, cGNode);
                return true;
            }
            if (object instanceof CGNode) {
                if (object.equals(cGNode)) {
                    return false;
                }
                MutableSharedBitVectorIntSet mutableSharedBitVectorIntSet = new MutableSharedBitVectorIntSet();
                mutableSharedBitVectorIntSet.add(this.getCallGraph().getNumber((CGNode)object));
                mutableSharedBitVectorIntSet.add(this.getCallGraph().getNumber(cGNode));
                this.getCallGraph().addEdge(this, cGNode);
                this.targets.set(n, mutableSharedBitVectorIntSet);
                return true;
            }
            MutableIntSet mutableIntSet = (MutableIntSet)object;
            int n2 = this.getCallGraph().getNumber(cGNode);
            if (!mutableIntSet.contains(n2)) {
                mutableIntSet.add(n2);
                this.getCallGraph().addEdge(this, cGNode);
                return true;
            }
            return false;
        }

        public void removeTarget(CGNode cGNode) {
            this.allTargets.remove(this.getCallGraph().getNumber(cGNode));
            IntIterator intIterator = this.targets.safeIterateIndices();
            while (intIterator.hasNext()) {
                int n = intIterator.next();
                Object object = this.targets.get(n);
                if (object instanceof CGNode) {
                    if (!object.equals(cGNode)) continue;
                    this.targets.remove(n);
                    continue;
                }
                MutableIntSet mutableIntSet = (MutableIntSet)object;
                int n2 = this.getCallGraph().getNumber(cGNode);
                if (mutableIntSet.size() > 2) {
                    mutableIntSet.remove(n2);
                    continue;
                }
                assert (mutableIntSet.size() == 2);
                if (!mutableIntSet.contains(n2)) continue;
                mutableIntSet.remove(n2);
                int n3 = mutableIntSet.intIterator().next();
                this.targets.set(n, this.getCallGraph().getNode(n3));
            }
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }

        @Override
        public int hashCode() {
            return this.getMethod().hashCode() * 8681 + this.getContext().hashCode();
        }

        protected MutableSharedBitVectorIntSet getAllTargetNumbers() {
            return this.allTargets;
        }

        public void clearAllTargets() {
            this.targets.clear();
            this.allTargets.clear();
        }

        @Override
        public IR getIR() {
            return this.getCallGraph().getInterpreter(this).getIR(this);
        }

        @Override
        public DefUse getDU() {
            return this.getCallGraph().getInterpreter(this).getDU(this);
        }

        public ExplicitCallGraph getCallGraph() {
            return ExplicitCallGraph.this;
        }

        @Override
        public Iterator<CallSiteReference> iterateCallSites() {
            return this.getCallGraph().getInterpreter(this).iterateCallSites(this);
        }

        @Override
        public Iterator<NewSiteReference> iterateNewSites() {
            return this.getCallGraph().getInterpreter(this).iterateNewSites(this);
        }

        public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG() {
            return this.getCallGraph().getInterpreter(this).getCFG(this);
        }
    }
}

