/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import java.util.Arrays;

public class DefaultEntrypoint
extends Entrypoint {
    private final TypeReference[][] paramTypes;
    private final IClassHierarchy cha;

    public DefaultEntrypoint(IMethod iMethod, IClassHierarchy iClassHierarchy) {
        super(iMethod);
        if (iMethod == null) {
            throw new IllegalArgumentException("method is null");
        }
        this.cha = iClassHierarchy;
        this.paramTypes = this.makeParameterTypes(iMethod);
        assert (this.paramTypes != null) : iMethod.toString();
    }

    public DefaultEntrypoint(MethodReference methodReference, IClassHierarchy iClassHierarchy) {
        super(methodReference, iClassHierarchy);
        if (methodReference == null) {
            throw new IllegalArgumentException("method is null");
        }
        this.cha = iClassHierarchy;
        this.paramTypes = this.makeParameterTypes(this.getMethod());
        assert (this.paramTypes != null) : methodReference.toString();
    }

    protected TypeReference[][] makeParameterTypes(IMethod iMethod) {
        TypeReference[][] typeReferenceArray = new TypeReference[iMethod.getNumberOfParameters()][];
        int n = 0;
        while (n < typeReferenceArray.length) {
            typeReferenceArray[n] = this.makeParameterTypes(iMethod, n);
            ++n;
        }
        return typeReferenceArray;
    }

    protected TypeReference[] makeParameterTypes(IMethod iMethod, int n) {
        return new TypeReference[]{iMethod.getParameterType(n)};
    }

    public TypeReference[] getParameterTypes(int n) {
        return this.paramTypes[n];
    }

    public void setParameterTypes(int n, TypeReference[] typeReferenceArray) {
        this.paramTypes[n] = typeReferenceArray;
    }

    public int getNumberOfParameters() {
        return this.paramTypes.length;
    }

    public IClassHierarchy getCha() {
        return this.cha;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + Arrays.hashCode((Object[])this.paramTypes);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DefaultEntrypoint defaultEntrypoint = (DefaultEntrypoint)object;
        return Arrays.equals((Object[])this.paramTypes, (Object[])defaultEntrypoint.paramTypes);
    }
}

